/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.PortInUseException;
import com.sun.enterprise.ee.admin.configbeans.PortConflictCheckerConfigBean;
import com.sun.enterprise.ee.admin.configbeans.ServersConfigBean;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyConfigBean
extends BaseConfigBean
implements IAdminConstants {
    private static final TargetType[] VALID_TYPES = new TargetType[]{TargetType.DOMAIN, TargetType.CONFIG, TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS};
    private static final StringManager _strMgr = StringManager.getManager(PropertyConfigBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(PropertyConfigBean.getLogger());
        }
        return _handler;
    }

    public PropertyConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    private void addProperties(Properties props, SystemProperty[] sysProps) {
        if (sysProps != null) {
            for (int i = 0; i < sysProps.length; ++i) {
                props.setProperty(sysProps[i].getName(), sysProps[i].getValue());
            }
        }
    }

    Properties getTargetedProperties(String targetName, boolean inherit) throws ConfigException {
        ConfigContext configContext = this.getConfigContext();
        Target target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, targetName, configContext);
        Properties result = new Properties();
        if (target.getType() == TargetType.DOMAIN) {
            Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
            this.addProperties(result, domain.getSystemProperty());
        } else if (target.getType() == TargetType.CONFIG) {
            if (inherit) {
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
                this.addProperties(result, domain.getSystemProperty());
            }
            Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)target.getName());
            this.addProperties(result, config.getSystemProperty());
        } else if (target.getType() == TargetType.CLUSTER) {
            if (inherit) {
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
                this.addProperties(result, domain.getSystemProperty());
                Config config = ClusterHelper.getConfigForCluster((ConfigContext)configContext, (String)target.getName());
                this.addProperties(result, config.getSystemProperty());
            }
            Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)configContext, (String)target.getName());
            this.addProperties(result, cluster.getSystemProperty());
        } else if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
            Server server = ServerHelper.getServerByName((ConfigContext)configContext, (String)target.getName());
            if (inherit) {
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
                this.addProperties(result, domain.getSystemProperty());
                Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)server.getConfigRef());
                this.addProperties(result, config.getSystemProperty());
                if (ServerHelper.isServerClustered((ConfigContext)configContext, (String)target.getName())) {
                    Cluster cluster = ClusterHelper.getClusterForInstance((ConfigContext)configContext, (String)target.getName());
                    this.addProperties(result, cluster.getSystemProperty());
                }
            }
            this.addProperties(result, server.getSystemProperty());
        } else {
            throw new ConfigException(_strMgr.getString("invalidPropertyTarget", (Object)target.getName()));
        }
        return result;
    }

    public Properties listSystemProperties(String targetName, boolean inherit) throws ConfigException {
        try {
            return this.getTargetedProperties(targetName, inherit);
        }
        catch (Exception ex) {
            throw PropertyConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listProperties.Exception", targetName);
        }
    }

    public String[] listSystemPropertiesAsString(String targetName, boolean inherit) throws ConfigException {
        try {
            Properties props = this.getTargetedProperties(targetName, inherit);
            String[] result = new String[props.size()];
            int i = 0;
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                result[i] = name + "=" + value;
                ++i;
            }
            return result;
        }
        catch (Exception ex) {
            throw PropertyConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listProperties.Exception", targetName);
        }
    }

    private SystemProperty getSystemProperty(Properties props, String name) {
        SystemProperty sysProp = new SystemProperty();
        sysProp.setName(name);
        sysProp.setValue(props.getProperty(name));
        return sysProp;
    }

    private void createServerProperties(Target target, Properties props) throws Exception {
        SystemProperty sysProp;
        ConfigContext configContext = this.getConfigContext();
        Server server = ServerHelper.getServerByName((ConfigContext)configContext, (String)target.getName());
        ArrayList<SystemProperty> removedProperties = new ArrayList<SystemProperty>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sysProp = server.getSystemPropertyByName(name);
            if (sysProp != null) {
                SystemProperty newProp = new SystemProperty();
                newProp.setName(sysProp.getName());
                newProp.setValue(sysProp.getValue());
                server.removeSystemProperty(sysProp, true);
                removedProperties.add(newProp);
            }
            server.addSystemProperty(this.getSystemProperty(props, name), true);
        }
        try {
            PortConflictCheckerConfigBean portChecker = this.getPortConflictCheckerConfigBean();
            ServersConfigBean scb = this.getServersConfigBean();
            portChecker.checkForPortConflicts(server, props, scb.isRunning(server.getName()));
        }
        catch (Exception ex2) {
            try {
                Enumeration<?> e2 = props.propertyNames();
                while (e2.hasMoreElements()) {
                    String name = (String)e2.nextElement();
                    SystemProperty sysProp2 = server.getSystemPropertyByName(name);
                    if (sysProp2 == null) continue;
                    server.removeSystemProperty(sysProp2, true);
                }
                for (int i = 0; i < removedProperties.size(); ++i) {
                    sysProp = (SystemProperty)removedProperties.get(i);
                    server.addSystemProperty((SystemProperty)removedProperties.get(i), true);
                }
            }
            catch (Exception ex3) {
                StringManagerBase sm = StringManagerBase.getStringManager((String)PropertyConfigBean.getLogger().getResourceBundleName());
                PropertyConfigBean.getLogger().log(Level.WARNING, sm.getString("eeadmin.createProperties.Exception", (Object)target.getName()), ex3);
            }
            if (ex2 instanceof PortInUseException) {
                throw new ConfigException(ex2.getMessage());
            }
            throw ex2;
        }
    }

    public void createSystemProperties(Properties props, String targetName) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, targetName, configContext);
            if (target.getType() == TargetType.DOMAIN) {
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    SystemProperty sysProp = domain.getSystemPropertyByName(name);
                    if (sysProp != null) {
                        domain.removeSystemProperty(sysProp, true);
                    }
                    domain.addSystemProperty(this.getSystemProperty(props, name), true);
                }
            } else if (target.getType() == TargetType.CONFIG) {
                Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)target.getName());
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    SystemProperty sysProp = config.getSystemPropertyByName(name);
                    if (sysProp != null) {
                        config.removeSystemProperty(sysProp, true);
                    }
                    config.addSystemProperty(this.getSystemProperty(props, name), true);
                }
            } else if (target.getType() == TargetType.CLUSTER) {
                Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)configContext, (String)target.getName());
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    SystemProperty sysProp = cluster.getSystemPropertyByName(name);
                    if (sysProp != null) {
                        cluster.removeSystemProperty(sysProp, true);
                    }
                    cluster.addSystemProperty(this.getSystemProperty(props, name), true);
                }
            } else if (target.getType() == TargetType.SERVER || target.getType() == TargetType.DAS) {
                this.createServerProperties(target, props);
            } else {
                throw new ConfigException(_strMgr.getString("invalidPropertyTarget", (Object)target.getName()));
            }
            this.flushAll();
        }
        catch (Exception ex) {
            throw PropertyConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.createProperties.Exception", targetName);
        }
    }

    public void deleteSystemProperty(String propertyName, String targetName) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, targetName, configContext);
            if (target.getType().equals((Object)TargetType.DOMAIN)) {
                Domain domain = ConfigAPIHelper.getDomainConfigBean((ConfigContext)configContext);
                SystemProperty sysProp = domain.getSystemPropertyByName(propertyName);
                if (sysProp == null) {
                    throw new ConfigException(_strMgr.getString("propertyDoesNotExist", (Object)propertyName, (Object)target.getName()));
                }
                domain.removeSystemProperty(sysProp, true);
            } else if (target.getType().equals((Object)TargetType.CONFIG)) {
                Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)target.getName());
                SystemProperty sysProp = config.getSystemPropertyByName(propertyName);
                if (sysProp == null) {
                    throw new ConfigException(_strMgr.getString("propertyDoesNotExist", (Object)propertyName, (Object)target.getName()));
                }
                config.removeSystemProperty(sysProp, true);
            } else if (target.getType().equals((Object)TargetType.CLUSTER)) {
                Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)configContext, (String)target.getName());
                SystemProperty sysProp = cluster.getSystemPropertyByName(propertyName);
                if (sysProp == null) {
                    throw new ConfigException(_strMgr.getString("propertyDoesNotExist", (Object)propertyName, (Object)target.getName()));
                }
                cluster.removeSystemProperty(sysProp, true);
            } else if (target.getType().equals((Object)TargetType.SERVER) || target.getType().equals((Object)TargetType.DAS)) {
                Server server = ServerHelper.getServerByName((ConfigContext)configContext, (String)target.getName());
                SystemProperty sysProp = server.getSystemPropertyByName(propertyName);
                if (sysProp == null) {
                    throw new ConfigException(_strMgr.getString("propertyDoesNotExist", (Object)propertyName, (Object)target.getName()));
                }
                SystemProperty removedProp = new SystemProperty();
                removedProp.setName(sysProp.getName());
                removedProp.setValue(sysProp.getValue());
                server.removeSystemProperty(sysProp, true);
            } else {
                throw new ConfigException(_strMgr.getString("invalidPropertyTarget", (Object)target.getName()));
            }
            this.flushAll();
        }
        catch (Exception ex) {
            throw PropertyConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.deleteProperty.Exception", new String[]{propertyName, targetName});
        }
    }

    private PortConflictCheckerConfigBean getPortConflictCheckerConfigBean() {
        return new PortConflictCheckerConfigBean(this.getConfigContext());
    }

    private ServersConfigBean getServersConfigBean() {
        return new ServersConfigBean(this.getConfigContext());
    }
}

