/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.configbeans;

import com.sun.enterprise.admin.configbeans.BaseConfigBean;
import com.sun.enterprise.admin.configbeans.ResourceReferenceHelper;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ResourcesConfigBean
extends BaseConfigBean
implements IAdminConstants {
    private static final TargetType[] VALID_LIST_TYPES = new TargetType[]{TargetType.CLUSTER, TargetType.SERVER, TargetType.DAS};
    private static final StringManager _strMgr = StringManager.getManager(ResourcesConfigBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;
    private static final String[] mappedTypes = new String[]{"CustomResource", "custom-resource", "ExternalJndiResource", "external-jndi-resource", "JdbcResource", "jdbc-resource", "MailResource", "mail-resource", "AdminObjectResource", "admin-object-resource", "ConnectorResource", "connector-resource", "ResourceAdapterConfig", "resource-adapter-config", "JdbcConnectionPool", "jdbc-connection-pool", "ConnectorConnectionPool", "connector-connection-pool", "PersistenceManagerFactoryResource", "persistence-manager-factory-resource"};

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    private ResourceReferenceHelper getResourceReferenceHelper() {
        return new ResourceReferenceHelper(this.getConfigContext());
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ResourcesConfigBean.getLogger());
        }
        return _handler;
    }

    public ResourcesConfigBean(ConfigContext configContext) {
        super(configContext);
    }

    public void createResourceReference(String targetName, boolean enabled, String referenceName) throws ConfigException {
        try {
            this.getResourceReferenceHelper().createResourceReference(targetName, enabled, referenceName);
        }
        catch (Exception ex) {
            throw ResourcesConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.createResourceReference.Exception", new String[]{referenceName, targetName});
        }
    }

    public void deleteResourceReference(String targetName, String referenceName) throws ConfigException {
        try {
            this.getResourceReferenceHelper().deleteResourceReference(targetName, referenceName);
        }
        catch (Exception ex) {
            throw ResourcesConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.deleteResourceReference.Exception", new String[]{referenceName, targetName});
        }
    }

    public String[] listResourceReferencesAsString(String targetName) throws ConfigException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_LIST_TYPES, targetName, configContext);
            String refName = null;
            ResourceRef[] refs = target.getResourceRefs();
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < refs.length; ++i) {
                refName = refs[i].getRef();
                if (ResourceHelper.isSystemResource((ConfigContext)configContext, (String)refName)) continue;
                result.add(refName);
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception ex) {
            throw ResourcesConfigBean.getExceptionHandler().handleConfigException(ex, "eeadmin.listResourceReferences.Exception", targetName);
        }
    }

    public String getResourceType(String id) throws ConfigException {
        String type = ResourceHelper.getResourceType((ConfigContext)this.getConfigContext(), (String)id);
        if (null == type) {
            throw new ConfigException(_strMgr.getString("noSuchResource", (Object)id));
        }
        String externalType = ResourceTypeMapper.extern(type);
        assert (externalType != null) : "No external mapping found for " + type;
        return externalType;
    }

    private static final class ResourceTypeMapper {
        private ResourceTypeMapper() {
        }

        private static String extern(String internalType) {
            for (int i = 0; i < mappedTypes.length; i += 2) {
                if (!mappedTypes[i].equals(internalType)) continue;
                return mappedTypes[i + 1];
            }
            return null;
        }
    }
}

