/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfo;
import com.sun.enterprise.ee.admin.dottedname.DottedNameClusterInfoImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class DottedNameClusterInfoCache
implements DottedNameClusterInfo {
    final DottedNameClusterInfo mSrc;
    Set mConfigNames;
    Set mClusterNames;
    HashMap mClusterToServers;
    HashMap mClusterToConfig;
    HashMap mConfigToClusters;
    HashMap mResourceToTargets;
    HashMap mAppToTargets;

    public DottedNameClusterInfoCache(DottedNameClusterInfo src) {
        this.mSrc = src;
        this.mConfigNames = Collections.EMPTY_SET;
        this.mClusterNames = Collections.EMPTY_SET;
        this.mClusterToConfig = new HashMap();
        this.mConfigToClusters = new HashMap();
        this.mResourceToTargets = new HashMap();
        this.mAppToTargets = new HashMap();
        this.mClusterToServers = new HashMap();
    }

    public synchronized Set getConfigNames() throws DottedNameServerInfo.UnavailableException {
        return this.mConfigNames;
    }

    public synchronized Set getClusterNames() throws DottedNameServerInfo.UnavailableException {
        return this.mClusterNames;
    }

    public synchronized String getConfigNameForCluster(String clusterName) throws DottedNameServerInfo.UnavailableException {
        return (String)this.mClusterToConfig.get(clusterName);
    }

    public synchronized String[] getClusterNamesForConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        return (String[])this.mConfigToClusters.get(configName);
    }

    public synchronized String[] getServerNamesForCluster(String clusterName) throws DottedNameServerInfo.UnavailableException {
        return (String[])this.mClusterToServers.get(clusterName);
    }

    public boolean isClusteredInstance(String serverName) {
        return this.mSrc.isClusteredInstance(serverName);
    }

    public synchronized Set getResourceNamesForCluster(String clusterName) throws DottedNameServerInfo.UnavailableException {
        try {
            return this.mSrc.getResourceNamesForCluster(clusterName);
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
    }

    public synchronized Set getApplicationNamesForCluster(String clusterName) throws DottedNameServerInfo.UnavailableException {
        try {
            return this.mSrc.getApplicationNamesForCluster(clusterName);
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
    }

    public synchronized String[] getTargetsSharingResource(String resourceName) throws DottedNameServerInfo.UnavailableException {
        try {
            return this.mSrc.getTargetsSharingResource(resourceName);
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
    }

    public String[] getTargetsSharingConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        try {
            return this.mSrc.getTargetsSharingConfig(configName);
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
    }

    public synchronized String[] getTargetsSharingApplication(String appName) throws DottedNameServerInfo.UnavailableException {
        try {
            return this.mSrc.getTargetsSharingApplication(appName);
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
    }

    public synchronized void refresh() {
        try {
            this._refresh();
        }
        catch (DottedNameServerInfo.UnavailableException e) {
            DottedNameLogger.logException((Exception)((Object)e));
        }
    }

    void _refresh() throws DottedNameServerInfo.UnavailableException {
        try {
            this.resetCache();
            this.mConfigNames = this.mSrc.getConfigNames();
            this.mClusterNames = this.mSrc.getClusterNames();
            this.createConfigClusterMappings();
            this.createClusterToServersMapping();
        }
        catch (Exception e) {
            throw new DottedNameServerInfo.UnavailableException((Throwable)e);
        }
    }

    private void resetCache() {
        this.mConfigNames = Collections.EMPTY_SET;
        this.mClusterNames = Collections.EMPTY_SET;
        this.mClusterToConfig.clear();
        this.mConfigToClusters.clear();
        this.mResourceToTargets.clear();
        this.mAppToTargets.clear();
        this.mClusterToServers.clear();
    }

    private void createConfigClusterMappings() {
        try {
            for (String clusterName : this.mClusterNames) {
                String configName = this.mSrc.getConfigNameForCluster(clusterName);
                if (configName == null) continue;
                this.mClusterToConfig.put(clusterName, configName);
            }
            for (String configName : this.mConfigNames) {
                String[] clusterNames = this.mSrc.getClusterNamesForConfig(configName);
                if (clusterNames.length <= 0) continue;
                this.mConfigToClusters.put(configName, clusterNames);
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
    }

    private void createResourcesTargetsMapping() {
        try {
            String[] resNames = ((DottedNameClusterInfoImpl)this.mSrc).getAllResourceNames();
            for (int i = 0; i < resNames.length; ++i) {
                String[] targets = this.mSrc.getTargetsSharingResource(resNames[i]);
                if (targets == null) continue;
                this.mResourceToTargets.put(resNames[i], targets);
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
    }

    private void createAppsTargetsMapping() {
        try {
            String[] appNames = ((DottedNameClusterInfoImpl)this.mSrc).getAllApplicationNames();
            for (int i = 0; i < appNames.length; ++i) {
                String[] targets = this.mSrc.getTargetsSharingApplication(appNames[i]);
                if (targets == null) continue;
                this.mAppToTargets.put(appNames[i], targets);
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
    }

    private void createClusterToServersMapping() {
        try {
            for (String clusterName : this.getClusterNames()) {
                String[] serverNames = this.mSrc.getServerNamesForCluster(clusterName);
                if (serverNames == null) continue;
                this.mClusterToServers.put(clusterName, serverNames);
            }
        }
        catch (Exception e) {
            DottedNameLogger.logException((Exception)e);
        }
    }
}

