/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.WebModuleReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.EjbJarModuleReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.LocationHelperImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.WebModuleReaderImpl;
import com.sun.enterprise.tools.common.dd.WebserviceEndpoint;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.EnterpriseBeans;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterReaderHelper {
    private static final StringManager _strMgr = StringManager.getManager(ClusterReaderHelper.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    public static WebModuleReader[] getWebModules(ConfigContext _configCtx, ApplicationRef[] refs, String target) throws LbReaderException {
        ArrayList<WebModuleReader> list = new ArrayList<WebModuleReader>();
        for (int i = 0; i < refs.length; ++i) {
            J2eeApplication app;
            Object l;
            String name = refs[i].getRef();
            ConfigBean bean = null;
            try {
                bean = ApplicationHelper.findApplication((ConfigContext)_configCtx, (String)name);
            }
            catch (ConfigException ce) {
                String msg = _strMgr.getString("ErrorFindingApplication", (Object)name, (Object)target);
                throw new LbReaderException(msg, ce);
            }
            LocationHelperImpl lhelper = new LocationHelperImpl(_configCtx);
            if (bean instanceof WebModule) {
                WebModule wMod = (WebModule)bean;
                if (wMod == null || !wMod.getObjectType().equals("user")) continue;
                l = lhelper.getSunWebXmlPathForModule(wMod.getName());
                WebModuleReaderImpl wr = new WebModuleReaderImpl(_configCtx, refs[i], bean, ClusterReaderHelper.createSunWebApp((String)l));
                list.add(wr);
                continue;
            }
            if (!(bean instanceof J2eeApplication) || (app = (J2eeApplication)bean) == null || !app.getObjectType().equals("user")) continue;
            l = lhelper.getSunWebXmlPathForApplication(app.getName());
            int size = l.size();
            for (int j = 0; j < size; ++j) {
                WebModuleReaderImpl wr = new WebModuleReaderImpl(_configCtx, refs[i], null, ClusterReaderHelper.createSunWebApp((String)l.get(j)));
                list.add(wr);
            }
            List l1 = lhelper.getSunEjbJarXmlPathForApplication(app.getName());
            int size1 = l1.size();
            for (int j = 0; j < size1; ++j) {
                List<WebserviceEndpoint> wsepList = ClusterReaderHelper.createWebserviceEndpoint((String)l1.get(j));
                for (WebserviceEndpoint wsep : wsepList) {
                    EjbJarModuleReaderImpl wr = new EjbJarModuleReaderImpl(_configCtx, refs[i], wsep);
                    list.add(wr);
                }
            }
        }
        WebModuleReader[] webModules = new WebModuleReader[list.size()];
        return list.toArray(webModules);
    }

    public static SunWebApp createSunWebApp(String l) throws LbReaderException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(l));
        }
        catch (FileNotFoundException fne) {
            _logger.log(Level.WARNING, _sMgr.getString("http_lb_admin.sunweb.xml.not.found", (Object)l));
        }
        SunWebApp sw = null;
        try {
            sw = SunWebApp.createGraph((InputStream)in);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, _sMgr.getString("http_lb_admin.sunweb.bean.create.failed", (Object)e));
        }
        return sw;
    }

    public static List<WebserviceEndpoint> createWebserviceEndpoint(String l) throws LbReaderException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(l));
        }
        catch (FileNotFoundException fne) {
            _logger.log(Level.WARNING, _sMgr.getString("http_lb_admin.sunejbjar.xml.not.found", (Object)l));
        }
        SunEjbJar se = null;
        ArrayList<WebserviceEndpoint> list = new ArrayList<WebserviceEndpoint>();
        try {
            Ejb[] ejbs;
            se = SunEjbJar.createGraph((InputStream)in);
            EnterpriseBeans beans = se.getEnterpriseBeans();
            for (Ejb ejb : ejbs = beans.getEjb()) {
                WebserviceEndpoint[] wseps = ejb.getWebserviceEndpoint();
                list.addAll(Arrays.asList(wseps));
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, _sMgr.getString("http_lb_admin.ejbjar.bean.create.failed", (Object)e));
        }
        return list;
    }
}

