/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.ee.admin.mbeans.ClusterHealthCheckerMBean;
import com.sun.enterprise.ee.admin.mbeans.EEConfigMBeanObjectNames;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterHealthChecker
implements ClusterHealthCheckerMBean {
    private final ConfigContext acc;
    private static final StringManager sm = StringManager.getManager(ClusterHealthChecker.class);

    public ClusterHealthChecker(ConfigContext acc) {
        this.acc = acc;
    }

    @Override
    public Map<String, List<Long>> getClusterHealth(String targetCluster) throws InstanceException {
        if (targetCluster == null) {
            throw new IllegalArgumentException("null_arg");
        }
        try {
            if (!ClusterHelper.isACluster((ConfigContext)this.acc, (String)targetCluster)) {
                throw new InstanceException(sm.getString("noSuchCluster", (Object)targetCluster));
            }
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
        Map<String, List<Long>> health = null;
        health = this.gmsEnabled(targetCluster) ? this.getHealthFromGMS(targetCluster) : this.getHealthFromJMX(targetCluster);
        return health;
    }

    private boolean gmsEnabled(String cn) throws InstanceException {
        try {
            Cluster cluster = ClusterHelper.getClusterByName((ConfigContext)this.acc, (String)cn);
            boolean gms = cluster.isHeartbeatEnabled();
            return gms;
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    private Map<String, List<Long>> getHealthFromGMS(String cluster) throws InstanceException {
        Map health = null;
        try {
            ObjectName on = EEConfigMBeanObjectNames.getGMSClientObjName();
            MBeanServer mbsc = MBeanServerFactory.getMBeanServer();
            String m = "getClusterHealth";
            Object[] p = new String[]{cluster};
            String[] s = new String[]{"java.lang.String"};
            health = (Map)mbsc.invoke(on, "getClusterHealth", p, s);
            return health;
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    private Map<String, List<Long>> getHealthFromJMX(String cluster) throws InstanceException {
        try {
            RuntimeStatusList list = this.invokeClusterMBeanForStatus(cluster);
            Map<String, List<Long>> map = this.statusList2Map(list);
            return map;
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    private RuntimeStatusList invokeClusterMBeanForStatus(String cluster) throws Exception {
        ObjectName on = EEConfigMBeanObjectNames.getClusterConfigMBeanObjectName(cluster);
        MBeanServer mbsc = MBeanServerFactory.getMBeanServer();
        String m = "getRuntimeStatus";
        RuntimeStatusList l = (RuntimeStatusList)mbsc.invoke(on, "getRuntimeStatus", null, null);
        return l;
    }

    private Map<String, List<Long>> statusList2Map(RuntimeStatusList list) throws Exception {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        int i = 0;
        for (Object o : list) {
            RuntimeStatus rs = list.getStatus(i);
            String name = rs.getName();
            map.put(name, this.convert(rs));
            ++i;
        }
        return map;
    }

    private List<Long> convert(RuntimeStatus rs) {
        ArrayList<Long> list = new ArrayList<Long>();
        Long s = -1L;
        Long undefinedTime = new Long(-1L);
        if (rs.isRunning()) {
            s = 0L;
        }
        if (rs.isStopped()) {
            s = 1L;
        }
        list.add(s);
        list.add(undefinedTime);
        return list;
    }
}

