/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBSetupException;
import com.sun.enterprise.ee.admin.mbeans.ClusterHealthChecker;
import com.sun.enterprise.ee.admin.mbeans.ClusterHealthCheckerMBean;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.ee.admin.mbeans.HadbConfigMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClustersConfigMBean
extends EEBaseConfigMBean
implements IAdminConstants,
com.sun.enterprise.ee.admin.mbeanapi.ClustersConfigMBean,
ClusterHealthCheckerMBean {
    private final ClusterHealthCheckerMBean chc = new ClusterHealthChecker(super.getConfigContext());
    private static final StringManager _strMgr = StringManager.getManager(ClustersConfigMBean.class);
    private static Logger _logger = null;

    @Override
    public String[] listClustersAsString(String targetName, boolean withStatus) throws InstanceException {
        return this.getClustersConfigBean().listClustersAsString(targetName, withStatus);
    }

    @Override
    public ObjectName[] listClusters(String targetName) throws InstanceException, MBeanException {
        return this.toClusterONArray(this.listClustersAsString(targetName, false));
    }

    @Override
    public RuntimeStatusList getRuntimeStatus(String clusterName) throws InstanceException {
        return this.getClustersConfigBean().getRuntimeStatus(clusterName);
    }

    @Override
    public void clearRuntimeStatus(String clusterName) throws InstanceException {
        this.getClustersConfigBean().clearRuntimeStatus(clusterName);
    }

    @Override
    public RuntimeStatusList startCluster(String clusterName) throws InstanceException {
        return this.startCluster(null, clusterName);
    }

    @Override
    public RuntimeStatusList startCluster(String autoHadbOverride, String clusterName) throws InstanceException {
        boolean hadbWasStarted = false;
        boolean startHadb = this.getAutoHadb(autoHadbOverride, clusterName);
        if (startHadb) {
            try {
                HadbConfigMBean mbean = new HadbConfigMBean();
                String status = mbean.getDatabaseStatus(null, null, null, null, clusterName);
                if ("FaultTolerant".equals(status)) {
                    String s = _strMgr.getString("CSCMB.starthadbwarning", new Object[]{clusterName});
                    ClustersConfigMBean.getLogger().log(Level.WARNING, s);
                } else {
                    mbean.startDB(null, null, null, null, clusterName);
                    hadbWasStarted = true;
                }
            }
            catch (Exception e) {
                String s = _strMgr.getString("CSCMB.starthadberror", new Object[]{clusterName, e});
                ClustersConfigMBean.getLogger().log(Level.WARNING, s);
                throw new InstanceException(s);
            }
        }
        try {
            return this.getClustersConfigBean().startCluster(clusterName);
        }
        catch (InstanceException ie) {
            if (hadbWasStarted) {
                HadbConfigMBean mbean = new HadbConfigMBean();
                try {
                    mbean.stopDB(null, null, null, null, clusterName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw ie;
        }
    }

    @Override
    public RuntimeStatusList stopCluster(String clusterName) throws InstanceException {
        return this.stopCluster(null, clusterName);
    }

    @Override
    public RuntimeStatusList stopCluster(String autoHadbOverride, String clusterName) throws InstanceException {
        boolean stopHadb = this.getAutoHadb(autoHadbOverride, clusterName);
        RuntimeStatusList ret = null;
        ret = this.getClustersConfigBean().stopCluster(clusterName);
        if (stopHadb) {
            try {
                HadbConfigMBean mbean = new HadbConfigMBean();
                mbean.stopDB(null, null, null, null, clusterName);
            }
            catch (Exception e) {
                String s = _strMgr.getString("CSCMB.stophadberror", new Object[]{clusterName, e});
                ClustersConfigMBean.getLogger().log(Level.WARNING, s);
                throw new InstanceException(s);
            }
        }
        return ret;
    }

    @Override
    public void deleteCluster(String clusterName) throws InstanceException {
        this.deleteCluster(null, clusterName);
    }

    public void deleteCluster(String autoHadbOverride, String clusterName) throws InstanceException {
        boolean deleteHadb = this.getAutoHadb(autoHadbOverride, clusterName);
        HadbConfigMBean mbean = new HadbConfigMBean();
        String hosts = null;
        String agentPort = null;
        if (deleteHadb) {
            try {
                hosts = mbean.getHosts(clusterName);
                agentPort = mbean.getAgentPort(clusterName);
            }
            catch (Exception e) {
                String s = _strMgr.getString("CSCMB.fetcherror", new Object[]{clusterName, e});
                ClustersConfigMBean.getLogger().log(Level.WARNING, s);
            }
        }
        this.getClustersConfigBean().deleteCluster(clusterName);
        ManagementObjectManager mgmtObjManager = Switch.getSwitch().getManagementObjectManager();
        mgmtObjManager.unregisterJ2EECluster(clusterName);
        if (deleteHadb) {
            try {
                mbean.deleteHACluster(hosts, agentPort, null, null, clusterName);
            }
            catch (Exception e) {
                String s = _strMgr.getString("CSCMB.removehadberror", new Object[]{clusterName, e});
                ClustersConfigMBean.getLogger().log(Level.WARNING, s);
                throw new InstanceException(s);
            }
        }
    }

    @Override
    public ObjectName createCluster(String clusterName, String configName, Properties props) throws InstanceException, MBeanException {
        this.getClustersConfigBean().createCluster(clusterName, configName, props);
        ManagementObjectManager mgmtObjManager = Switch.getSwitch().getManagementObjectManager();
        mgmtObjManager.registerJ2EECluster(clusterName);
        return this.getClusterObjectName(clusterName);
    }

    @Override
    public ObjectName createCluster(String clusterName, String configName, Properties props, String hosts, String haagentport, String haadminpassword, String haadminpasswordfile, String devicesize, Properties haprops, Boolean autohadb, String portbase) throws InstanceException, MBeanException {
        boolean haOptional;
        ObjectName ret = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ClustersConfigMBean.createCluster called with: ");
            sb.append("[").append("clusterName").append("=").append(clusterName).append("]");
            sb.append("[").append("configName").append("=").append(configName).append("]");
            sb.append("[").append("props").append("=").append(props).append("]");
            sb.append("[").append("hosts").append("=").append(hosts).append("]");
            sb.append("[").append("haagentport").append("=").append(haagentport).append("]");
            sb.append("[").append("haadminpassword").append("=").append(haadminpassword).append("]");
            sb.append("[").append("haadminpasswordfile").append("=").append(haadminpasswordfile).append("]");
            sb.append("[").append("devicesize").append("=").append(devicesize).append("]");
            sb.append("[").append("haprops").append("=").append(haprops).append("]");
            sb.append("[").append("autohadb").append("=").append(autohadb).append("]");
            sb.append("[").append("portbase").append("=").append(portbase).append("]");
            ClustersConfigMBean.getLogger().log(Level.INFO, sb.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean haRequired = hosts != null;
        boolean bl = haOptional = haagentport != null || haadminpassword != null || haadminpasswordfile != null || haprops != null || autohadb != null && autohadb == true || portbase != null;
        if (haOptional && !haRequired) {
            String s = _strMgr.getString("CSCMB.nohosts");
            ClustersConfigMBean.getLogger().log(Level.WARNING, s);
            throw new MBeanException(new HADBSetupException(s));
        }
        boolean configha = haRequired;
        ret = this.createCluster(clusterName, configName, props);
        if (configha) {
            try {
                HadbConfigMBean mbean = new HadbConfigMBean();
                Object[] objs = mbean.createHACluster(hosts, haagentport, haadminpassword, haadminpasswordfile, devicesize, autohadb, portbase, clusterName, haprops);
                String s = _strMgr.getString("CSCMB.createhadbOK", new Object[]{clusterName, Arrays.toString(objs)});
                ClustersConfigMBean.getLogger().log(Level.INFO, s);
            }
            catch (Exception e) {
                String s = _strMgr.getString("CSCMB.createhadberror", new Object[]{clusterName, e});
                ClustersConfigMBean.getLogger().log(Level.WARNING, s);
                try {
                    this.deleteCluster("false", clusterName);
                }
                catch (Exception e2) {
                    s = s + e2.getMessage();
                }
                throw new MBeanException(new HADBSetupException(s));
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean getAutoHadb(String autoHadbOverride, String clusterName) throws InstanceException {
        boolean ret = false;
        if (this.getPersistenceType(clusterName) != PersistenceType.HA) {
            return false;
        }
        if (autoHadbOverride != null && autoHadbOverride.length() > 0) {
            String ah = autoHadbOverride.toLowerCase();
            if (ah.equals("true")) {
                ret = true;
            } else {
                if (!ah.equals("false")) {
                    String s = _strMgr.getString("CSCMB.badAutoHadbOverrideArg", (Object)autoHadbOverride);
                    ClustersConfigMBean.getLogger().log(Level.WARNING, s);
                    throw new InstanceException(s);
                }
                ret = false;
            }
        } else {
            ret = this.getAutoHadbFromConfig(clusterName);
        }
        String s = _strMgr.getString("CSCMB.autohadbResult", (Object)new Boolean(ret));
        ClustersConfigMBean.getLogger().log(Level.INFO, s);
        return ret;
    }

    private boolean getAutoHadbFromConfig(String clusterName) {
        try {
            HadbConfigMBean mbean = new HadbConfigMBean();
            Boolean b = mbean.getAutoHadb(clusterName);
            if (b != null) {
                return b;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    private PersistenceType getPersistenceType(String clusterName) {
        try {
            Config config = ClusterHelper.getConfigForCluster((ConfigContext)this.getConfigContext(), (String)clusterName);
            AvailabilityService avail = config.getAvailabilityService();
            WebContainerAvailability webAvail = avail.getWebContainerAvailability();
            String type = webAvail.getPersistenceType();
            if ("ha".equals(type)) {
                return PersistenceType.HA;
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return PersistenceType.REPLICATION;
    }

    @Override
    public Map<String, List<Long>> getClusterHealth(String targetCluster) throws InstanceException {
        return this.chc.getClusterHealth(targetCluster);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PersistenceType {
        HA,
        REPLICATION;

    }
}

