/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.DynamicReconfigEvent;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeans.SystemPropertyBaseMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ConfigConfigMBean
extends SystemPropertyBaseMBean
implements com.sun.enterprise.ee.admin.mbeanapi.ConfigConfigMBean {
    private static final StringManager _strMgr = StringManager.getManager(ConfigConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    protected static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(ConfigConfigMBean.getLogger());
        }
        return _handler;
    }

    protected String getLogMessageId() {
        return "eeadmin.ConfigConfigMBean.Exception";
    }

    public void delete() throws InstanceException {
        String configName = this.getName();
        try {
            this.getConfigsConfigBean().deleteConfiguration(configName);
        }
        catch (Exception ex) {
            throw ConfigConfigMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), configName);
        }
    }

    public ObjectName copy(String newConfigName, Properties props) throws InstanceException, MBeanException {
        String configName = this.getName();
        try {
            this.getConfigsConfigBean().copyConfiguration(configName, newConfigName, props);
            return this.getConfigurationObjectName(newConfigName);
        }
        catch (Exception ex) {
            throw ConfigConfigMBean.getExceptionHandler().handleInstanceException(ex, this.getLogMessageId(), configName);
        }
    }

    public ObjectName[] listReferencees() throws InstanceException {
        ObjectName[] referencees = new ObjectName[]{};
        String configName = this.getName();
        try {
            Cluster[] clusters;
            ConfigContext ctx = this.getConfigContext();
            ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
            Server[] servers = ServerHelper.getServersReferencingConfig((ConfigContext)ctx, (String)configName);
            if (servers != null) {
                for (int i = 0; i < servers.length; ++i) {
                    String name = servers[i].getName();
                    if (ServerHelper.isServerClustered((ConfigContext)ctx, (String)name)) continue;
                    objectNames.add(this.getServerObjectName(name));
                }
            }
            if ((clusters = ClusterHelper.getClustersReferencingConfig((ConfigContext)ctx, (String)configName)) != null) {
                for (int i = 0; i < clusters.length; ++i) {
                    String name = clusters[i].getName();
                    objectNames.add(this.getClusterObjectName(name));
                }
            }
            referencees = objectNames.toArray(new ObjectName[0]);
        }
        catch (Exception e) {
            throw ConfigConfigMBean.getExceptionHandler().handleInstanceException(e, this.getLogMessageId(), configName);
        }
        return referencees;
    }

    public boolean isReferencedByAnyCluster() throws InstanceException {
        String configName = this.getName();
        try {
            ConfigContext ctx = this.getConfigContext();
            Cluster[] clusters = ClusterHelper.getClustersReferencingConfig((ConfigContext)ctx, (String)configName);
            return clusters != null;
        }
        catch (Exception e) {
            throw ConfigConfigMBean.getExceptionHandler().handleInstanceException(e, this.getLogMessageId(), configName);
        }
    }

    public boolean isReferencedByDAS() throws InstanceException {
        String configName = this.getName();
        try {
            ConfigContext ctx = this.getConfigContext();
            Server[] servers = ServerHelper.getServersReferencingConfig((ConfigContext)ctx, (String)configName);
            if (servers != null) {
                for (int i = 0; i < servers.length; ++i) {
                    String name = servers[i].getName();
                    if (ServerHelper.isDAS((ConfigContext)ctx, (String)name)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw ConfigConfigMBean.getExceptionHandler().handleInstanceException(e, this.getLogMessageId(), configName);
        }
        return false;
    }

    public AttributeList setAttributes(AttributeList list) {
        Attribute attr;
        int i;
        boolean bEnabled = false;
        int removeIndex = -1;
        if (list != null) {
            for (i = 0; i < list.size(); ++i) {
                attr = (Attribute)list.get(i);
                if (!"dynamic-reconfiguration-enabled".equals(attr.getName().replace('_', '-'))) continue;
                try {
                    bEnabled = this.validateDynamicReconfigEvent(attr.getValue());
                    continue;
                }
                catch (Exception e) {
                    removeIndex = i;
                }
            }
        }
        if (removeIndex != -1) {
            list.remove(removeIndex);
        }
        list = super.setAttributes(list);
        if (removeIndex != -1) {
            return list;
        }
        if (list != null) {
            for (i = 0; i < list.size(); ++i) {
                attr = (Attribute)list.get(i);
                if (!"dynamic-reconfiguration-enabled".equals(attr.getName().replace('_', '-'))) continue;
                this.emitDynamicReconfigEvent(bEnabled);
            }
        }
        return list;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, MBeanException, ReflectionException {
        boolean bEnabled = false;
        if ("dynamic-reconfiguration-enabled".equals(attr.getName().replace('_', '-'))) {
            bEnabled = this.validateDynamicReconfigEvent(attr.getValue());
        }
        super.setAttribute(attr);
        if ("dynamic-reconfiguration-enabled".equals(attr.getName().replace('_', '-'))) {
            this.emitDynamicReconfigEvent(bEnabled);
        }
    }

    private boolean validateDynamicReconfigEvent(Object value) throws IllegalArgumentException, MBeanException {
        boolean bEnabled = false;
        if (value instanceof Boolean) {
            bEnabled = (Boolean)value;
        } else if ("true".equalsIgnoreCase(value.toString()) || "yes".equalsIgnoreCase(value.toString())) {
            bEnabled = true;
        }
        boolean restartRequired = false;
        try {
            restartRequired = this.isRestartRequired();
        }
        catch (InstanceException ie) {
            throw new MBeanException((Exception)((Object)ie));
        }
        if (bEnabled && restartRequired) {
            String msg = _strMgr.getString("serverRequiresRestart");
            Exception e = new Exception(msg);
            throw new MBeanException(e, msg);
        }
        return bEnabled;
    }

    private void emitDynamicReconfigEvent(boolean bEnabled) {
        try {
            AdminContext adminContext = MBeanRegistryFactory.getAdminContext();
            String instanceName = adminContext.getServerName();
            int action = bEnabled ? 1 : 0;
            DynamicReconfigEvent event = new DynamicReconfigEvent(instanceName, action);
            String configName = (String)this.getAttribute("name");
            event.setTargetDestination(configName);
            EventContext.addEvent((AdminEvent)event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isRestartRequired() throws InstanceException {
        return this.getConfigsConfigBean().isRestartRequired(this.getName());
    }
}

