/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.remote.JMXServiceURL;

public class DASPropertyReader {
    private Properties _properties;
    private File _propertyFileDir;
    private static final StringManager _strMgr = StringManager.getManager(DASPropertyReader.class);
    private static final String DAS_PROPERTY_FILE_NAME = "das.properties";

    public DASPropertyReader(RepositoryConfig config) {
        AgentConfig agentConfig = new AgentConfig(config.getRepositoryName(), config.getRepositoryRoot());
        this._propertyFileDir = new EEFileLayout(agentConfig).getConfigRoot();
        this._properties = new Properties();
        String dasHost = (String)config.get((Object)"agent.das.host");
        if (dasHost != null) {
            this._properties.setProperty("agent.das.host", dasHost);
            this._properties.setProperty("agent.das.port", (String)config.get((Object)"agent.das.port"));
            this._properties.setProperty("agent.das.protocol", (String)config.get((Object)"agent.das.protocol"));
            String isSecure = (String)config.get((Object)"agent.das.isSecure");
            if (isSecure == null) {
                isSecure = "true";
            }
            this._properties.setProperty("agent.das.isSecure", isSecure);
        }
    }

    public String getJMXURL() {
        try {
            JMXServiceURL url = JmxServiceUrlFactory.forRmiWithJndiInAppserver((String)this.getHost(), (int)Integer.parseInt(this.getPort()));
            return url.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String isDASSecure() {
        return this._properties.getProperty("agent.das.isSecure");
    }

    public void setIsDASSecure(String secure) {
        this._properties.setProperty("agent.das.isSecure", secure);
    }

    public String getProtocol() {
        return this._properties.getProperty("agent.das.protocol");
    }

    public void setProtocol(String protocol) {
        this._properties.setProperty("agent.das.protocol", protocol);
    }

    public String getHost() {
        return this._properties.getProperty("agent.das.host");
    }

    public void setHost(String host) {
        this._properties.setProperty("agent.das.host", host);
    }

    public String getPort() {
        return this._properties.getProperty("agent.das.port");
    }

    public void setPort(String port) {
        this._properties.setProperty("agent.das.port", port);
    }

    public void clearProperties() {
        this._properties.remove("agent.das.host");
        this._properties.remove("agent.das.port");
        this._properties.remove("agent.das.protocol");
    }

    public void write() throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(this._propertyFileDir, DAS_PROPERTY_FILE_NAME));
        this._properties.store(fos, _strMgr.getString("dasPropertyFileComment"));
        fos.close();
    }

    public void read() throws IOException, FileNotFoundException {
        this._properties.load(new FileInputStream(new File(this._propertyFileDir, DAS_PROPERTY_FILE_NAME)));
    }
}

