/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.system.MQJMXConnectorInfo;
import com.sun.enterprise.ee.selfmanagement.actions.DeadQueueMessageAlertActionMBean;
import com.sun.enterprise.ee.selfmanagement.actions.MailAlert;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DeadQueueMessageAlertAction
implements MBeanRegistration,
DeadQueueMessageAlertActionMBean,
NotificationListener {
    private ObjectName myObjectName = null;
    private int interval = 180;
    private int offset = 0;
    private int threshold = 1;
    private boolean continueWorkerThread = false;
    private String alertRef = null;
    private String mailRecipients = null;
    private String mailResource = null;
    static StringManager sm = StringManager.getManager(DeadQueueMessageAlertAction.class);
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " DeadQueueMessageAlertAction : postRegister registration Done ");
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " DeadQueueMessageAlertAction : preRegister ObjectName " + name);
        }
        this.myObjectName = name;
        return name;
    }

    public void preDeregister() throws Exception {
        this.continueWorkerThread = false;
    }

    public void postDeregister() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, " DeadQueueMessageAlertAction : postDeRegister ");
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("lifecycle.shutdown") || notification.getType().equals("lifecycle.termination")) {
            this.continueWorkerThread = false;
            return;
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.log(Level.INFO, sm.getString("actions.activated", (Object)"Dead Queue Message Alert", (Object)notification));
        }
        this.continueWorkerThread = true;
        try {
            Thread.sleep(this.interval * 1000);
        }
        catch (InterruptedException exc) {
            _logger.log(Level.WARNING, sm.getString("action.internal_error"), exc);
        }
        new DeadQueueWorkerThread().start();
    }

    boolean continueProcess() {
        return this.continueWorkerThread;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setInterval(int seconds) {
        this.interval = seconds;
    }

    public void setMailAlertRef(String ref) {
        this.alertRef = ref;
    }

    public void setMailRecipients(String recipients) {
        this.mailRecipients = recipients;
    }

    public void setMailResource(String mailRes) {
        this.mailResource = mailRes;
    }

    class DeadQueueWorkerThread
    extends Thread {
        private ObjectName mqDestinationMBeanName = null;
        private MBeanServerConnection mqMsbc = null;
        private MQJMXConnectorInfo[] mqMi = null;

        DeadQueueWorkerThread() {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(" DeadQueueMessageAlertAction : Interval " + DeadQueueMessageAlertAction.this.interval + " , Threshold " + DeadQueueMessageAlertAction.this.threshold + " , Offset " + DeadQueueMessageAlertAction.this.offset + " , Mail Resource " + DeadQueueMessageAlertAction.this.mailResource + " , Mail Recipients " + DeadQueueMessageAlertAction.this.mailRecipients + " , Mail Alert Ref " + DeadQueueMessageAlertAction.this.alertRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String currentServer = ApplicationServer.getServerContext().getInstanceName();
            try {
                this.mqMi = ConnectorRuntime.getRuntime().getMQJMXConnectorInfo(currentServer);
                if (this.mqMi[0] == null) {
                    _logger.log(Level.WARNING, sm.getString("action.internal_error"));
                    return;
                }
                this.mqMsbc = this.mqMi[0].getMQMBeanServerConnection();
                this.mqDestinationMBeanName = MQObjectName.createDestinationMonitor((String)"q", (String)"mq.sys.dmq");
                boolean loop = true;
                while (loop) {
                    Thread.sleep(DeadQueueMessageAlertAction.this.interval);
                    Long numMsgs = (Long)this.mqMsbc.getAttribute(this.mqDestinationMBeanName, "NumMsgs");
                    if (numMsgs > (long)DeadQueueMessageAlertAction.this.threshold) {
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.log(Level.INFO, sm.getString("nummsgs.exceeds.threshold", (Object)numMsgs, (Object)DeadQueueMessageAlertAction.this.threshold));
                        }
                        if (DeadQueueMessageAlertAction.this.alertRef != null) {
                            this.sendAlert(numMsgs, DeadQueueMessageAlertAction.this.threshold);
                        } else if (DeadQueueMessageAlertAction.this.mailRecipients != null) {
                            this.sendMailAlert(numMsgs, DeadQueueMessageAlertAction.this.threshold);
                        }
                        if (DeadQueueMessageAlertAction.this.offset == 0) {
                            return;
                        }
                        DeadQueueMessageAlertAction.this.threshold += DeadQueueMessageAlertAction.this.offset;
                    }
                    if (DeadQueueMessageAlertAction.this.continueProcess()) continue;
                    loop = false;
                }
            }
            catch (InterruptedException exc) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), exc);
            }
            catch (ConnectorRuntimeException cex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), cex);
            }
            catch (MalformedObjectNameException mex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), mex);
            }
            catch (MBeanException ex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), ex);
            }
            catch (AttributeNotFoundException aex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), aex);
            }
            catch (InstanceNotFoundException iex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), iex);
            }
            catch (ReflectionException rex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), rex);
            }
            catch (IOException ioex) {
                _logger.log(Level.WARNING, sm.getString("action.internal_error"), ioex);
            }
            finally {
                try {
                    this.mqMi[0].closeMQMBeanServerConnection();
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, sm.getString("action.internal_error"), ex);
                }
            }
        }

        private void sendAlert(long numMsgs, int threshold) {
            String alertMsg = sm.getString("nummsgs.exceeds.threshold", (Object)numMsgs, (Object)threshold);
            if (DeadQueueMessageAlertAction.this.alertRef != null) {
                try {
                    Mbean definedMBean = ServerBeansFactory.getMBeanDefinition((ConfigContext)ApplicationServer.getServerContext().getConfigContext(), (String)DeadQueueMessageAlertAction.this.alertRef);
                    ObjectName objName = CustomMBeanRegistrationImpl.getCascadingAwareObjectName((Mbean)definedMBean);
                    Object[] params = new Object[2];
                    String[] signature = new String[2];
                    params[0] = new Notification("deadqueuemessagealert.exceedsthreshold", (Object)this, 0L, alertMsg);
                    params[1] = null;
                    signature[0] = Notification.class.getName();
                    signature[1] = Object.class.getName();
                    MBeanServerFactory.getMBeanServer().invoke(objName, "notification", params, signature);
                }
                catch (InstanceNotFoundException ex) {
                    _logger.log(Level.WARNING, sm.getString("action.internal_error"), ex);
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, sm.getString("action.internal_error"), ex);
                }
            }
        }

        private void sendMailAlert(long numMsgs, int threshold) {
            String alertMsg = sm.getString("nummsgs.exceeds.threshold", (Object)numMsgs, (Object)threshold);
            MailAlert mAlert = new MailAlert();
            mAlert.setRecipients(DeadQueueMessageAlertAction.this.mailRecipients);
            mAlert.setMailResource(DeadQueueMessageAlertAction.this.mailResource);
            Notification n1 = new Notification("deadqueuemessagealert.exceedsthreshold", (Object)this, 0L, alertMsg);
            mAlert.notification(n1, null);
        }
    }
}

