/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.cleaner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

class CookieHandler {
    private static File _cookieFile = null;
    private static long _waitPeriod = 0L;
    private static final String COOKIE = ".com_sun_appserv_cleaner_cookie";
    private static final String DEF_WAIT_PERIOD = "60000";
    private static final String COOKIE_ENV_PROPERTY = "com.sun.appserv.cleaner.cookie";

    CookieHandler() {
        String iRoot = System.getProperty("com.sun.aas.instanceRoot");
        _cookieFile = new File(iRoot + File.separator + "generated" + File.separator + COOKIE);
        String wp = System.getProperty(COOKIE_ENV_PROPERTY, DEF_WAIT_PERIOD);
        _waitPeriod = Long.parseLong(wp);
    }

    boolean isExpired() {
        long cookieTime;
        boolean expired = false;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (cookieTime = this.getCookie()) > _waitPeriod) {
            expired = true;
        }
        return expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCookie() {
        long time = 0L;
        BufferedReader is = null;
        try {
            if (_cookieFile.exists()) {
                is = new BufferedReader(new FileReader(_cookieFile));
                time = Long.parseLong(is.readLine());
                is.close();
                is = null;
            } else {
                _cookieFile.getParentFile().mkdirs();
                this.updateCookie();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCookie() {
        FileWriter fw = null;
        try {
            long time = System.currentTimeMillis();
            fw = new FileWriter(_cookieFile);
            fw.write(Long.toString(time));
            fw.flush();
            fw.close();
            fw = null;
        }
        catch (Exception e) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

