/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.impl;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.ee.synchronization.AppclientModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.ApplicationRequestBuilder;
import com.sun.enterprise.ee.synchronization.ApplicationSynchRequest;
import com.sun.enterprise.ee.synchronization.BaseGroupRequestMediator;
import com.sun.enterprise.ee.synchronization.ConnectorModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.EjbModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.JmxGroupRequestMediator;
import com.sun.enterprise.ee.synchronization.LifecycleModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.WebModuleRequestBuilder;
import com.sun.enterprise.ee.synchronization.api.ApplicationsMgr;
import com.sun.enterprise.ee.synchronization.http.HttpGroupRequestMediator;
import com.sun.enterprise.ee.synchronization.http.HttpUtils;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import com.sun.enterprise.ee.synchronization.tx.TransactionManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationsMgrImpl
implements ApplicationsMgr {
    private ConfigContext _ctx = null;
    private String _serverName = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private static final StringManager _localStrMgr = StringManager.getManager(ApplicationsMgrImpl.class);

    public ApplicationsMgrImpl() {
        if (AdminService.getAdminService().isDas()) {
            String msg = _localStrMgr.getString("DasNotSupported");
            throw new RuntimeException(msg);
        }
        this._serverName = ApplicationServer.getServerContext().getInstanceName();
        if (this._serverName == null) {
            throw new RuntimeException(_localStrMgr.getString("ServerNameConfigError"));
        }
    }

    public void setConfigContext(ConfigContext ctx) {
        this._ctx = ctx;
    }

    public ApplicationsMgrImpl(ConfigContext ctx) {
        if (AdminService.getAdminService().isDas()) {
            String msg = _localStrMgr.getString("DasNotSupported");
            throw new RuntimeException(msg);
        }
        this._ctx = ctx;
        this._serverName = ApplicationServer.getServerContext().getInstanceName();
        if (this._serverName == null) {
            throw new RuntimeException(_localStrMgr.getString("ServerNameConfigError"));
        }
    }

    public void synchronize(String name) throws SynchronizationException {
        ConfigBean bean = null;
        try {
            bean = ApplicationHelper.findApplication((ConfigContext)this._ctx, (String)name);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)name);
            throw new SynchronizationException(msg, ce);
        }
        if (bean instanceof J2eeApplication) {
            this.synchronizeJ2EEApplication(name);
        } else if (bean instanceof AppclientModule) {
            this.synchronizeAppclientModule(name);
        } else if (bean instanceof EjbModule) {
            this.synchronizeEJBModule(name);
        } else if (bean instanceof LifecycleModule) {
            this.synchronizeLifecycleModule(name);
        } else if (bean instanceof WebModule) {
            this.synchronizeWebModule(name);
        } else if (bean instanceof ConnectorModule) {
            this.synchronizeConnectorModule(name);
        } else {
            String msg = _localStrMgr.getString("UnknownApplicationType", (Object)name);
            throw new SynchronizationException(msg);
        }
    }

    public void synchronizeJ2EEApplication(String appName) throws SynchronizationException {
        long b = System.currentTimeMillis();
        _logger.log(Level.FINE, "synchronization.start.download.bits", appName);
        J2eeApplication app = null;
        try {
            app = ((Domain)this._ctx.getRootConfigBean()).getApplications().getJ2eeApplicationByName(appName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)appName);
            throw new SynchronizationException(msg, ce);
        }
        ApplicationRequestBuilder appReqBuilder = new ApplicationRequestBuilder(this._ctx, this._serverName);
        ApplicationSynchRequest appSyncReq = appReqBuilder.build(app);
        this.getBits(appSyncReq);
        _logger.log(Level.INFO, _strMgr.getString("synchronization.end.download.bits", (Object)appName, (Object)new Long(System.currentTimeMillis() - b).toString()));
    }

    public void synchronizeAppclientModule(String appName) throws SynchronizationException {
        long b = System.currentTimeMillis();
        _logger.log(Level.FINE, "synchronization.start.download.bits", appName);
        AppclientModule app = null;
        try {
            app = ((Domain)this._ctx.getRootConfigBean()).getApplications().getAppclientModuleByName(appName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)appName);
            throw new SynchronizationException(msg, ce);
        }
        AppclientModuleRequestBuilder appReqBuilder = new AppclientModuleRequestBuilder(this._ctx, this._serverName);
        ApplicationSynchRequest appSyncReq = appReqBuilder.build(app);
        this.getBits(appSyncReq);
        _logger.log(Level.INFO, _strMgr.getString("synchronization.end.download.bits", (Object)appName, (Object)new Long(System.currentTimeMillis() - b).toString()));
    }

    public void synchronizeEJBModule(String appName) throws SynchronizationException {
        long b = System.currentTimeMillis();
        _logger.log(Level.FINE, "synchronization.start.download.bits", appName);
        EjbModule app = null;
        try {
            app = ((Domain)this._ctx.getRootConfigBean()).getApplications().getEjbModuleByName(appName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)appName);
            throw new SynchronizationException(msg, ce);
        }
        EjbModuleRequestBuilder appReqBuilder = new EjbModuleRequestBuilder(this._ctx, this._serverName);
        ApplicationSynchRequest appSyncReq = appReqBuilder.build(app);
        this.getBits(appSyncReq);
        _logger.log(Level.INFO, _strMgr.getString("synchronization.end.download.bits", (Object)appName, (Object)new Long(System.currentTimeMillis() - b).toString()));
    }

    public void synchronizeLifecycleModule(String appName) throws SynchronizationException {
        long b = System.currentTimeMillis();
        _logger.log(Level.FINE, "synchronization.start.download.bits", appName);
        LifecycleModule app = null;
        try {
            app = ((Domain)this._ctx.getRootConfigBean()).getApplications().getLifecycleModuleByName(appName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)appName);
            throw new SynchronizationException(msg, ce);
        }
        LifecycleModuleRequestBuilder appReqBuilder = new LifecycleModuleRequestBuilder(this._ctx, this._serverName);
        ApplicationSynchRequest appSyncReq = appReqBuilder.build(app);
        this.getBits(appSyncReq);
        _logger.log(Level.INFO, _strMgr.getString("synchronization.end.download.bits", (Object)appName, (Object)new Long(System.currentTimeMillis() - b).toString()));
    }

    public void synchronizeWebModule(String appName) throws SynchronizationException {
        long b = System.currentTimeMillis();
        _logger.log(Level.FINE, "synchronization.start.download.bits", appName);
        WebModule app = null;
        try {
            app = ((Domain)this._ctx.getRootConfigBean()).getApplications().getWebModuleByName(appName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)appName);
            throw new SynchronizationException(msg, ce);
        }
        WebModuleRequestBuilder appReqBuilder = new WebModuleRequestBuilder(this._ctx, this._serverName);
        ApplicationSynchRequest appSyncReq = appReqBuilder.build(app);
        this.getBits(appSyncReq);
        _logger.log(Level.INFO, _strMgr.getString("synchronization.end.download.bits", (Object)appName, (Object)new Long(System.currentTimeMillis() - b).toString()));
    }

    public void synchronizeConnectorModule(String appName) throws SynchronizationException {
        long b = System.currentTimeMillis();
        _logger.log(Level.FINE, "synchronization.start.download.bits", appName);
        ConnectorModule app = null;
        try {
            app = ((Domain)this._ctx.getRootConfigBean()).getApplications().getConnectorModuleByName(appName);
        }
        catch (ConfigException ce) {
            String msg = _localStrMgr.getString("UnknownApplicationId", (Object)appName);
            throw new SynchronizationException(msg, ce);
        }
        ConnectorModuleRequestBuilder appReqBuilder = new ConnectorModuleRequestBuilder(this._ctx, this._serverName);
        ApplicationSynchRequest appSyncReq = appReqBuilder.build(app);
        this.getBits(appSyncReq);
        _logger.log(Level.INFO, _strMgr.getString("synchronization.end.download.bits", (Object)appName, (Object)new Long(System.currentTimeMillis() - b).toString()));
    }

    private void getBits(ApplicationSynchRequest appSyncReq) throws SynchronizationException {
        DASPropertyReader dpr = new DASPropertyReader(new InstanceConfig());
        List l = appSyncReq.toSynchronizationRequest();
        SynchronizationRequest[] allReqs = new SynchronizationRequest[l.size()];
        allReqs = l.toArray(allReqs);
        try {
            dpr.read();
        }
        catch (IOException ioe) {
            String msg = _localStrMgr.getString("DASPropertyReadError");
            throw new SynchronizationException(msg, ioe);
        }
        TransactionManager txMgr = TransactionManager.getTransactionManager();
        Transaction tx = txMgr.begin(1);
        boolean httpException = false;
        BaseGroupRequestMediator httpGrm = null;
        try {
            String url = HttpUtils.getSynchronizationURL(this._ctx, dpr);
            httpGrm = new HttpGroupRequestMediator(dpr, allReqs, tx, url);
            httpGrm.run();
        }
        catch (Exception e) {
            httpException = true;
        }
        if (httpGrm.isException() || httpException) {
            _logger.log(Level.FINE, "Http based synchronization failed, trying jmx based impl..", httpGrm.getException());
            JmxGroupRequestMediator jmxGrm = new JmxGroupRequestMediator(dpr, allReqs, tx);
            jmxGrm.run();
            if (jmxGrm.isException()) {
                throw new SynchronizationException(jmxGrm.getException());
            }
        }
    }
}

