/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.util.io;

import com.sun.enterprise.ee.synchronization.inventory.InventoryMgr;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private static final StringManager sMgr = StringManager.getManager(Utils.class);
    private static String tmpName = System.getProperty("java.io.tmpdir") + File.separator + "appserver-tmp";
    private static boolean isInit = false;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    public static File getTempZipFile() {
        long ts = System.currentTimeMillis();
        File f = new File(tmpName, new Long(ts).toString() + ".zip");
        while (f.exists()) {
            f = new File(tmpName, new Long(++ts).toString() + ".zip");
        }
        f.getParentFile().mkdirs();
        return f;
    }

    public static void mergeTree(File din, File dout) throws IOException {
        Utils.audit(din, dout, "beforemerge");
        Utils.moveTree(din, dout);
        Utils.audit(din, dout, "aftermerge");
        FileUtils.liquidate((File)din);
        if (din.exists()) {
            long ts = System.currentTimeMillis();
            File f = new File(tmpName, new Long(ts).toString());
            while (f.exists()) {
                f = new File(tmpName, new Long(++ts).toString());
            }
            f.mkdirs();
            boolean ok = din.renameTo(f);
            if (!ok) {
                FileUtils.liquidate((File)din);
                if (din.exists()) {
                    _logger.log(Level.INFO, "synchronization.remove.failed", din.getPath());
                }
            } else {
                try {
                    f.deleteOnExit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    static void audit(File din, File dout, String suffix) {
        if (_logger.getLevel() == Level.FINE) {
            try {
                InventoryMgr newMgr = new InventoryMgr(dout);
                List newList = newMgr.getInventory();
                InventoryMgr backupMgr = new InventoryMgr(din);
                List dstList = backupMgr.getInventory();
                List diffList = InventoryMgr.getInventoryDiff(dstList, newList);
                newMgr.saveAuditList(dstList, "backup_" + suffix);
                newMgr.saveAuditList(newList, "new_" + suffix);
                newMgr.saveAuditList(diffList, "diff_" + suffix);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void moveTree(File din, File dout) throws IOException {
        _logger.log(Level.FINE, "\n[SYNC-MoveTree]Backup file name " + din.getPath());
        _logger.log(Level.FINE, "\n[SYNC-MoveTree]Target file name " + dout.getPath());
        if (!dout.exists()) {
            _logger.log(Level.FINE, "\n[SYNC-MoveTree] Target file " + dout.getPath() + " does not exist. Renaming backup.");
            boolean renamed = din.renameTo(dout);
            if (!renamed) {
                String msg = sMgr.getString("RenameFailed", (Object)din.getAbsolutePath(), (Object)dout.getAbsolutePath());
                throw new RuntimeException(msg);
            }
            return;
        }
        String[] files = din.list();
        Object[] files2 = dout.list();
        if (files == null || files.length == 0) {
            _logger.log(Level.FINE, "\n[SYNC-MoveTree]Backup is an empty dir or file: " + din.getPath());
            return;
        }
        if (files2 == null || files2.length == 0) {
            if (dout.isDirectory()) {
                _logger.log(Level.FINE, "\n[SYNC-MoveTree]Target is an empty dir: " + dout.getPath());
                FileUtils.liquidate((File)dout);
                boolean renamed = din.renameTo(dout);
                if (!renamed) {
                    String msg = sMgr.getString("RenameFailed", (Object)din.getAbsolutePath(), (Object)dout.getAbsolutePath());
                    throw new RuntimeException(msg);
                }
            }
        } else {
            Arrays.sort(files2);
            int sr_ky = 0;
            for (int i = 0; i < files.length; ++i) {
                _logger.log(Level.FINE, "\n[SYNC-MoveTree] Inspecting backup file: " + files[i]);
                sr_ky = 0;
                sr_ky = Arrays.binarySearch(files2, files[i]);
                if (sr_ky < 0) {
                    _logger.log(Level.FINE, "\n[SYNC-MoveTree] Backup file: " + files[i] + " is not available in target directory.");
                    File fin = new File(din, files[i]);
                    File fout = new File(dout, files[i]);
                    _logger.log(Level.FINE, "\n[SYNC-MoveTree] Renaming file: " + fin.getPath() + " to " + fout.getPath());
                    boolean renamed = fin.renameTo(fout);
                    if (renamed) continue;
                    String msg = sMgr.getString("RenameFailed", (Object)fin.getAbsolutePath(), (Object)fout.getAbsolutePath());
                    throw new RuntimeException(msg);
                }
                _logger.log(Level.FINE, "\n[SYNC-MoveTree] Found backup file " + files[i] + " in target " + (String)files2[sr_ky]);
                File f = new File(din, files[i]);
                if (f.isDirectory()) {
                    _logger.log(Level.FINE, "\n[SYNC-MoveTree] Backup file " + files[i] + " is a directory. Calling again.");
                    Utils.moveTree(f, new File(dout, (String)files2[sr_ky]));
                    continue;
                }
                _logger.log(Level.FINE, "\n[SYNC-MoveTree] Backup file " + files[i] + " is stale. Discarding it.");
            }
        }
    }

    public static void usage() {
        System.out.println("usage: source-dir dest-dir");
        System.exit(1);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 2) {
                Utils.usage();
            }
            Utils.mergeTree(new File(argv[0]), new File(argv[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

