/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.util.zip;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class Zipper {
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.util");
    protected static final int BUFFER_SIZE = 65536;
    protected String _baseDirectoryName;
    protected long _lastModifiedTime;
    protected final List _excludeList = new ArrayList();
    protected final List _excludePatternList = new ArrayList();
    protected final List _includePatternList = new ArrayList();
    protected final List _alwaysIncludeList = new ArrayList();
    protected boolean _shallowCopyEnabled = false;
    protected long _size;
    protected Long _maxBuffer;
    protected static final String USE_NIO_KEY = "com.sun.appserv.zip.nio";
    protected static final String _useNio;
    protected static final StringManager _localStrMgr;
    private static final String PATH_SEPARATOR = "/";

    public Zipper(String baseDirectoryName) {
        this.setBaseDirectory(baseDirectoryName);
        this.setLastModifiedTime(0L);
    }

    public Zipper(String baseDirectoryName, long lastModifiedTime) {
        this.setBaseDirectory(baseDirectoryName);
        this.setLastModifiedTime(lastModifiedTime);
    }

    public void setBaseDirectory(String baseDirectoryName) {
        this._baseDirectoryName = baseDirectoryName;
    }

    public long getZipSize() {
        return this._size;
    }

    public long getMaxBuffer() {
        long val = 0L;
        if (this._maxBuffer != null) {
            val = this._maxBuffer;
        }
        return val;
    }

    public void setMaxBuffer(long buffer) {
        this._maxBuffer = new Long(buffer);
    }

    public boolean isBufferOverflowed() {
        long maxBuffer;
        long size;
        boolean tf = false;
        if (this._maxBuffer != null && (size = this.getZipSize()) > (maxBuffer = this.getMaxBuffer())) {
            tf = true;
        }
        return tf;
    }

    public void addToExcludePatternList(List list) {
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Pattern p = Pattern.compile((String)iter.next());
                this._excludePatternList.add(p);
            }
        }
    }

    public void addToIncludePatternList(List list) {
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Pattern p = Pattern.compile((String)iter.next());
                this._includePatternList.add(p);
            }
        }
    }

    public void addToExcludeList(List list) {
        if (list != null) {
            for (String s : list) {
                if (s == null) continue;
                String normalized = FileUtils.makeForwardSlashes((String)s);
                this._excludeList.add(normalized);
            }
        }
    }

    public void addToAlwaysIncludeList(List list) {
        if (list != null) {
            this._alwaysIncludeList.addAll(list);
        }
    }

    public void addToAlwaysIncludeList(String include) {
        if (include != null) {
            this._alwaysIncludeList.add(include);
        }
    }

    public boolean hasAlwaysInclude() {
        return !this._alwaysIncludeList.isEmpty();
    }

    public void setShallowCopyEnabled(boolean tf) {
        this._shallowCopyEnabled = tf;
    }

    public boolean isShallowCopyEnabled() {
        return this._shallowCopyEnabled;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this._lastModifiedTime = lastModifiedTime;
    }

    public void createZipFileFromDirectory(String directoryName, String zipFileName) throws IOException, FileNotFoundException {
        this.createZipOutputStreamFromDirectory(new BufferedOutputStream(new FileOutputStream(zipFileName)), directoryName);
    }

    public byte[] createZipBytesFromDirectory(String directoryName) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(65536);
        this.createZipOutputStreamFromDirectory(bos, directoryName);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createZipOutputStreamFromDirectory(OutputStream os, String directoryName) throws IOException {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(os);
            File directory = new File(directoryName);
            this.addDirectoryToZip(directory, out);
            try {
                out.close();
                out = null;
            }
            catch (ZipException ex) {
                // empty catch block
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void addFileToList(File file, List out) throws IOException, FileNotFoundException {
        this.addFileToListInternal(file, this._baseDirectoryName + PATH_SEPARATOR + file.getName(), out, true);
    }

    public void addFileToZip(File file, ZipOutputStream out) throws IOException, FileNotFoundException {
        this.addFileToZipInternal(file, this._baseDirectoryName + PATH_SEPARATOR + file.getName(), out, true);
    }

    protected void addEmptyDirToZipInternal(File file, String fileName, ZipOutputStream out, boolean ignoreExclude) throws IOException, FileNotFoundException {
        ZipEntry entry = null;
        assert (file.isDirectory());
        if (file.exists()) {
            if (this.isAlwaysIncluded(file) || file.lastModified() >= this._lastModifiedTime && !this.isExcluded(file, ignoreExclude)) {
                _logger.fine("[Zipper] Adding Empty directory: " + fileName);
                entry = new ZipEntry(fileName);
                out.putNextEntry(entry);
                out.closeEntry();
            } else {
                _logger.fine("[Zipper] Ignoring Directory: " + fileName + " its modified time of " + file.lastModified() + " is < " + this._lastModifiedTime);
            }
        } else {
            _logger.fine("[Zipper] Ignoring Directory: " + fileName + " it does not exist");
        }
    }

    protected void addFileToListInternal(File file, String fileName, List out, boolean ignoreExclude) throws IOException, FileNotFoundException {
        assert (file.isFile());
        if (file.exists()) {
            if (this.isAlwaysIncluded(file) || file.lastModified() >= this._lastModifiedTime && !this.isExcluded(file, ignoreExclude)) {
                _logger.fine("[Zipper] Adding File: " + fileName);
                out.add(fileName);
            } else {
                _logger.fine("[Zipper] Ignoring File: " + fileName + " its modified time of " + file.lastModified() + " is < " + this._lastModifiedTime);
            }
        } else {
            _logger.fine("[Zipper] Ignoring File: " + fileName + " it does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileWithNIO(File file, ZipOutputStream out) throws IOException, FileNotFoundException {
        FileInputStream fis = null;
        FileChannel fc = null;
        WritableByteChannel wbc = null;
        try {
            long written;
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            long sz = fc.size();
            wbc = Channels.newChannel(out);
            int attempts = 0;
            for (long count = 0L; count < sz; count += written) {
                written = fc.transferTo(count, sz, wbc);
                if (written == 0L) {
                    if (++attempts <= 100) continue;
                    String msg = _localStrMgr.getString("NioReadError", (Object)file.getAbsolutePath());
                    throw new IOException(msg);
                }
                attempts = 0;
            }
            this._size += sz;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileWithIO(File file, ZipOutputStream out) throws IOException, FileNotFoundException {
        BufferedInputStream origin = null;
        byte[] data = new byte[65536];
        try {
            int count;
            origin = new BufferedInputStream(new FileInputStream(file), 65536);
            while ((count = origin.read(data, 0, 65536)) != -1) {
                out.write(data, 0, count);
                this._size += (long)count;
            }
            origin.close();
            origin = null;
        }
        finally {
            if (origin != null) {
                try {
                    origin.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void addFileToZipInternal(File file, String fileName, ZipOutputStream out, boolean ignoreExclude) throws IOException, FileNotFoundException {
        assert (file.isFile());
        if (this.isBufferOverflowed()) {
            throw new BufferOverflowException();
        }
        if (file.exists()) {
            if (this.isAlwaysIncluded(file) || file.lastModified() >= this._lastModifiedTime && !this.isExcluded(file, ignoreExclude)) {
                _logger.fine("[Zipper] Adding File: " + fileName);
                long sz = file.length();
                ZipEntry entry = new ZipEntry(fileName);
                entry.setTime(file.lastModified());
                entry.setSize(sz);
                out.putNextEntry(entry);
                if (sz > 65536L) {
                    if (_useNio != null && "false".equalsIgnoreCase(_useNio)) {
                        this.addFileWithIO(file, out);
                    } else {
                        this.addFileWithNIO(file, out);
                    }
                } else {
                    this.addFileWithIO(file, out);
                }
                out.closeEntry();
            } else {
                _logger.fine("[Zipper] Ignoring File: " + fileName + " its modified time of " + file.lastModified() + " is < " + this._lastModifiedTime);
            }
        } else {
            _logger.fine("[Zipper] Ignoring File: " + fileName + " it does not exist");
        }
    }

    public void addDirectoryToList(File directory, List out) throws IOException, FileNotFoundException {
        this.addDirectoryToListInternal(directory, out, this._baseDirectoryName, true);
    }

    public void addDirectoryToZip(File directory, ZipOutputStream out) throws IOException, FileNotFoundException {
        this.addDirectoryToZipInternal(directory, out, this._baseDirectoryName, true);
    }

    private boolean isExcluded(File f, boolean ignoreExclude) {
        if (ignoreExclude) {
            return false;
        }
        String file = f.getPath();
        if (this.isShallowCopyEnabled() && f.isDirectory() && !this.isIncluded(f)) {
            _logger.fine("[Zipper] File: " + file + " is shallow copy enabled, is a dir and not included.");
            return true;
        }
        String nFile = FileUtils.makeForwardSlashes((String)file);
        if (this._excludeList.contains(nFile)) {
            _logger.fine("[Zipper] File: " + nFile + " is part of the exclude list.");
            return true;
        }
        for (Pattern p : this._excludePatternList) {
            Matcher m = p.matcher(file);
            if (!m.matches()) continue;
            _logger.fine("[Zipper] File: " + file + " is part of the exclude patterns.");
            return true;
        }
        _logger.fine("[Zipper] File: " + file + " is not excluded.");
        return false;
    }

    private boolean isIncluded(File f) {
        String file = f.getPath();
        for (Pattern p : this._includePatternList) {
            Matcher m = p.matcher(file);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isAlwaysIncluded(File f) {
        String file = f.getPath();
        for (String name : this._alwaysIncludeList) {
            if (file.indexOf(name) == -1) continue;
            return true;
        }
        return false;
    }

    private void addDirectoryToListInternal(File directory, List out, String baseDir, boolean ignoreExclude) throws IOException, FileNotFoundException {
        if (directory.exists() && (this.isAlwaysIncluded(directory) || !this.isExcluded(directory, ignoreExclude))) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = baseDir + PATH_SEPARATOR + files[i].getName();
                if (files[i].isFile()) {
                    this.addFileToListInternal(files[i], fileName, out, false);
                    continue;
                }
                if (files[i].isDirectory()) {
                    this.addDirectoryToListInternal(files[i], out, fileName, false);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void addDirectoryToZipInternal(File directory, ZipOutputStream out, String baseDir, boolean ignoreExclude) throws IOException, FileNotFoundException {
        assert (directory.isDirectory());
        if (directory.exists() && (this.isAlwaysIncluded(directory) || !this.isExcluded(directory, ignoreExclude))) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = baseDir + PATH_SEPARATOR + files[i].getName();
                if (files[i].isFile()) {
                    this.addFileToZipInternal(files[i], fileName, out, false);
                    continue;
                }
                if (files[i].isDirectory()) {
                    this.addDirectoryToZipInternal(files[i], out, fileName, false);
                    continue;
                }
                assert (false);
            }
        }
    }

    public static void usage() {
        System.out.println("usage: directory-name zip-file-name <time>");
        System.exit(1);
    }

    public static void main(String[] argv) {
        try {
            long modifiedTime = System.currentTimeMillis();
            if (argv.length < 2 || argv.length > 3) {
                Zipper.usage();
            }
            if (argv.length == 3) {
                modifiedTime = Long.parseLong(argv[2]);
            }
            System.out.println("modifiedTime is " + modifiedTime);
            Zipper z = new Zipper(".", modifiedTime);
            z.createZipFileFromDirectory(argv[0], argv[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        _localStrMgr = StringManager.getManager(Zipper.class);
        String useNioTemp = null;
        try {
            useNioTemp = System.getProperty(USE_NIO_KEY);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "[Zipper] Error while initializing system environment variable: com.sun.appserv.zip.nio", e);
        }
        _useNio = useNioTemp;
    }
}

