/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.AbstractPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.JoinNotificationEventHandler;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;

public class InputPipeWrapper
extends AbstractPipeWrapper
implements PipeMsgListener {
    private static final String InstanceNameMessage = "instance_name";
    private static final String ReadyMessage = "ready";
    private static final String MESSAGE_MODE = "message_mode";
    private static final String MESSAGE_ID = "message_id";
    private static final String MESSAGE_COMMAND = "message_command";
    private static final String MESSAGE_BROADCAST_QUERY = "broadcastFindSession";
    private static final String RETURN_BROADCAST_MSG_COMMAND = "broadcastResponse";
    private static final String MESSAGE_READY = "ready";
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private InputPipe _pipe = null;
    private String _name = null;

    public InputPipeWrapper() {
    }

    public InputPipeWrapper(String name, InputPipe pipe) {
        this._name = name;
        this._pipe = pipe;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message msg = null;
        try {
            String theCommand;
            MessageElement commandMsgElement;
            MessageElement idMsgElement;
            msg = event.getMessage();
            if (msg == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Received an empty message, returning");
                }
                return;
            }
            MessageElement instanceNameMsgElement = msg.getMessageElement(InstanceNameMessage, InstanceNameMessage);
            String returnInstance = null;
            if (instanceNameMsgElement != null) {
                returnInstance = instanceNameMsgElement.toString();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("InputPipeWrapper:incoming propagated msg from: " + returnInstance);
                }
            }
            if (returnInstance.equalsIgnoreCase(this.getInstanceName())) {
                return;
            }
            MessageElement readyMsgElement = msg.getMessageElement("ready", "ready");
            if (readyMsgElement != null) {
                System.out.println("readyMsgElement=" + readyMsgElement.toString() + " from: " + returnInstance);
                JoinNotificationEventHandler.checkAndDoJoinFor(returnInstance);
            }
            if ((idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID)) != null) {
                // empty if block
            }
            if ((commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND)) != null && ((theCommand = commandMsgElement.toString()).equals(MESSAGE_BROADCAST_QUERY) || theCommand.equals(RETURN_BROADCAST_MSG_COMMAND))) {
                this.processQueryMessage(msg, idMsgElement, returnInstance);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void displayKeyMessageElements(Message msg) {
        MessageElement commandMsgElement;
        MessageElement idMsgElement;
        System.out.println("PropagatedPipeWrapper>>pipeMsgEvent:msg=" + msg);
        MessageElement instanceNameMsgElement = msg.getMessageElement(InstanceNameMessage, InstanceNameMessage);
        String returnInstance = null;
        if (instanceNameMsgElement != null) {
            returnInstance = instanceNameMsgElement.toString();
            System.out.println("PropagatedPipeWrapper>>pipeMsgEvent:fromInstance=" + returnInstance);
            if (!this.isMessageFromYourself(returnInstance)) {
                System.out.println("incoming propagated msg from: " + returnInstance);
            }
        }
        if ((idMsgElement = msg.getMessageElement(MESSAGE_ID, MESSAGE_ID)) != null) {
            System.out.println("idMsgElement=" + idMsgElement.toString());
        }
        if ((commandMsgElement = msg.getMessageElement(MESSAGE_COMMAND, MESSAGE_COMMAND)) != null) {
            String theCommand = commandMsgElement.toString();
            System.out.println("incoming msg to broadcast pipe:command=" + theCommand);
        }
    }

    private void processQueryMessage(Message msg, MessageElement idMsgElement, String returnInstance) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("InputPipeWrapper>>processQueryMessage");
        }
        if (idMsgElement.toString() == null) {
            System.out.println("null id msg received");
            return;
        }
        ReplicationState state = this.createReplicationState(msg);
        ReplicationMessageRouter receiver = ReplicationMessageRouter.createInstance();
        receiver.processQueryMessage(state, returnInstance);
    }

    private ReplicationState createReplicationState(Message msg) {
        return ReplicationState.createBroadcastReplicationState(msg);
    }

    public void cleanup() {
        System.out.println("InputPipeWrapper>>cleanup called");
        if (this._pipe != null) {
            this._pipe.close();
            System.out.println("InputPipeWrapper>>_pipe.close() called");
        }
        this._pipe = null;
        this._name = null;
    }

    void setPipe(InputPipe pipe) {
        this._pipe = pipe;
    }
}

