/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.BackingStoreRegistry;
import com.sun.appserv.ha.spi.DuplicateFactoryRegistrationException;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GMSNotEnabledException;
import com.sun.enterprise.ee.cms.core.GMSNotInitializedException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.web.sessmgmt.FailureNotificationEventHandler;
import com.sun.enterprise.ee.web.sessmgmt.FailureSuspectedNotificationEventHandler;
import com.sun.enterprise.ee.web.sessmgmt.JoinNotificationEventHandler;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBiDiPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReceiverPipeManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaServerPipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.JxtaStarter;
import com.sun.enterprise.ee.web.sessmgmt.PipePool;
import com.sun.enterprise.ee.web.sessmgmt.PipePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.PipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.PlannedShutdownNotificationEventHandler;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.ReplicationReceiver;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.util.JxtaBiDiPipe;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;

public class JxtaReplicationReceiver
implements Runnable,
ReplicationReceiver {
    private static final String REPLICATED_PERSISTENCE_TYPE = "replicated";
    private static final String REPLICATED_STORE_FACTORY_CLASS = "com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreFactory";
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    private static JxtaReplicationReceiver _soleInstance = null;
    private static final Object _monitor = new Object();
    protected static final String SENDER_PIPE = "S";
    protected static final String RECEIVER_PIPE = "R";
    protected EmbeddedWebContainer _embedded = null;
    protected HashMap _appsMap = new HashMap();
    private JxtaBiDiPipeWrapper _jxtaBiDiPipeWrapper = null;
    protected JxtaServerPipeWrapper _jxtaServerPipeWrapper = null;
    protected boolean started = false;
    protected boolean reinitializing = false;
    protected volatile boolean pipeInitializationCalled = false;
    protected Thread thread = null;
    protected volatile boolean threadDone = false;
    protected String _threadName = "JxtaReplicationReceiver";

    public String getThreadName() {
        return this._threadName;
    }

    public JxtaReplicationReceiver(EmbeddedWebContainer embedded) {
        this();
        this._embedded = embedded;
        this._appsMap = new HashMap();
    }

    public JxtaReplicationReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JxtaReplicationReceiver createInstance(EmbeddedWebContainer embedded) {
        Object object = _monitor;
        synchronized (object) {
            if (_soleInstance == null) {
                _soleInstance = new JxtaReplicationReceiver(embedded);
            } else {
                JxtaReplicationReceiver._soleInstance._embedded = embedded;
            }
        }
        return _soleInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JxtaReplicationReceiver createInstance() {
        Object object = _monitor;
        synchronized (object) {
            if (_soleInstance == null) {
                _soleInstance = new JxtaReplicationReceiver();
            }
        }
        return _soleInstance;
    }

    private boolean isDAS() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.isDAS();
    }

    public void init() {
        if (this.isDAS()) {
            return;
        }
        Properties env = new Properties();
        this.fillPropertiesFromLifeCycle(env);
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        try {
            backingStoreRegistry.register(REPLICATED_PERSISTENCE_TYPE, REPLICATED_STORE_FACTORY_CLASS, env);
        }
        catch (DuplicateFactoryRegistrationException ex) {
            System.out.println("duplicate persistence type: cannot register");
        }
        ReplicationMessageRouter router = ReplicationMessageRouter.createInstance(this._embedded);
    }

    public void initPrevious() {
        JxtaBiDiPipeWrapper bidiPipeWrapper;
        JxtaServerPipeWrapper serverPipeWrapper;
        if (this.isDAS()) {
            return;
        }
        ReplicationHealthChecker.setReplicationCommunicationOperational(false, false);
        Properties env = new Properties();
        this.fillPropertiesFromLifeCycle(env);
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        try {
            backingStoreRegistry.register(REPLICATED_PERSISTENCE_TYPE, REPLICATED_STORE_FACTORY_CLASS, env);
        }
        catch (DuplicateFactoryRegistrationException ex) {
            System.out.println("duplicate persistence type: cannot register");
        }
        ReplicationMessageRouter router = ReplicationMessageRouter.createInstance(this._embedded);
        this._jxtaServerPipeWrapper = serverPipeWrapper = new JxtaServerPipeWrapper();
        System.out.println("JxtaReplicationReceiver:about to call JxtaServerPipeWrapper.start()");
        serverPipeWrapper.start();
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this._jxtaBiDiPipeWrapper = bidiPipeWrapper = new JxtaBiDiPipeWrapper();
        System.out.println("JxtaReplicationReceiver:about to call JxtaBiDiPipeWrapper.start()");
        bidiPipeWrapper.start();
        ReplicationHealthChecker.setReplicationReceiver(this);
        this.checkAndRegisterWithGMS();
        System.out.println("JxtaReplicationReceiver:JxtaBiDiPipeWrapper.start() complete");
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPipeInitialization() {
        JxtaBiDiPipeWrapper bidiPipeWrapper;
        JxtaServerPipeWrapper serverPipeWrapper;
        Object object = _monitor;
        synchronized (object) {
            System.out.println("JxtaReplicationReceiver>>doPipeInitialization:previously called = " + this.pipeInitializationCalled);
            if (this.pipeInitializationCalled) {
                return;
            }
            this.pipeInitializationCalled = true;
        }
        this._jxtaServerPipeWrapper = serverPipeWrapper = new JxtaServerPipeWrapper();
        System.out.println("JxtaReplicationReceiver:about to call JxtaServerPipeWrapper.start()");
        serverPipeWrapper.start();
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("initializing _jxtaBiDiPipeWrapper");
        }
        this._jxtaBiDiPipeWrapper = bidiPipeWrapper = new JxtaBiDiPipeWrapper();
        System.out.println("JxtaReplicationReceiver:about to call JxtaBiDiPipeWrapper.start()");
        bidiPipeWrapper.start();
        ReplicationHealthChecker.setReplicationReceiver(this);
        this.checkAndRegisterWithGMS();
        System.out.println("JxtaReplicationReceiver:JxtaBiDiPipeWrapper.start() complete");
        this.started = true;
    }

    protected void fillPropertiesFromLifeCycle(Properties env) {
    }

    private void checkAndRegisterWithGMS() {
        JxtaStarter jxtaStarter = JxtaStarter.createInstance();
        if (jxtaStarter.checkGMS()) {
            this.registerWithGMS();
        }
    }

    private void registerWithGMS() {
        try {
            GroupManagementService gms = GMSFactory.getGMSModule((String)this.getClusterName());
            gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl((CallBack)new JoinNotificationEventHandler()));
            gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl((CallBack)new FailureNotificationEventHandler()));
            gms.addActionFactory((FailureSuspectedActionFactory)new FailureSuspectedActionFactoryImpl((CallBack)new FailureSuspectedNotificationEventHandler()));
            gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl((CallBack)new PlannedShutdownNotificationEventHandler()));
        }
        catch (GMSNotInitializedException ex1) {
        }
        catch (GMSNotEnabledException ex2) {
        }
        catch (GMSException gMSException) {
            // empty catch block
        }
    }

    public boolean isPipeInitializationCalled() {
        return this.pipeInitializationCalled;
    }

    private String getClusterName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getClusterName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInit(String senderOrReceiverFailure, String partnerInstanceName) {
        System.out.println("JxtaReplicationReceiver>>reInit(): reinitializing=" + this.reinitializing + " senderOrReceiverFailure=" + senderOrReceiverFailure + " partnerInstanceName=" + partnerInstanceName);
        if (this.isDAS()) {
            return;
        }
        JxtaReplicationReceiver jxtaReplicationReceiver = this;
        synchronized (jxtaReplicationReceiver) {
            if (this.reinitializing) {
                return;
            }
            this.reinitializing = true;
        }
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        boolean clusterSizeTwo = this._jxtaBiDiPipeWrapper.isSizeTwoCluster();
        System.out.println("JxtaReplicationReceiver>>reInit(): clusterSizeTwo = " + clusterSizeTwo);
        if (clusterSizeTwo || this.isReceiverSideFailure(senderOrReceiverFailure)) {
            this.restartReceiverSide(partnerInstanceName);
        }
        if (clusterSizeTwo) {
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (clusterSizeTwo || this.isSenderSideFailure(senderOrReceiverFailure)) {
            this.reshapeSenderSide(partnerInstanceName);
        }
        JxtaReplicationReceiver jxtaReplicationReceiver2 = this;
        synchronized (jxtaReplicationReceiver2) {
            if (this.reinitializing) {
                try {
                    Thread.currentThread();
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            this.reinitializing = false;
        }
    }

    void restartReceiverSide(String partnerInstanceName) {
        System.out.println("JxtaReplicationReceiver:about to call JxtaServerPipeWrapper.restart()for partnerInstanceName:" + partnerInstanceName);
        this._jxtaServerPipeWrapper.restart(partnerInstanceName);
    }

    void restartSenderSide() {
        ReplicationHealthChecker.setReplicationCommunicationOperational(false, false);
        System.out.println("JxtaReplicationReceiver:about to call JxtaBiDiPipeWrapper.restart()");
        this._jxtaBiDiPipeWrapper.restart();
        System.out.println("JxtaReplicationReceiver:JxtaBiDiPipeWrapper.restart() complete");
    }

    public void connectSenderSideToNew(String newPartnerInstance) {
        this._jxtaBiDiPipeWrapper.connectToNew(newPartnerInstance);
    }

    public void respondToFailure(String failedPartnerInstance) {
        this._jxtaServerPipeWrapper.respondToFailure(failedPartnerInstance);
        this._jxtaBiDiPipeWrapper.respondToFailure(failedPartnerInstance);
    }

    public void respondToFailure(String failedPartnerInstance, boolean ignoreReceiverSideFailure) {
        if (!ignoreReceiverSideFailure) {
            this._jxtaServerPipeWrapper.respondToFailure(failedPartnerInstance);
        }
        this._jxtaBiDiPipeWrapper.respondToFailure(failedPartnerInstance);
    }

    void reshapeSenderSide(String partnerInstanceName) {
        ReplicationHealthChecker.setReplicationCommunicationOperational(false, false);
        System.out.println("JxtaReplicationReceiver:about to call JxtaBiDiPipeWrapper.reshape()");
        this._jxtaBiDiPipeWrapper.reshape(partnerInstanceName);
        System.out.println("JxtaReplicationReceiver:JxtaBiDiPipeWrapper.reshape() complete");
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        ReplicationHealthChecker.setStopping(true);
        ReplicationHealthChecker.setReplicationCommunicationOperational(false, false);
        System.out.println("JxtaReplicationReceiver:about to call JxtaServerPipeWrapper.stop()");
        this._jxtaServerPipeWrapper.stop();
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.out.println("JxtaReplicationReceiver:about to call JxtaBiDiPipeWrapper.stop()");
        this._jxtaBiDiPipeWrapper.stop();
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        backingStoreRegistry.remove(REPLICATED_PERSISTENCE_TYPE);
        this.started = false;
    }

    public void repairOnCurrentThread() {
        if (this._jxtaBiDiPipeWrapper != null) {
            this._jxtaBiDiPipeWrapper.repairOnCurrentThread();
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("not doing unload because no replication-enabled app was ever deployed");
        }
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
        }
    }

    public void processMessage(ReplicationState state) {
        if (state.isReturnMessage() || state.isVoidMethodReturnState()) {
            // empty if block
        }
        this.routeMessageForApp(state.getAppId(), state);
    }

    public void routeMessageForApp(String appName, ReplicationState message) {
        _logger.finest("IN JxtaReplicationReceiver:routeMessageForApp" + appName);
        ReplicationManager mgr = null;
        mgr = this.findApp(appName);
        if (mgr != null) {
            mgr.processMessage(message);
            return;
        }
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManagerBase)nextManager).getApplicationId();
                        _logger.finest("nextAppName = " + nextAppName + ", appName = " + appName);
                        if (!nextAppName.equals(appName)) continue;
                        _logger.finest("found our manager:" + nextManager.getClass().getName());
                        this.addApp(appName, (ReplicationManager)nextManager);
                        ((ReplicationManager)nextManager).processMessage(message);
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(String appName, ReplicationManager mgr) {
        HashMap hashMap = this._appsMap;
        synchronized (hashMap) {
            this._appsMap.put(appName, mgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(String appName) {
        HashMap hashMap = this._appsMap;
        synchronized (hashMap) {
            this._appsMap.remove(appName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationManager findApp(String appName) {
        if (appName == null) {
            return null;
        }
        HashMap hashMap = this._appsMap;
        synchronized (hashMap) {
            ReplicationManager mgr = (ReplicationManager)this._appsMap.get(appName);
            return mgr;
        }
    }

    public void processQueryMessage(ReplicationState message, String returnInstance) {
        this.routeQueryMessageForApp(message.getAppId(), message, returnInstance);
    }

    public void routeQueryMessageForApp(String appName, ReplicationState message, String returnInstance) {
        _logger.finest("IN JxtaReplicationReceiver:routeQueryMessageForApp" + appName);
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ReplicationManager)) continue;
                        String nextAppName = ((ReplicationManagerBase)nextManager).getApplicationId();
                        _logger.finest("nextAppName = " + nextAppName + ", appName = " + appName);
                        if (!nextAppName.equals(appName)) continue;
                        _logger.finest("found our manager:" + nextManager.getClass().getName());
                        ((ReplicationManager)nextManager).processQueryMessage(message, returnInstance);
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
    }

    public ReplicationState sendReplicationStateResponse(ReplicationState state) {
        this.sendOverPipe(state, true);
        return state;
    }

    private boolean sendOverPipe(ReplicationState state) {
        return this.sendOverPipe(state, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendOverPipe(ReplicationState state, boolean isResponse) {
        JxtaBiDiPipe thePipe = null;
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        String sourceInstanceName = state.getInstanceName();
        if (sourceInstanceName == null) {
            System.out.println("PROBLEM:sendOverPipe:isResponse=" + isResponse + " command=" + state.getCommand());
        }
        PipeWrapper thePipeWrapper = null;
        try {
            thePipeWrapper = this.getPipeWrapper(sourceInstanceName);
            if (thePipeWrapper == null) {
                return false;
            }
            thePipe = thePipeWrapper.getPipe();
            if (thePipe == null) {
                return false;
            }
            Message theMsg = this.createMessage(state, isResponse);
            try {
                thePipe.sendMessage(theMsg);
                result = true;
            }
            catch (IOException ex) {
                System.out.println("IOException sending message");
                ex.printStackTrace();
                result = false;
            }
            finally {
                try {
                    this.putPipeWrapper(thePipeWrapper, sourceInstanceName);
                }
                catch (InterruptedException iex) {}
            }
        }
        catch (InterruptedException iex2) {
            result = false;
        }
        return result;
    }

    private Message createMessage(ReplicationState state, boolean isResponse) {
        return ReplicationState.createMessage(state, isResponse);
    }

    private PipeWrapper getPipeWrapper(String sourceInstanceName) throws InterruptedException {
        JxtaReceiverPipeManager receiverPipeManager = JxtaReceiverPipeManager.createInstance();
        PipePool pool = receiverPipeManager.getPipePool(sourceInstanceName);
        PipeWrapper pipeWrapper = null;
        if (pool == null) {
            System.out.println("getPipeWrapper:sourceInstanceName=" + sourceInstanceName + " pool=" + pool);
        }
        PipePoolElement poolElement = pool.take();
        pipeWrapper = (PipeWrapper)poolElement;
        return pipeWrapper;
    }

    private void putPipeWrapper(PipeWrapper thePipeWrapper, String sourceInstanceName) throws InterruptedException {
        if (thePipeWrapper == null || thePipeWrapper.isPipeClosed()) {
            return;
        }
        JxtaReceiverPipeManager receiverPipeManager = JxtaReceiverPipeManager.createInstance();
        PipePool pool = receiverPipeManager.getPipePool(sourceInstanceName);
        pool.put(thePipeWrapper);
    }

    boolean isSenderSideFailure(String senderOrReceiver) {
        return SENDER_PIPE.equals(senderOrReceiver);
    }

    boolean isReceiverSideFailure(String senderOrReceiver) {
        return RECEIVER_PIPE.equals(senderOrReceiver);
    }

    public String getApplicationName(Context ctx) {
        return ctx.getName();
    }

    JxtaBiDiPipeWrapper getJxtaBiDiPipeWrapper() {
        return this._jxtaBiDiPipeWrapper;
    }
}

