/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.MessageElement;
import net.jxta.logging.Logging;

public class ByteArrayMessageElement
extends MessageElement {
    private static final transient Logger LOG = Logger.getLogger(ByteArrayMessageElement.class.getName());
    protected byte[] b;
    protected int offset;
    protected int len;

    public ByteArrayMessageElement(String name, MimeMediaType type, byte[] b, MessageElement sig) {
        this(name, type, b, 0, b.length, sig);
    }

    public ByteArrayMessageElement(String name, MimeMediaType type, byte[] b, int offset, MessageElement sig) {
        this(name, type, b, offset, b.length - offset, sig);
    }

    public ByteArrayMessageElement(String name, MimeMediaType type, byte[] b, int offset, int len, MessageElement sig) {
        super(name, type, sig);
        if (null == b) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len must be >= 0 : " + len);
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must within byte array : " + offset);
        }
        if (0 != len && offset >= b.length) {
            throw new IllegalArgumentException("offset must be positioned within byte array : " + offset + "," + len);
        }
        if (offset + len > b.length || offset + len < 0) {
            throw new IllegalArgumentException("offset + len must be positioned within byte array");
        }
        if (0 == len && 0 != b.length) {
            b = new byte[len];
            offset = 0;
        }
        this.b = b;
        this.offset = offset;
        this.len = len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof ByteArrayMessageElement) {
                ByteArrayMessageElement likeMe = (ByteArrayMessageElement)target;
                ByteArrayMessageElement byteArrayMessageElement = this;
                synchronized (byteArrayMessageElement) {
                    ByteArrayMessageElement byteArrayMessageElement2 = likeMe;
                    synchronized (byteArrayMessageElement2) {
                        if (likeMe.len != this.len) {
                            return false;
                        }
                        for (int eachByte = this.len - 1; eachByte >= 0; --eachByte) {
                            if (likeMe.b[likeMe.offset + eachByte] == this.b[this.offset + eachByte]) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            try {
                int its;
                int mine;
                MessageElement likeMe = (MessageElement)target;
                InputStream myStream = this.getStream();
                InputStream itsStream = likeMe.getStream();
                do {
                    if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                    return false;
                } while (-1 != mine && -1 != its);
                return -1 == mine && -1 == its;
            }
            catch (IOException fatal) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "MessageElements could not be compared.", fatal);
                }
                throw new IllegalStateException("MessageElements could not be compared." + fatal);
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        CRC32 crc = new CRC32();
        crc.update(this.b, this.offset, this.len);
        int dataHash = (int)crc.getValue();
        int result = super.hashCode() * 6037 + dataHash;
        return 0 != result ? result : 1;
    }

    public synchronized String toString() {
        String result;
        if (null != this.cachedToString && null != (result = (String)this.cachedToString.get())) {
            return result;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("creating toString of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()));
        }
        String charset = this.type.getParameter("charset");
        try {
            result = null == charset ? new String(this.b, this.offset, this.len) : new String(this.b, this.offset, this.len, charset);
        }
        catch (UnsupportedEncodingException caught) {
            result = new String(this.b, this.offset, this.len);
        }
        this.cachedToString = new SoftReference<String>(result);
        return result;
    }

    public long getByteLength() {
        return this.len;
    }

    public synchronized byte[] getBytes(boolean copy) {
        if (!copy && 0 == this.offset && this.b.length == this.len) {
            return this.b;
        }
        byte[] result = new byte[this.len];
        System.arraycopy(this.b, this.offset, result, 0, this.len);
        if (!copy) {
            this.b = result;
            this.offset = 0;
        }
        return result;
    }

    public synchronized InputStream getStream() {
        return new ByteArrayInputStream(this.b, this.offset, this.len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToStream(OutputStream sendTo) throws IOException {
        int sendingOffset;
        byte[] sending;
        ByteArrayMessageElement byteArrayMessageElement = this;
        synchronized (byteArrayMessageElement) {
            sending = this.b;
            sendingOffset = this.offset;
        }
        sendTo.write(sending, sendingOffset, this.len);
    }

    public byte[] getBytes() {
        return this.getBytes(false);
    }
}

