/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeterBuildSettings;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.util.Cache;
import net.jxta.impl.util.CacheEntry;
import net.jxta.impl.util.CacheEntryListener;
import net.jxta.impl.util.ResourceAccount;
import net.jxta.impl.util.ResourceDispatcher;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;

public class QuotaIncomingMessageListener
implements EndpointListener {
    private static final Logger LOG = Logger.getLogger(QuotaIncomingMessageListener.class.getName());
    private static final ResourceDispatcher threadDispatcher = new ResourceDispatcher(100L, 1L, 2L, 150L, 20L, 20L, true, "threadDispatcher");
    static int GmaxMsgSize = 6144;
    static int GmaxSenders = 550;
    static int GminResPerSender = 2 * GmaxMsgSize;
    static int GmaxResPerSender = 3 * GminResPerSender;
    static int TotalExtra = 2 * GmaxResPerSender * GmaxSenders;
    static int MaxExtraPerSender = 8 * GmaxResPerSender;
    static int NeverReserved = TotalExtra / 8;
    private static final ResourceDispatcher messageDispatcher = new ResourceDispatcher(GmaxSenders, GminResPerSender, GmaxResPerSender, TotalExtra, MaxExtraPerSender, NeverReserved, false, "messageDispatcher");
    private static final Cache allSources = new Cache(100L, new MyCacheListener());
    private final PeerGroup group;
    private final UnbiasedQueue messageQueue = new UnbiasedQueue(Integer.MAX_VALUE, false, new LinkedList<Object>());
    private final String name;
    private final InboundMeter incomingMessageListenerMeter;
    private final ResourceAccount myAccount;
    private volatile EndpointListener listener = null;
    private boolean closed = false;
    private long lastLongQueueNotification = 0L;

    public QuotaIncomingMessageListener(PeerGroup group, String name, EndpointListener listener) {
        this(group, name, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaIncomingMessageListener(PeerGroup group, String name, EndpointListener listener, InboundMeter incomingMessageListenerMeter) {
        this.group = group;
        this.listener = listener;
        this.name = name;
        this.incomingMessageListenerMeter = incomingMessageListenerMeter;
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.myAccount = threadDispatcher.newAccount(1L, -1L, this);
            threadDispatcher.notify();
        }
        Thread.yield();
    }

    public String toString() {
        return this.name;
    }

    public EndpointListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MessageFromSource mfs;
        LinkedList<MessageFromSource> rmdMessages = new LinkedList<MessageFromSource>();
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.listener = null;
            this.messageQueue.close();
            if (this.myAccount.isIdle()) {
                this.myAccount.close();
            }
            mfs = null;
            while ((mfs = (MessageFromSource)this.messageQueue.pop()) != null) {
                rmdMessages.add(mfs);
            }
            threadDispatcher.notify();
        }
        Thread.yield();
        resourceDispatcher = messageDispatcher;
        synchronized (resourceDispatcher) {
            while (!rmdMessages.isEmpty()) {
                mfs = (MessageFromSource)rmdMessages.removeFirst();
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.incomingMessageListenerMeter != null) {
                    this.incomingMessageListenerMeter.inboundMessageDropped(mfs.msg, System.currentTimeMillis() - mfs.timeReceived);
                }
                mfs.src.inNeed(false);
                mfs.src.releaseQuantity(mfs.size);
                if (!mfs.src.isIdle()) continue;
                allSources.stickyCacheEntry((CacheEntry)mfs.src.getUserObject(), false);
            }
        }
        rmdMessages = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaIncomingMessageListener doOne() {
        ResourceAccount next;
        block18: {
            MessageFromSource mfs = null;
            ResourceDispatcher resourceDispatcher = threadDispatcher;
            synchronized (resourceDispatcher) {
                mfs = (MessageFromSource)this.messageQueue.pop();
                this.myAccount.inNeed(this.messageQueue.getCurrentInQueue() != 0);
                threadDispatcher.notify();
            }
            if (mfs != null) {
                EndpointListener l;
                resourceDispatcher = messageDispatcher;
                synchronized (resourceDispatcher) {
                    CacheEntry ce;
                    mfs.src.inNeed(false);
                    mfs.src.releaseQuantity(mfs.size);
                    if (mfs.src.isIdle() && null != (ce = (CacheEntry)mfs.src.getUserObject())) {
                        allSources.stickyCacheEntry(ce, false);
                    }
                }
                long timeDequeued = 0L;
                if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.incomingMessageListenerMeter != null) {
                    timeDequeued = System.currentTimeMillis();
                    this.incomingMessageListenerMeter.inboundMessageDeQueued(mfs.msg, timeDequeued - mfs.timeReceived);
                }
                if ((l = this.listener) != null) {
                    try {
                        l.processIncomingMessage(mfs.msg, mfs.srcAddress, mfs.destAddress);
                        if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.incomingMessageListenerMeter != null) {
                            this.incomingMessageListenerMeter.inboundMessageProcessed(mfs.msg, System.currentTimeMillis() - timeDequeued);
                        }
                    }
                    catch (Throwable ignored) {
                        if (!Logging.SHOW_SEVERE || !LOG.isLoggable(Level.SEVERE)) break block18;
                        LOG.log(Level.SEVERE, "Uncaught Throwable in listener : " + this + "(" + l.getClass().getName() + ")", ignored);
                    }
                }
            }
        }
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        synchronized (resourceDispatcher) {
            this.myAccount.inNeed(this.messageQueue.getCurrentInQueue() > 0);
            next = this.myAccount.releaseItem();
            if (this.messageQueue.isClosed() && this.myAccount.isIdle()) {
                this.myAccount.close();
            }
            threadDispatcher.notify();
        }
        if (next == null) {
            return null;
        }
        return (QuotaIncomingMessageListener)next.getUserObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        ResourceAccount msgSrcAccount;
        long msgSize;
        CacheEntry ce;
        long timeReceived;
        block22: {
            if (this.messageQueue.isClosed()) {
                return;
            }
            timeReceived = 0L;
            if (EndpointMeterBuildSettings.ENDPOINT_METERING) {
                timeReceived = System.currentTimeMillis();
            }
            String srcAddrStr = srcAddr.toString();
            ce = null;
            msgSize = message.getByteLength();
            int attempt = 0;
            while (true) {
                if (attempt > 0) {
                    Thread.yield();
                }
                ResourceDispatcher resourceDispatcher = messageDispatcher;
                // MONITORENTER : resourceDispatcher
                ce = allSources.getCacheEntry(srcAddrStr);
                if (ce == null) {
                    msgSrcAccount = messageDispatcher.newAccount(40960L, -1L, srcAddrStr);
                    if (msgSrcAccount.getNbReserved() < 1L) {
                        msgSrcAccount.close();
                        allSources.purge(10);
                        msgSrcAccount = messageDispatcher.newAccount(40960L, -1L, "retrying:" + srcAddrStr);
                    }
                    allSources.put(srcAddrStr, msgSrcAccount);
                    ce = allSources.getCacheEntry(srcAddrStr);
                    msgSrcAccount.setUserObject(ce);
                } else {
                    msgSrcAccount = (ResourceAccount)ce.getValue();
                }
                if (msgSrcAccount.obtainQuantity(msgSize)) break block22;
                if (++attempt >= 2) break;
                // MONITOREXIT : resourceDispatcher
            }
            if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
                LOG.info("Peer exceeds queuing limits; msg discarded.");
            }
            // MONITOREXIT : resourceDispatcher
            return;
        }
        allSources.stickyCacheEntry(ce, true);
        // MONITOREXIT : resourceDispatcher
        boolean obtained = false;
        boolean pushed = false;
        ResourceDispatcher resourceDispatcher = threadDispatcher;
        // MONITORENTER : resourceDispatcher
        do {
            if ((pushed = this.messageQueue.push(new MessageFromSource(message, srcAddr, dstAddr, msgSrcAccount, timeReceived, msgSize))) || !this.messageQueue.isClosed()) continue;
            if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break;
            LOG.fine("queue closed, message discarded");
            break;
        } while (!pushed);
        if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            int queueLen = this.messageQueue.getCurrentInQueue();
            long timeNow = TimeUtils.timeNow();
            if (queueLen > 100 && TimeUtils.toRelativeTimeMillis(timeNow, this.lastLongQueueNotification) > 1000L) {
                this.lastLongQueueNotification = timeNow;
                LOG.warning("Very long queue (" + queueLen + ") for listener: " + this);
            }
        }
        if (EndpointMeterBuildSettings.ENDPOINT_METERING && this.incomingMessageListenerMeter != null) {
            this.incomingMessageListenerMeter.inboundMessageQueued(message);
        }
        if (pushed) {
            obtained = this.myAccount.obtainItem();
        }
        threadDispatcher.notify();
        // MONITOREXIT : resourceDispatcher
        if (!pushed) {
            resourceDispatcher = messageDispatcher;
            // MONITORENTER : resourceDispatcher
            msgSrcAccount.inNeed(false);
            msgSrcAccount.releaseQuantity(msgSize);
            if (msgSrcAccount.isIdle()) {
                allSources.stickyCacheEntry(ce, false);
            }
            // MONITOREXIT : resourceDispatcher
            return;
        }
        if (obtained) {
            ListenerExecutorTask task = new ListenerExecutorTask(this);
            ((StdPeerGroup)this.group).getExecutor().execute(task);
            return;
        }
        if (!Logging.SHOW_INFO) return;
        if (!LOG.isLoggable(Level.INFO)) return;
        LOG.info("Listener '" + this + "' exceeds thread's limits; msg waits.");
    }

    private static class ListenerExecutorTask
    implements Runnable {
        private QuotaIncomingMessageListener listener;

        ListenerExecutorTask(QuotaIncomingMessageListener listener) {
            this.listener = listener;
        }

        public void run() {
            try {
                while (this.listener != null) {
                    this.listener = this.listener.doOne();
                }
            }
            catch (Throwable all) {
                LOG.log(Level.SEVERE, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
            }
        }
    }

    private static class MessageFromSource {
        final Message msg;
        final EndpointAddress srcAddress;
        final EndpointAddress destAddress;
        final ResourceAccount src;
        final long timeReceived;
        final long size;

        MessageFromSource(Message msg, EndpointAddress srcAddress, EndpointAddress destAddress, ResourceAccount src, long timeReceived, long size) {
            this.msg = msg;
            this.src = src;
            this.srcAddress = srcAddress;
            this.destAddress = destAddress;
            this.timeReceived = timeReceived;
            this.size = size;
        }
    }

    static class MyCacheListener
    implements CacheEntryListener {
        MyCacheListener() {
        }

        public void purged(CacheEntry entry) {
            ((ResourceAccount)entry.getValue()).close();
        }
    }
}

