/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import java.util.Hashtable;
import java.util.Map;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeter;
import net.jxta.impl.endpoint.endpointMeter.EndpointMetric;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMetric;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitorFilter;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.endpoint.endpointMeter.InboundMetric;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.impl.endpoint.endpointMeter.OutboundMetric;
import net.jxta.impl.endpoint.endpointMeter.PropagationMeter;
import net.jxta.impl.endpoint.endpointMeter.PropagationMetric;
import net.jxta.impl.meter.GenericServiceMonitor;
import net.jxta.meter.ServiceMetric;
import net.jxta.meter.ServiceMonitorFilter;

public class EndpointServiceMonitor
extends GenericServiceMonitor {
    private EndpointServiceMetric cumulativeEndpointServiceMetric;
    private final Map<String, InboundMeter> inboundMeters = new Hashtable<String, InboundMeter>();
    private final Map<EndpointAddress, OutboundMeter> outboundMeters = new Hashtable<EndpointAddress, OutboundMeter>();
    private final Map<String, PropagationMeter> propagationMeters = new Hashtable<String, PropagationMeter>();
    private final EndpointMeter endpointMeter = new EndpointMeter();

    protected void init() {
        this.cumulativeEndpointServiceMetric = (EndpointServiceMetric)this.getCumulativeServiceMetric();
        this.cumulativeEndpointServiceMetric.setEndpointMetric(this.endpointMeter.getCumulativeMetrics());
    }

    public EndpointMeter getEndpointMeter() {
        return this.endpointMeter;
    }

    public synchronized InboundMeter getInboundMeter(String serviceName, String serviceParam) {
        InboundMeter inboundMeter;
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        if ((inboundMeter = this.inboundMeters.get(address)) == null) {
            inboundMeter = new InboundMeter(serviceName, serviceParam);
            this.inboundMeters.put(address, inboundMeter);
            this.cumulativeEndpointServiceMetric.addInboundMetric(inboundMeter.getCumulativeMetrics());
        }
        return inboundMeter;
    }

    public synchronized PropagationMeter getPropagationMeter(String serviceName, String serviceParam) {
        PropagationMeter propagationMeter;
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        if ((propagationMeter = this.propagationMeters.get(address)) == null) {
            propagationMeter = new PropagationMeter(serviceName, serviceParam);
            this.propagationMeters.put(address, propagationMeter);
            this.cumulativeEndpointServiceMetric.addPropagationMetric(propagationMeter.getCumulativeMetrics());
        }
        return propagationMeter;
    }

    public synchronized OutboundMeter getOutboundMeter(EndpointAddress endpointAddress) {
        OutboundMeter outboundMeter = this.outboundMeters.get(endpointAddress);
        if (outboundMeter == null) {
            outboundMeter = new OutboundMeter(endpointAddress);
            this.cumulativeEndpointServiceMetric.addOutboundMetric(outboundMeter.getCumulativeMetrics());
            this.outboundMeters.put(endpointAddress, outboundMeter);
        }
        return outboundMeter;
    }

    public ServiceMetric getServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime, int pulseIndex, long reportRate) {
        int deltaReportRateIndex = this.monitorManager.getReportRateIndex(reportRate);
        EndpointServiceMetric origEndpointServiceMetric = (EndpointServiceMetric)this.deltaServiceMetrics[deltaReportRateIndex];
        if (origEndpointServiceMetric == null) {
            return null;
        }
        EndpointServiceMonitorFilter endpointServiceMonitorFilter = (EndpointServiceMonitorFilter)serviceMonitorFilter;
        return origEndpointServiceMetric.shallowCopy(endpointServiceMonitorFilter);
    }

    public ServiceMetric getCumulativeServiceMetric(ServiceMonitorFilter serviceMonitorFilter, long fromTime, long toTime) {
        EndpointServiceMetric origEndpointServiceMetric = (EndpointServiceMetric)this.cumulativeServiceMetric;
        EndpointServiceMonitorFilter endpointServiceMonitorFilter = (EndpointServiceMonitorFilter)serviceMonitorFilter;
        return origEndpointServiceMetric.deepCopy(endpointServiceMonitorFilter);
    }

    protected ServiceMetric collectServiceMetrics() {
        EndpointServiceMetric endpointServiceMetric = (EndpointServiceMetric)this.createServiceMetric();
        boolean anyData = false;
        for (InboundMeter inboundMeter : this.inboundMeters.values()) {
            InboundMetric inboundMetric = inboundMeter.collectMetrics();
            if (inboundMetric == null) continue;
            endpointServiceMetric.addInboundMetric(inboundMetric);
            anyData = true;
        }
        for (OutboundMeter outboundMeter : this.outboundMeters.values()) {
            OutboundMetric outboundMetric = outboundMeter.collectMetrics();
            if (outboundMetric == null) continue;
            endpointServiceMetric.addOutboundMetric(outboundMetric);
            anyData = true;
        }
        for (PropagationMeter propagationMeter : this.propagationMeters.values()) {
            PropagationMetric propagationMetric = propagationMeter.collectMetrics();
            if (propagationMetric == null) continue;
            endpointServiceMetric.addPropagationMetric(propagationMetric);
            anyData = true;
        }
        EndpointMetric endpointMetric = this.endpointMeter.collectMetrics();
        if (endpointMetric != null) {
            endpointServiceMetric.setEndpointMetric(endpointMetric);
            anyData = true;
        }
        if (anyData) {
            return endpointServiceMetric;
        }
        return null;
    }
}

