/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.util.HashSet;
import java.util.Set;
import net.jxta.peer.PeerID;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BadRoute {
    private final RouteAdvertisement badRoute;
    private final Set<PeerID> badHops = new HashSet<PeerID>();
    private long expiration;

    BadRoute(RouteAdvertisement route, long exp, Set<PeerID> hops) {
        this.badRoute = route;
        this.expiration = exp;
        this.badHops.addAll(hops);
    }

    public RouteAdvertisement getRoute() {
        if (this.badRoute != null) {
            return this.badRoute.clone();
        }
        return null;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long exp) {
        this.expiration = exp;
    }

    public Set<PeerID> getBadHops() {
        HashSet<PeerID> hops = new HashSet<PeerID>(this.badHops);
        return hops;
    }

    public void setBadHops(Set<PeerID> hops) {
        this.badHops.clear();
        this.addBadHops(hops);
    }

    public void addBadHops(Set<PeerID> hops) {
        this.badHops.addAll(hops);
    }

    public void addBadHop(PeerID hop) {
        this.badHops.add(hop);
    }

    public String toString() {
        StringBuilder routeBuf = new StringBuilder();
        routeBuf.append("Bad ").append(this.getRoute().display());
        routeBuf.append("\tExp: ").append(this.getExpiration());
        routeBuf.append("\tHops: ");
        for (PeerID eachBadHop : this.getBadHops()) {
            routeBuf.append("\t\t").append(eachBadHop);
        }
        return routeBuf.toString();
    }
}

