/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.logging.Logging;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRouterMessage {
    private static final Logger LOG = Logger.getLogger(EndpointRouterMessage.class.getName());
    public static final String MESSAGE_NS = "jxta";
    public static final String MESSAGE_NAME = "EndpointRouterMsg";
    public static final String Name = "jxta:ERM";
    public static final String SrcTag = "Src";
    public static final String DestTag = "Dest";
    public static final String LastHopTag = "Last";
    public static final String GatewayForwardTag = "Fwd";
    public static final String GatewayReverseTag = "Rvs";
    private EndpointAddress srcAddress = null;
    private EndpointAddress destAddress = null;
    private EndpointAddress lastHop = null;
    private transient Vector<AccessPointAdvertisement> forwardGateways = null;
    private transient Vector<XMLElement> forwardCache = null;
    private transient Vector<AccessPointAdvertisement> reverseGateways = null;
    private transient Vector<XMLElement> reverseCache = null;
    private transient RouteAdvertisement radv = null;
    private transient boolean rmExists = false;
    private transient boolean rmDirty = false;
    private final transient Message message;
    private transient MessageElement rmElem = null;

    public boolean msgExists() {
        return this.rmExists;
    }

    public boolean isDirty() {
        return this.rmDirty;
    }

    public EndpointRouterMessage(Message message, boolean removeMsg) {
        this.message = message;
        try {
            this.rmElem = message.getMessageElement(MESSAGE_NS, MESSAGE_NAME);
            if (this.rmElem == null) {
                return;
            }
            this.rmDirty = true;
            if (removeMsg) {
                return;
            }
            XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(this.rmElem);
            Enumeration each = doc.getChildren();
            if (!each.hasMoreElements()) {
                return;
            }
            while (each.hasMoreElements()) {
                try {
                    AccessPointAdvertisement xptAdv;
                    XMLElement aXpt;
                    Enumeration eachXpt;
                    XMLElement e = (XMLElement)each.nextElement();
                    if (e.getName().equals(SrcTag)) {
                        this.srcAddress = new EndpointAddress(e.getTextValue());
                        continue;
                    }
                    if (e.getName().equals(DestTag)) {
                        this.destAddress = new EndpointAddress(e.getTextValue());
                        continue;
                    }
                    if (e.getName().equals(LastHopTag)) {
                        this.lastHop = new EndpointAddress(e.getTextValue());
                        continue;
                    }
                    if (e.getName().equals(GatewayForwardTag)) {
                        eachXpt = e.getChildren();
                        while (eachXpt.hasMoreElements()) {
                            if (this.forwardGateways == null) {
                                this.forwardGateways = new Vector();
                            }
                            if (this.forwardCache == null) {
                                this.forwardCache = new Vector();
                            }
                            aXpt = (XMLElement)eachXpt.nextElement();
                            xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                            this.forwardGateways.addElement(xptAdv);
                            this.forwardCache.addElement(aXpt);
                        }
                        continue;
                    }
                    if (e.getName().equals(GatewayReverseTag)) {
                        eachXpt = e.getChildren();
                        while (eachXpt.hasMoreElements()) {
                            if (this.reverseGateways == null) {
                                this.reverseGateways = new Vector();
                            }
                            if (this.reverseCache == null) {
                                this.reverseCache = new Vector();
                            }
                            aXpt = (XMLElement)eachXpt.nextElement();
                            xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                            this.reverseGateways.addElement(xptAdv);
                            this.reverseCache.addElement(aXpt);
                        }
                        continue;
                    }
                    if (!e.getName().equals(RouteAdvertisement.getAdvertisementType())) continue;
                    this.radv = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(e);
                }
                catch (Exception ee) {}
            }
            this.rmExists = true;
            this.rmDirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateMessage() {
        XMLDocument doc;
        block31: {
            XMLDocument xptDoc;
            Object e;
            if (!this.rmDirty) {
                return;
            }
            if (!this.rmExists) {
                while (this.rmElem != null) {
                    this.message.removeMessageElement(MESSAGE_NS, this.rmElem);
                    this.rmElem = this.message.getMessageElement(MESSAGE_NS, MESSAGE_NAME);
                }
                this.rmDirty = false;
                return;
            }
            doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, Name);
            doc.addAttribute("xmlns:jxta", "http://jxta.org");
            doc.addAttribute("xml:space", "preserve");
            if (this.srcAddress != null) {
                e = doc.createElement(SrcTag, this.srcAddress.toString());
                doc.appendChild(e);
            }
            if (this.destAddress != null) {
                e = doc.createElement(DestTag, this.destAddress.toString());
                doc.appendChild(e);
            }
            if (this.lastHop != null) {
                e = doc.createElement(LastHopTag, this.lastHop.toString());
                doc.appendChild(e);
            }
            e = doc.createElement(GatewayForwardTag);
            doc.appendChild(e);
            if (this.forwardGateways != null && !this.forwardGateways.isEmpty()) {
                if (this.forwardCache != null) {
                    for (XMLElement xptDoc2 : this.forwardCache) {
                        try {
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc2);
                        }
                        catch (Exception e1) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Forward cache failed");
                            }
                            this.forwardCache = null;
                            break;
                        }
                    }
                } else {
                    for (AccessPointAdvertisement gateway : this.forwardGateways) {
                        try {
                            xptDoc = (XMLDocument)gateway.getDocument(MimeMediaType.XMLUTF8);
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc);
                        }
                        catch (Exception ignored) {}
                    }
                }
            }
            e = doc.createElement(GatewayReverseTag);
            doc.appendChild(e);
            if (this.reverseGateways != null && !this.reverseGateways.isEmpty()) {
                if (this.reverseCache != null) {
                    for (XMLElement xptDoc2 : this.reverseCache) {
                        try {
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc2);
                        }
                        catch (Exception e1) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.warning("Reverse cache failed");
                            }
                            this.reverseCache = null;
                            break;
                        }
                    }
                } else {
                    for (AccessPointAdvertisement gateway : this.reverseGateways) {
                        try {
                            xptDoc = (XMLDocument)gateway.getDocument(MimeMediaType.XMLUTF8);
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc);
                        }
                        catch (Exception e1) {}
                    }
                }
            }
            if (this.radv != null) {
                try {
                    XMLDocument radvDoc = (XMLDocument)this.radv.getDocument(MimeMediaType.XMLUTF8);
                    StructuredDocumentUtils.copyElements(doc, doc, radvDoc);
                }
                catch (Exception e1) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block31;
                    LOG.warning("Cannot add route advertisement");
                }
            }
        }
        this.rmElem = new TextDocumentMessageElement(MESSAGE_NAME, doc, null);
        this.message.replaceMessageElement(MESSAGE_NS, this.rmElem);
        this.rmDirty = false;
    }

    public void setSrcAddress(EndpointAddress address) {
        this.rmExists = true;
        this.rmDirty = true;
        this.srcAddress = address;
    }

    public EndpointAddress getSrcAddress() {
        return this.srcAddress;
    }

    public void setDestAddress(EndpointAddress address) {
        this.rmExists = true;
        this.rmDirty = true;
        this.destAddress = address;
    }

    public EndpointAddress getDestAddress() {
        return this.destAddress;
    }

    public void setLastHop(EndpointAddress lhop) {
        this.rmExists = true;
        this.rmDirty = true;
        this.lastHop = lhop;
    }

    public EndpointAddress getLastHop() {
        return this.lastHop;
    }

    public void setForwardHops(Vector<AccessPointAdvertisement> fhops) {
        this.rmExists = true;
        this.rmDirty = true;
        this.forwardGateways = fhops;
        this.forwardCache = null;
    }

    public Vector<AccessPointAdvertisement> getForwardHops() {
        return this.forwardGateways;
    }

    public void prependReverseHop(AccessPointAdvertisement apa) {
        this.rmExists = true;
        this.rmDirty = true;
        if (this.reverseGateways == null) {
            this.reverseGateways = new Vector();
            this.reverseCache = new Vector();
        }
        this.reverseGateways.add(0, apa);
        if (this.reverseCache == null) {
            return;
        }
        XMLDocument apDoc = (XMLDocument)apa.getDocument(MimeMediaType.XMLUTF8);
        this.reverseCache.add(0, apDoc);
    }

    public void setReverseHops(Vector<AccessPointAdvertisement> rhops) {
        this.rmExists = true;
        this.rmDirty = true;
        this.reverseGateways = rhops == null ? null : (Vector)rhops.clone();
        this.reverseCache = null;
    }

    public Vector<AccessPointAdvertisement> getReverseHops() {
        if (this.reverseGateways == null) {
            return null;
        }
        return (Vector)this.reverseGateways.clone();
    }

    public RouteAdvertisement getRouteAdv() {
        return this.radv;
    }

    public void setRouteAdv(RouteAdvertisement radv) {
        this.rmExists = true;
        this.rmDirty = true;
        this.radv = radv;
    }

    public String display() {
        int i;
        StringBuilder msgInfo = new StringBuilder("Endpoint Router Message : ");
        msgInfo.append("\n\tsrc=");
        msgInfo.append(this.srcAddress != null ? this.srcAddress : "none");
        msgInfo.append("\n\tdest== ");
        msgInfo.append(this.destAddress != null ? this.destAddress : "none");
        msgInfo.append("\n\tlastHop= ");
        msgInfo.append(this.lastHop != null ? this.lastHop : "none");
        msgInfo.append("\n\tembedded radv= ");
        msgInfo.append(this.radv != null ? this.radv.display() : "none");
        if (this.forwardGateways != null) {
            msgInfo.append("\n\tForward Hops:");
            for (i = 0; i < this.forwardGateways.size(); ++i) {
                try {
                    msgInfo.append("   [").append(i).append("] ");
                    msgInfo.append(this.forwardGateways.elementAt(i).getPeerID());
                    continue;
                }
                catch (Exception ez1) {
                    break;
                }
            }
        }
        if (this.reverseGateways != null) {
            msgInfo.append("\n\tReverse Hops:");
            for (i = 0; i < this.reverseGateways.size(); ++i) {
                msgInfo.append("   [").append(i).append("] ");
                msgInfo.append(this.reverseGateways.elementAt(i).getPeerID());
            }
        }
        return msgInfo.toString();
    }

    public void clearAll() {
        if (this.rmExists) {
            this.rmDirty = true;
            this.srcAddress = null;
            this.destAddress = null;
            this.lastHop = null;
            this.forwardGateways = null;
            this.reverseGateways = null;
            this.radv = null;
            this.rmExists = false;
        }
    }
}

