/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.logging.Logging;
import net.jxta.protocol.RouteAdvertisement;

class RouterMessenger
extends BlockingMessenger {
    private static final transient Logger LOG = Logger.getLogger(RouterMessenger.class.getName());
    private final EndpointRouter router;

    public RouterMessenger(EndpointAddress dstAddress, EndpointRouter r, Object hint) throws IOException {
        super(r.getEndpointService().getGroup().getPeerGroupID(), dstAddress, false);
        EndpointAddress gate;
        this.router = r;
        EndpointAddress plainAddr = new EndpointAddress(dstAddress, null, null);
        if (!(hint instanceof RouteAdvertisement)) {
            hint = null;
        }
        if ((gate = this.router.getGatewayAddress(plainAddr, true, (RouteAdvertisement)hint)) == null) {
            throw new IOException("Could not construct RouterMessenger, no route for " + plainAddr);
        }
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return this.getDestinationAddress();
    }

    public void closeImpl() {
    }

    public boolean isIdleImpl() {
        return false;
    }

    public void sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, failure.getMessage(), failure);
            }
            throw failure;
        }
        EndpointAddress dest = this.getDestAddressToUse(service, serviceParam);
        Throwable lastFailure = null;
        while (true) {
            EndpointAddress sendTo = null;
            try {
                sendTo = this.router.addressMessage(message, dest);
                if (null != sendTo) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Sending " + message + " to " + sendTo);
                    }
                    this.router.sendOnLocalRoute(sendTo, message);
                    return;
                }
            }
            catch (RuntimeException rte) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Failure while routing " + message, rte);
                }
                lastFailure = rte;
            }
            catch (Throwable theMatter) {
                if (sendTo == null) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break;
                    LOG.log(Level.WARNING, "Unknown failure while routing " + message, theMatter);
                    break;
                }
                lastFailure = theMatter;
                EndpointAddress destPeer = new EndpointAddress(this.getDestinationAddress(), null, null);
                this.router.removeRoute(EndpointRouter.addr2pid(destPeer));
                message.removeMessageElement(message.getMessageElement("jxta", "EndpointRouterMsg"));
                continue;
            }
            break;
        }
        if (lastFailure == null) {
            lastFailure = new IOException("Could not find a route for : " + dest);
        }
        if (!(lastFailure instanceof IllegalStateException)) {
            this.close();
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Messenger failed:", lastFailure);
        }
        if (lastFailure instanceof IOException) {
            throw (IOException)lastFailure;
        }
        if (lastFailure instanceof RuntimeException) {
            throw lastFailure;
        }
        if (lastFailure instanceof Error) {
            throw (Error)lastFailure;
        }
        IOException failure = new IOException("Failed sending " + message);
        failure.initCause(lastFailure);
        throw failure;
    }
}

