/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import net.jxta.logging.Logging;

class HttpMessageSender
implements MessageSender {
    private static final transient Logger LOG = Logger.getLogger(HttpMessageSender.class.getName());
    private final ServletHttpTransport servletHttpTransport;
    private final EndpointAddress publicAddress;
    private final Map<HttpClientMessenger, Object> messengers = new WeakHashMap<HttpClientMessenger, Object>();

    public HttpMessageSender(ServletHttpTransport servletHttpTransport, EndpointAddress publicAddress) throws PeerGroupException {
        this.servletHttpTransport = servletHttpTransport;
        this.publicAddress = publicAddress;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring HTTP Client Message Transport : " + servletHttpTransport.assignedID);
            configInfo.append("\n\tPublic Address = ").append(publicAddress);
            LOG.config(configInfo.toString());
        }
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowsRouting() {
        return true;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public synchronized void start() throws PeerGroupException {
        if (this.servletHttpTransport.getEndpointService().addMessageTransport(this) == null) {
            throw new PeerGroupException("Transport registration refused");
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("HTTP Client Transport started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Map<HttpClientMessenger, Object> map = this.messengers;
        synchronized (map) {
            Iterator<HttpClientMessenger> eachMessenger = this.messengers.keySet().iterator();
            while (eachMessenger.hasNext()) {
                HttpClientMessenger aMessenger = eachMessenger.next();
                eachMessenger.remove();
                aMessenger.doShutdown();
            }
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("HTTP Client Transport stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messenger getMessenger(EndpointAddress destAddr, Object hintIgnored) {
        block12: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("getMessenger for : " + destAddr);
            }
            if (!this.getProtocolName().equals(destAddr.getProtocolName())) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Cannot make messenger for protocol :" + destAddr.getProtocolName());
                }
                return null;
            }
            try {
                HttpClientMessenger result = new HttpClientMessenger(this.servletHttpTransport, this.publicAddress, destAddr);
                Map<HttpClientMessenger, Object> map = this.messengers;
                synchronized (map) {
                    this.messengers.put(result, null);
                }
                return result;
            }
            catch (SocketTimeoutException noConnect) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Could not connect to " + destAddr + " : " + noConnect.getMessage());
                }
            }
            catch (ConnectException noConnect) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Failed to connect to " + destAddr + " : " + noConnect.getMessage());
                }
            }
            catch (Throwable e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block12;
                LOG.log(Level.WARNING, "Could not make messenger for " + destAddr, e);
            }
        }
        return null;
    }

    public boolean ping(EndpointAddress addr) {
        Messenger messenger;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Using http client sender to ping " + addr);
        }
        boolean pong = 0 != (0x3FF & (messenger = this.getMessenger(addr, null)).getState());
        messenger.close();
        return pong;
    }

    public String getProtocolName() {
        return this.servletHttpTransport.HTTP_PROTOCOL_NAME;
    }

    public EndpointService getEndpointService() {
        return this.servletHttpTransport.getEndpointService();
    }
}

