/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.logging.Logging;

public class TlsMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger(TlsMessenger.class.getName());
    private TlsTransport transport = null;
    private TlsConn conn = null;
    private final EndpointAddress srcAddress;
    private final MessageElement srcAddressElement;

    TlsMessenger(EndpointAddress destAddress, TlsConn conn, TlsTransport tp) {
        super(tp.getPeerGroup().getPeerGroupID(), destAddress, false);
        if (conn == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("null TLS connection!");
            }
            throw new IllegalArgumentException("null TLS connection!");
        }
        this.conn = conn;
        this.transport = tp;
        this.srcAddress = this.transport.getPublicAddress();
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", this.srcAddress.toString(), (MessageElement)null);
    }

    public synchronized void closeImpl() {
        super.close();
        this.conn = null;
    }

    public boolean isIdleImpl() {
        return false;
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return new EndpointAddress("jxta", this.dstAddress.getProtocolAddress(), null, null);
    }

    public synchronized void sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting send for " + message);
        }
        if (TlsConn.HandshakeState.CONNECTIONDEAD == this.conn.getHandshakeState()) {
            this.close();
        }
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger is closed, it cannot be used to send messages.");
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, failure.getMessage(), failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", this.getDestAddressToUse(service, serviceParam).toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        try {
            this.conn.sendMessage(message);
        }
        catch (IOException caught) {
            this.close();
            if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, "Message send to '" + this.dstAddress + "' failed for " + message, caught);
            }
            throw caught;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Message send to '" + this.dstAddress + "' succeeded for " + message);
        }
    }
}

