/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.io.Serializable;
import java.util.Arrays;
import java.util.zip.CRC32;

public final class IDBytes
implements Serializable {
    public final byte[] bytes = new byte[64];
    protected transient int cachedHash = 0;

    public IDBytes() {
    }

    public IDBytes(byte type) {
        this();
        this.bytes[63] = type;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof IDBytes) {
            IDBytes asIDBytes = (IDBytes)target;
            return Arrays.equals(this.bytes, asIDBytes.bytes);
        }
        return false;
    }

    public int hashCode() {
        int result = this.cachedHash;
        if (0 == result) {
            CRC32 crc = new CRC32();
            crc.update(this.bytes, 0, this.bytes.length);
            this.cachedHash = (int)crc.getValue();
            result = this.cachedHash = 0 == this.cachedHash ? 1 : this.cachedHash;
        }
        return result;
    }

    public String toString() {
        return this.getUniqueValue().toString();
    }

    private static char[] toHexDigits(byte theByte) {
        char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] result = new char[]{HEXDIGITS[theByte >>> 4 & 0xF], HEXDIGITS[theByte & 0xF]};
        return result;
    }

    public Object getUniqueValue() {
        char[] asHex;
        int lastIndex;
        StringBuilder encoded = new StringBuilder(144);
        for (lastIndex = 62; lastIndex > 0 && 0 == this.bytes[lastIndex]; --lastIndex) {
        }
        for (int eachByte = 0; eachByte <= lastIndex; ++eachByte) {
            asHex = IDBytes.toHexDigits(this.bytes[eachByte]);
            encoded.append(asHex);
        }
        for (int eachFlagByte = 63; eachFlagByte < 64; ++eachFlagByte) {
            asHex = IDBytes.toHexDigits(this.bytes[eachFlagByte]);
            encoded.append(asHex);
        }
        return encoded.toString();
    }

    public void longIntoBytes(int offset, long value) {
        if (offset < 0 || offset + 8 > 64) {
            throw new IndexOutOfBoundsException("Bad offset");
        }
        for (int eachByte = 0; eachByte < 8; ++eachByte) {
            this.bytes[eachByte + offset] = (byte)(value >> (int)((long)(7 - eachByte) * 8L));
        }
        this.cachedHash = 0;
    }

    public long bytesIntoLong(int offset) {
        if (offset < 0 || offset + 8 > 64) {
            throw new IndexOutOfBoundsException("Bad offset");
        }
        long result = 0L;
        for (int eachByte = 0; eachByte < 8; ++eachByte) {
            result |= (long)(this.bytes[eachByte + offset] & 0xFF) << (int)((long)(7 - eachByte) * 8L);
        }
        return result;
    }
}

