/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.binaryID.BinaryID;
import net.jxta.impl.id.binaryID.BinaryIDFactory;
import net.jxta.impl.id.binaryID.IDFormat;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroupID;

public final class PeerGroupBinaryID
extends PeerGroupID {
    private static final transient Logger LOG = Logger.getLogger(PeerGroupBinaryID.class.getName());
    protected String id;

    public PeerGroupBinaryID(PeerGroupID parent, byte[] data, boolean lengthIncluded) {
        this();
        String parentStr = IDFormat.childGroup(parent);
        this.id = parentStr != null ? BinaryIDFactory.newBinaryID((byte)97, data, lengthIncluded).getID() + "." + parentStr.replace('-', '.') : BinaryIDFactory.newBinaryID((byte)97, data, lengthIncluded).getID();
    }

    protected PeerGroupBinaryID(String id) {
        this.id = id;
    }

    public PeerGroupBinaryID(byte[] data, boolean lengthIncluded) {
        this();
        this.id = BinaryIDFactory.newBinaryID((byte)97, data, lengthIncluded).getID();
    }

    public PeerGroupBinaryID() {
    }

    public PeerGroupBinaryID(BinaryID id) {
        this.id = id.getID();
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        return target instanceof PeerGroupBinaryID && this.getUniqueValue().equals(((PeerGroupBinaryID)target).getUniqueValue());
    }

    public int hashCode() {
        return this.getUniqueValue().hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        if (null == this.id) {
            return ID.nullID.getUniqueValue();
        }
        return this.getIDFormat() + "-" + this.id;
    }

    public ID getPeerGroupID() {
        return IDFormat.translateToWellKnown(this);
    }

    public PeerGroupID getParentPeerGroupID() {
        PeerGroupID result = null;
        try {
            String idd;
            int parentStart;
            if (this.id == null) {
                result = (PeerGroupID)ID.nullID;
            }
            if ((parentStart = (idd = this.id).indexOf(46)) != -1) {
                idd = idd.substring(parentStart + 1);
            } else {
                result = null;
            }
            URI url = new URI("urn:jxta:" + idd.replace('.', '-'));
            PeerGroupID peerGroupID = (PeerGroupID)IDFactory.fromURI(url);
            result = (PeerGroupID)IDFormat.translateToWellKnown(peerGroupID);
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("cannot convert sub group. ID value = " + this.id);
            }
            result = null;
        }
        return result;
    }

    protected String getID() {
        return this.id;
    }
}

