/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.pipe.NonBlockingWireOutputPipe;
import net.jxta.impl.pipe.WireHeader;
import net.jxta.impl.pipe.WirePipe;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public class BlockingWireOutputPipe
implements OutputPipe {
    private static final Logger LOG = Logger.getLogger(NonBlockingWireOutputPipe.class.getName());
    private volatile boolean closed = false;
    private final PipeAdvertisement pAdv;
    private final PeerGroup group;
    private Messenger destMessenger = null;
    private EndpointAddress destination;
    private EndpointService endpoint = null;
    private RouteAdvertisement route = null;

    public BlockingWireOutputPipe(PeerGroup group, PipeAdvertisement pAdv, PeerID peerID) {
        this.pAdv = pAdv;
        this.group = group;
        this.endpoint = group.getEndpointService();
        this.destination = new EndpointAddress("jxta", peerID.getUniqueValue().toString(), "PipeService", pAdv.getID().toString());
        this.destMessenger = this.endpoint.getMessenger(this.destination);
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Created output pipe for " + this.getPipeID());
        }
    }

    public BlockingWireOutputPipe(PeerGroup group, PipeAdvertisement pAdv, PeerID peerID, RouteAdvertisement route) {
        this.route = route;
        this.pAdv = pAdv;
        this.group = group;
        this.endpoint = group.getEndpointService();
        this.destination = new EndpointAddress("jxta", peerID.getUniqueValue().toString(), "PipeService", pAdv.getID().toString());
        if (route != null) {
            this.destMessenger = this.endpoint.getDirectMessenger(this.destination, route, true);
        }
        if (this.destMessenger == null) {
            this.destMessenger = this.endpoint.getMessenger(this.destination);
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Created output pipe for " + this.getPipeID());
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closing queue for " + this.getPipeID());
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final String getType() {
        return this.pAdv.getType();
    }

    public final ID getPipeID() {
        return this.pAdv.getPipeID();
    }

    public final String getName() {
        return this.pAdv.getName();
    }

    public final PipeAdvertisement getAdvertisement() {
        return this.pAdv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMessenger() throws IOException {
        if (!(this.destMessenger instanceof TcpMessenger) && this.destMessenger != null && (this.destMessenger.getState() & 0x3FF) != 0) {
            return;
        }
        if (this.destMessenger != null && !this.destMessenger.isClosed()) {
            return;
        }
        BlockingWireOutputPipe blockingWireOutputPipe = this;
        synchronized (blockingWireOutputPipe) {
            if (this.route != null) {
                this.destMessenger = this.endpoint.getDirectMessenger(this.destination, this.route, true);
            }
            this.destMessenger = this.endpoint.getMessenger(this.destination);
            if (!(this.destMessenger instanceof TcpMessenger) && this.destMessenger == null || (this.destMessenger.getState() & 0x70000) != 0) {
                if (this.destMessenger != null) {
                    this.destMessenger.close();
                    this.destMessenger = null;
                }
                System.out.println(MessageFormat.format("destMessenger instanceof TcpMessenger :{0} destMessenger == null : {1} (destMessenger.getState() & Messenger.TERMINAL) : {2}", this.destMessenger instanceof TcpMessenger, this.destMessenger == null, this.destMessenger.getState() & 0x70000));
                throw new IOException("Unable to create a messenger to " + this.destination.toString());
            }
        }
    }

    public boolean send(Message message) throws IOException {
        block6: {
            if (this.closed) {
                throw new IOException("Pipe closed");
            }
            WireHeader header = new WireHeader();
            header.setPipeID(this.getPipeID());
            header.setSrcPeer(this.group.getPeerID());
            header.setTTL(1);
            header.setMsgId(WirePipe.createMsgId());
            XMLDocument asDoc = (XMLDocument)header.getDocument(MimeMediaType.XMLUTF8);
            TextDocumentMessageElement elem = new TextDocumentMessageElement("JxtaWireHeader", asDoc, null);
            Message msg = message.clone();
            msg.replaceMessageElement("jxta", elem);
            this.checkMessenger();
            try {
                if (this.destMessenger instanceof TcpMessenger) {
                    ((TcpMessenger)this.destMessenger).sendMessageDirect(msg, null, null, true);
                } else if (!this.destMessenger.sendMessage(msg, null, null)) {
                    throw new IOException("Pipe closed");
                }
            }
            catch (IOException io) {
                this.checkMessenger();
                if (this.destMessenger.sendMessage(msg, null, null)) break block6;
                throw new IOException("Pipe closed");
            }
        }
        return true;
    }
}

