/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.id.ID;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.pipe.PipeRegistrar;
import net.jxta.impl.protocol.PipeResolverMsg;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.resolver.InternalQueryHandler;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.PipeResolverMessage;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezVousStatus;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PipeResolver
implements Srdi.SrdiInterface,
InternalQueryHandler,
SrdiHandler,
PipeRegistrar {
    private static final transient Logger LOG = Logger.getLogger(PipeResolver.class.getName());
    private static final String PipeResolverName = "JxtaPipeResolver";
    private static final String srdiIndexerFileName = "pipeResolverSrdi";
    private static final long GcDelay = 60000L;
    static final int ANYQUERY = 0;
    private static int currentQueryID = 1;
    private PeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private ResolverService resolver = null;
    private DiscoveryService discovery = null;
    private MembershipService membership = null;
    private Srdi srdi = null;
    private Thread srdiThread = null;
    private SrdiIndex srdiIndex = null;
    private RendezVousService rendezvous = null;
    private final Map<ID, InputPipe> localInputPipes = new HashMap<ID, InputPipe>();
    private final Map<ID, Map<Integer, Listener>> outputpipeListeners = new HashMap<ID, Map<Integer, Listener>>();
    CurrentCredential currentCredential;
    final CredentialListener membershipCredListener = new CredentialListener();

    static synchronized int getNextQueryID() {
        if (++currentQueryID == Integer.MAX_VALUE) {
            currentQueryID = 1;
        }
        return currentQueryID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PipeResolver(PeerGroup peerGroup) {
        this.myGroup = peerGroup;
        this.resolver = this.myGroup.getResolverService();
        this.membership = this.myGroup.getMembershipService();
        this.rendezvous = this.myGroup.getRendezVousService();
        this.endpoint = this.myGroup.getEndpointService();
        this.resolver.registerHandler(PipeResolverName, this);
        this.srdiIndex = new SrdiIndex(this.myGroup, srdiIndexerFileName, 60000L);
        this.srdi = new Srdi(this.myGroup, PipeResolverName, this, this.srdiIndex, 120000L, 31536000000L);
        this.srdiThread = new Thread(this.myGroup.getHomeThreadGroup(), this.srdi, "Pipe Resolver Srdi Thread");
        this.srdiThread.setDaemon(true);
        this.srdiThread.start();
        this.resolver.registerSrdiHandler(PipeResolverName, this);
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            block6: {
                this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
                try {
                    this.currentCredential = null;
                    Credential credential = this.membership.getDefaultCredential();
                    if (null != credential) {
                        XMLDocument credentialDoc = (XMLDocument)credential.getDocument(MimeMediaType.XMLUTF8);
                        this.currentCredential = new CurrentCredential(credential, credentialDoc);
                    }
                }
                catch (Exception all) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                    LOG.log(Level.WARNING, "could not get default credential", all);
                }
            }
        }
    }

    private boolean isRendezvous() {
        RendezVousStatus mode;
        if (this.rendezvous == null) {
            this.rendezvous = this.myGroup.getRendezVousService();
        }
        return (mode = this.rendezvous.getRendezVousStatus()) == RendezVousStatus.RENDEZVOUS || mode == RendezVousStatus.AUTO_RENDEZVOUS;
    }

    @Override
    public int processQuery(ResolverQueryMsg query) {
        return this.processQuery(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processQuery(ResolverQueryMsg query, EndpointAddress srcAddr) {
        InputPipe ip;
        boolean queryForMe;
        PipeResolverMsg pipeQuery;
        String queryFrom = null != srcAddr ? ("jxta".equals(srcAddr.getProtocolName()) ? "urn:jxta:" + srcAddr.getProtocolAddress() : query.getSrcPeer().toString()) : query.getSrcPeer().toString();
        String responseDest = query.getSrcPeer().toString();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting for :" + query.getQueryId() + " from " + srcAddr);
        }
        StringReader queryReader = new StringReader(query.getQuery());
        StructuredTextDocument doc = null;
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, queryReader);
        }
        catch (IOException e) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "discarding malformed request ", e);
            }
            int n = 0;
            return n;
        }
        finally {
            try {
                ((Reader)queryReader).close();
            }
            catch (IOException ignored) {}
            queryReader = null;
        }
        try {
            pipeQuery = new PipeResolverMsg(doc);
        }
        catch (IllegalArgumentException badDoc) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "discarding malformed request ", badDoc);
            }
            int ignored = 0;
            return ignored;
        }
        finally {
            doc = null;
        }
        if (!pipeQuery.getMsgType().equals((Object)PipeResolverMessage.MessageType.QUERY)) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("expected query - discarding.");
            }
            return 0;
        }
        Set<ID> destPeers = pipeQuery.getPeerIDs();
        boolean directedQuery = !destPeers.isEmpty();
        boolean bl = queryForMe = !directedQuery;
        if (directedQuery) {
            for (ID destPeer : destPeers) {
                ID aPeer = destPeer;
                if (!aPeer.equals(this.myGroup.getPeerID())) continue;
                queryForMe = true;
                break;
            }
            if (!queryForMe) {
                if (query.getSrcPeer().toString().equals(queryFrom)) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("discarding query. Query not for us.");
                    }
                    return 0;
                }
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("responding to 'misdirected' forwarded query.");
                }
                responseDest = queryFrom;
            }
        }
        PeerID peerID = null;
        if (queryForMe && (ip = this.findLocal((PipeID)pipeQuery.getPipeID())) != null && ip.getType().equals(pipeQuery.getPipeType())) {
            peerID = this.myGroup.getPeerID();
        }
        if (null == peerID && !directedQuery) {
            if (this.myGroup.isRendezvous()) {
                List<PeerID> results = this.srdiIndex.query(pipeQuery.getPipeType(), "Id", pipeQuery.getPipeID().toString(), 20);
                if (!results.isEmpty()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("forwarding query to " + results.size() + " peers");
                    }
                    this.srdi.forwardQuery(results, query);
                    return 0;
                }
                return -1;
            }
            if (query.getSrcPeer().toString().equals(queryFrom)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("discarding query.");
                }
                return 0;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("responding to query forwarded for 'misdirected' query.");
            }
            responseDest = queryFrom;
        }
        PipeResolverMsg pipeResp = new PipeResolverMsg();
        pipeResp.setMsgType(PipeResolverMessage.MessageType.ANSWER);
        pipeResp.setPipeID(pipeQuery.getPipeID());
        pipeResp.setPipeType(pipeQuery.getPipeType());
        if (null == peerID) {
            pipeResp.addPeerID(this.myGroup.getPeerID());
            pipeResp.setFound(false);
        } else {
            pipeResp.addPeerID(peerID);
            pipeResp.setFound(true);
            pipeResp.setInputPeerAdv(this.myGroup.getPeerAdvertisement());
        }
        ResolverResponseMsg res = query.makeResponse();
        CurrentCredential current = this.currentCredential;
        if (null != current) {
            res.setCredential(current.credentialDoc);
        }
        res.setResponse(((PipeResolverMessage)pipeResp).getDocument(MimeMediaType.XMLUTF8).toString());
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending answer for query '" + query.getQueryId() + "' to : " + responseDest);
        }
        this.resolver.sendResponse(responseDest, res);
        return 0;
    }

    @Override
    public void processResponse(ResolverResponseMsg response) {
        this.processResponse(response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(ResolverResponseMsg response, EndpointAddress srcAddr) {
        PipeResolverMsg pipeResp;
        block36: {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("got a response for '" + response.getQueryId() + "'");
            }
            StringReader resp = new StringReader(response.getResponse());
            StructuredTextDocument doc = null;
            try {
                doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, resp);
            }
            catch (Throwable e) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "malformed response - discard", e);
                }
                return;
            }
            finally {
                try {
                    ((Reader)resp).close();
                }
                catch (IOException ignored) {}
                resp = null;
            }
            try {
                pipeResp = new PipeResolverMsg(doc);
            }
            catch (Throwable caught) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "malformed response - discarding.", caught);
                }
                return;
            }
            finally {
                doc = null;
            }
            if (!pipeResp.getMsgType().equals((Object)PipeResolverMessage.MessageType.ANSWER)) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("expected response - discarding.");
                }
                return;
            }
            PeerAdvertisement padv = pipeResp.getInputPeerAdv();
            if (null != padv && !this.myGroup.getPeerID().equals(padv.getPeerID())) {
                try {
                    if (null == this.discovery) {
                        this.discovery = this.myGroup.getDiscoveryService();
                    }
                    if (null != this.discovery) {
                        this.discovery.publish(padv, 0x6DDD00L, 0x6DDD00L);
                    }
                }
                catch (IOException ignored) {
                    if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block36;
                    LOG.warning("could not publish peer adv");
                }
            }
        }
        String ipId = pipeResp.getPipeID().toString();
        Set<ID> peerRsps = pipeResp.getPeerIDs();
        for (ID peerRsp : peerRsps) {
            PeerID peer = (PeerID)peerRsp;
            if (!pipeResp.isFound()) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("NACK for pipe '" + ipId + "' from peer " + peer);
                }
                this.srdiIndex.add(pipeResp.getPipeType(), "Id", ipId, peer, 0L);
            } else {
                long exp = this.getEntryExp(pipeResp.getPipeType(), "Id", ipId, peer);
                if (600000L > exp) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Using Expiration 600000 which is > " + exp);
                    }
                    this.srdiIndex.add(pipeResp.getPipeType(), "Id", ipId, peer, 600000L);
                } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("DB Expiration " + exp + " > " + 600000L + " overriding attempt to decrease lifetime");
                }
            }
            this.callListener(response.getQueryId(), pipeResp.getPipeID(), pipeResp.getPipeType(), peer, !pipeResp.isFound());
        }
    }

    private long getEntryExp(String pkey, String skey, String value, PeerID peerid) {
        List<SrdiIndex.Entry> list = this.srdiIndex.getRecord(pkey, skey, value);
        for (SrdiIndex.Entry entry : list) {
            if (!entry.peerid.equals(peerid)) continue;
            return TimeUtils.toRelativeTimeMillis(entry.expiration);
        }
        return -1L;
    }

    @Override
    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        if (!this.isRendezvous()) {
            return true;
        }
        if (message == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("no SRDI message");
            }
            return false;
        }
        if (message.getPayload() == null) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("empty SRDI message");
            }
            return false;
        }
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(message.getPayload()));
            srdiMsg = new SrdiMessageImpl(asDoc);
        }
        catch (Throwable e) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Invalid SRDI message", e);
            }
            return false;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received an SRDI messsage with " + srdiMsg.getEntries().size() + " entries from " + srdiMsg.getPeerID());
        }
        Iterator<SrdiMessage.Entry> i$ = srdiMsg.getEntries().iterator();
        while (i$.hasNext()) {
            SrdiMessage.Entry o;
            SrdiMessage.Entry entry = o = i$.next();
            this.srdiIndex.add(srdiMsg.getPrimaryKey(), entry.key, entry.value, srdiMsg.getPeerID(), entry.expiration);
        }
        if (!"JxtaPropagate".equals(srdiMsg.getPrimaryKey())) {
            this.srdi.replicateEntries(srdiMsg);
        }
        return true;
    }

    @Override
    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
    }

    @Override
    public void pushEntries(boolean all) {
        this.pushSrdi((PeerID)null, all);
    }

    void stop() {
        this.resolver.unregisterHandler(PipeResolverName);
        this.resolver.unregisterSrdiHandler(PipeResolverName);
        this.srdiIndex.stop();
        this.srdiIndex = null;
        if (this.srdiThread != null) {
            this.srdi.stop();
        }
        this.srdiThread = null;
        this.srdi = null;
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.currentCredential = null;
        this.myGroup = null;
        this.resolver = null;
        this.discovery = null;
        this.membership = null;
        this.outputpipeListeners.clear();
        ArrayList<InputPipe> openLocalPipes = new ArrayList<InputPipe>(this.localInputPipes.values());
        for (InputPipe aPipe : openLocalPipes) {
            try {
                aPipe.close();
            }
            catch (Exception failed) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Failure closing " + aPipe);
            }
        }
        this.localInputPipes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(InputPipe ip) {
        PipeID pipeID = (PipeID)ip.getPipeID();
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            if (this.localInputPipes.containsKey(pipeID)) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Existing registered InputPipe for " + pipeID);
                }
                return false;
            }
            boolean registered = this.endpoint.addIncomingMessageListener((EndpointListener)((Object)ip), "PipeService", pipeID.toString());
            if (!registered) {
                if (Logging.SHOW_SEVERE && LOG.isLoggable(Level.SEVERE)) {
                    LOG.severe("Existing registered Endpoint Listener for " + pipeID);
                }
                return false;
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Registering local InputPipe for " + pipeID);
            }
            this.localInputPipes.put(pipeID, ip);
        }
        this.pushSrdi(ip, true);
        this.callListener(0, pipeID, ip.getType(), this.myGroup.getPeerID(), false);
        return true;
    }

    public InputPipe findLocal(PipeID pipeID) {
        InputPipe ip;
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Find local InputPipe for " + pipeID);
        }
        if (null != (ip = this.localInputPipes.get(pipeID)) && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("found local InputPipe for " + pipeID);
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forget(InputPipe pipe) {
        EndpointListener removed;
        InputPipe ip;
        PipeID pipeID = (PipeID)pipe.getPipeID();
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unregistering local InputPipe for " + pipeID);
        }
        this.pushSrdi(pipe, false);
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            ip = this.localInputPipes.remove(pipeID);
        }
        if (pipe != ip && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Pipe removed was not the same as the pipe to be removed!");
        }
        if (null != ip && (null == (removed = this.endpoint.removeIncomingMessageListener("PipeService", pipeID.toString())) || pipe != removed) && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("removeIncomingMessageListener() did not remove correct pipe!");
        }
        return ip != null;
    }

    synchronized boolean addListener(ID pipeID, Listener listener, int queryID) {
        boolean alreadyThere;
        Map<Integer, Listener> perpipelisteners = this.outputpipeListeners.get(pipeID);
        if (null == perpipelisteners) {
            perpipelisteners = new HashMap<Integer, Listener>();
            this.outputpipeListeners.put(pipeID, perpipelisteners);
        }
        if (!(alreadyThere = perpipelisteners.containsKey(queryID))) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("adding listener for " + pipeID + " / " + queryID);
            }
            perpipelisteners.put(queryID, listener);
        }
        return alreadyThere;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callListener(int qid, ID pipeID, String type, PeerID peer, boolean NAK) {
        Event newevent = new Event(this, peer, pipeID, type, qid);
        boolean handled = false;
        while (!handled) {
            block10: {
                Listener pipeListener;
                PipeResolver pipeResolver = this;
                synchronized (pipeResolver) {
                    Map<Integer, Listener> perpipelisteners = this.outputpipeListeners.get(pipeID);
                    if (null == perpipelisteners) {
                        if (0 != qid && Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                            LOG.fine("No listener for pipe " + pipeID);
                        }
                        break;
                    }
                    pipeListener = perpipelisteners.get(qid);
                }
                if (null != pipeListener) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Calling Pipe resolver listener " + (NAK ? "NAK " : "") + "for " + pipeID);
                    }
                    try {
                        handled = NAK ? pipeListener.pipeNAKEvent(newevent) : pipeListener.pipeResolveEvent(newevent);
                    }
                    catch (Throwable ignored) {
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block10;
                        LOG.log(Level.WARNING, "Uncaught Throwable in listener for: " + pipeID + "(" + pipeListener.getClass().getName() + ")", ignored);
                    }
                }
            }
            if (0 == qid) break;
            qid = 0;
        }
    }

    synchronized Listener removeListener(ID pipeID, int queryID) {
        Map<Integer, Listener> perpipelisteners = this.outputpipeListeners.get(pipeID);
        if (null == perpipelisteners) {
            return null;
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("removing listener for " + pipeID + " / " + queryID);
        }
        Listener removedListener = perpipelisteners.remove(queryID);
        if (perpipelisteners.isEmpty()) {
            this.outputpipeListeners.remove(pipeID);
        }
        return removedListener;
    }

    int sendPipeQuery(PipeAdvertisement adv, Set<? extends ID> acceptablePeers, int queryID) {
        if (0 == queryID) {
            queryID = PipeResolver.getNextQueryID();
        }
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine((acceptablePeers.isEmpty() ? "Undirected" : "Directed") + " query (" + queryID + ") for " + adv.getPipeID());
        }
        List<ID> targetPeers = new ArrayList<ID>(acceptablePeers);
        List<PeerID> knownLocations = this.srdiIndex.query(adv.getType(), "Id", adv.getPipeID().toString(), 100);
        if (!knownLocations.isEmpty()) {
            if (!acceptablePeers.isEmpty()) {
                knownLocations.retainAll(acceptablePeers);
            }
            if (!knownLocations.isEmpty()) {
                targetPeers = knownLocations;
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Using SRDI cache results for directed query (" + queryID + ") for " + adv.getPipeID());
                }
            }
        }
        PipeResolverMsg pipeQry = new PipeResolverMsg();
        pipeQry.setMsgType(PipeResolverMessage.MessageType.QUERY);
        pipeQry.setPipeID(adv.getPipeID());
        pipeQry.setPipeType(adv.getType());
        for (ID targetPeer : targetPeers) {
            pipeQry.addPeerID((PeerID)targetPeer);
        }
        StructuredTextDocument asDoc = (StructuredTextDocument)((PipeResolverMessage)pipeQry).getDocument(MimeMediaType.XMLUTF8);
        ResolverQuery query = new ResolverQuery();
        query.setHandlerName(PipeResolverName);
        query.setQueryId(queryID);
        query.setSrcPeer(this.myGroup.getPeerID());
        query.setQuery(asDoc.toString());
        CurrentCredential current = this.currentCredential;
        if (null != current) {
            query.setCredential(current.credentialDoc);
        }
        if (targetPeers.isEmpty()) {
            PeerID peer;
            if (this.myGroup.isRendezvous() && null != (peer = this.srdi.getReplicaPeer(pipeQry.getPipeType() + "Id" + pipeQry.getPipeID().toString()))) {
                this.srdi.forwardQuery(peer, (ResolverQueryMsg)query);
                return queryID;
            }
            this.resolver.sendQuery(null, query);
        } else {
            for (ID targetPeer : targetPeers) {
                this.resolver.sendQuery(targetPeer.toString(), query);
            }
        }
        return queryID;
    }

    SrdiIndex getSrdiIndex() {
        return this.srdiIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSrdi(PeerID peer, boolean all) {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Pushing " + (all ? "all" : "deltas") + " SRDI to " + peer);
        }
        HashMap<String, ArrayList<SrdiMessage.Entry>> types = new HashMap<String, ArrayList<SrdiMessage.Entry>>();
        PipeResolver pipeResolver = this;
        synchronized (pipeResolver) {
            for (InputPipe ip : this.localInputPipes.values()) {
                SrdiMessage.Entry entry = new SrdiMessage.Entry("Id", ip.getPipeID().toString(), Long.MAX_VALUE);
                String type = ip.getType();
                ArrayList<SrdiMessage.Entry> entries = (ArrayList<SrdiMessage.Entry>)types.get(type);
                if (null == entries) {
                    entries = new ArrayList<SrdiMessage.Entry>();
                    types.put(type, entries);
                }
                entries.add(entry);
            }
        }
        for (String type : types.keySet()) {
            List entries = (List)types.get(type);
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending a Pipe SRDI messsage in " + this.myGroup.getPeerGroupID() + " of " + entries.size() + " entries of type " + type);
            }
            SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.myGroup.getPeerID(), 1, type, (List<SrdiMessage.Entry>)entries);
            if (null == peer) {
                this.srdi.pushSrdi(null, srdiMsg);
                continue;
            }
            this.srdi.pushSrdi(peer, srdiMsg);
        }
    }

    private void pushSrdi(InputPipe ip, boolean adding) {
        block6: {
            this.srdiIndex.add(ip.getType(), "Id", ip.getPipeID().toString(), this.myGroup.getPeerID(), adding ? Long.MAX_VALUE : 0L);
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.myGroup.getPeerID(), 1, ip.getType(), "Id", ip.getPipeID().toString(), adding ? Long.MAX_VALUE : 0L);
                if (this.myGroup.isRendezvous()) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Replicating a" + (adding ? "n add" : " remove") + " Pipe SRDI entry for pipe [" + ip.getPipeID() + "] of type " + ip.getType());
                    }
                    this.srdi.replicateEntries(srdiMsg);
                } else {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Sending a" + (adding ? "n add" : " remove") + " Pipe SRDI messsage for pipe [" + ip.getPipeID() + "] of type " + ip.getType());
                    }
                    this.srdi.pushSrdi(null, srdiMsg);
                }
            }
            catch (Throwable e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block6;
                LOG.log(Level.WARNING, "Uncaught throwable pushing SRDI entries", e);
            }
        }
    }

    static interface Listener
    extends EventListener {
        public boolean pipeResolveEvent(Event var1);

        public boolean pipeNAKEvent(Event var1);
    }

    static class Event
    extends EventObject {
        private final ID peerid;
        private final ID pipeid;
        private final String type;
        private final int queryID;

        public Event(PipeResolver source, ID peerid, ID pipeid, String type, int queryid) {
            super(source);
            this.peerid = peerid;
            this.pipeid = pipeid;
            this.type = type;
            this.queryID = queryid;
        }

        public ID getPeerID() {
            return this.peerid;
        }

        public ID getPipeID() {
            return this.pipeid;
        }

        public String getType() {
            return this.type;
        }

        public int getQueryID() {
            return this.queryID;
        }
    }

    private class CredentialListener
    implements PropertyChangeListener {
        CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("New default credential event");
                }
                PipeResolver pipeResolver = PipeResolver.this;
                synchronized (pipeResolver) {
                    Credential cred = (Credential)evt.getNewValue();
                    if (null != cred) {
                        try {
                            XMLDocument credentialDoc = (XMLDocument)cred.getDocument(MimeMediaType.XMLUTF8);
                            PipeResolver.this.currentCredential = new CurrentCredential(cred, credentialDoc);
                        }
                        catch (Exception all) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Could not generate credential document", all);
                            }
                            PipeResolver.this.currentCredential = null;
                        }
                    } else {
                        PipeResolver.this.currentCredential = null;
                    }
                }
            }
        }
    }

    static final class CurrentCredential {
        final Credential credential;
        final XMLDocument credentialDoc;

        CurrentCredential(Credential credential, XMLDocument credentialDoc) {
            this.credential = credential;
            this.credentialDoc = credentialDoc;
        }
    }
}

