/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.protocol.DiscoveryQueryMsg;
import net.jxta.protocol.PeerAdvertisement;

public class DiscoveryQuery
extends DiscoveryQueryMsg {
    private static final Logger LOG = Logger.getLogger(DiscoveryQuery.class.getName());
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String thresholdTag = "Threshold";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";

    public DiscoveryQuery() {
    }

    public DiscoveryQuery(Element doc) {
        this.initialize(doc);
    }

    protected boolean handleElement(XMLElement elem) {
        String value = elem.getTextValue();
        if (null == value) {
            return false;
        }
        if (0 == (value = value.trim()).length()) {
            return false;
        }
        if (elem.getName().equals(typeTag)) {
            this.setDiscoveryType(Integer.parseInt(value));
            return true;
        }
        if (elem.getName().equals(thresholdTag)) {
            this.setThreshold(Integer.parseInt(value));
            return true;
        }
        if (elem.getName().equals(peerAdvTag)) {
            try {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(value));
                PeerAdvertisement adv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                this.setPeerAdvertisement(adv);
                return true;
            }
            catch (IOException failed) {
                IllegalArgumentException failure = new IllegalArgumentException("Bad Peer Advertisement");
                failure.initCause(failed);
                throw failure;
            }
        }
        if (elem.getName().equals(queryAttrTag)) {
            this.setAttr(value);
            return true;
        }
        if (elem.getName().equals(queryValueTag)) {
            this.setValue(value);
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        if (!doc.getName().equals(DiscoveryQuery.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.setDiscoveryType(-1);
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element : " + elem.toString());
        }
        if (0 != this.getDiscoveryType() && 1 != this.getDiscoveryType() && 2 != this.getDiscoveryType()) {
            throw new IllegalArgumentException("Type is not one of the required values.");
        }
        if (this.getThreshold() < 0) {
            throw new IllegalArgumentException("Threshold must not be less than zero.");
        }
        if (this.getDiscoveryType() != 0 && this.getThreshold() == 0) {
            throw new IllegalArgumentException("Threshold may not be zero.");
        }
        if (null == this.getAttr() && null != this.getValue()) {
            throw new IllegalArgumentException("Value specified without attribute.");
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        String attr;
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryQuery.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            XMLDocument xmlDoc = (XMLDocument)adv;
            xmlDoc.addAttribute("xmlns:jxta", "http://jxta.org");
            xmlDoc.addAttribute("xml:space", "preserve");
        }
        Object e = adv.createElement(typeTag, Integer.toString(this.getDiscoveryType()));
        adv.appendChild(e);
        int threshold = this.getThreshold();
        if (threshold < 0) {
            throw new IllegalStateException("threshold must be >= 0");
        }
        e = adv.createElement(thresholdTag, Integer.toString(threshold));
        adv.appendChild(e);
        PeerAdvertisement peerAdv = this.getPeerAdvertisement();
        if (peerAdv != null) {
            e = adv.createElement(peerAdvTag, peerAdv.toString());
            adv.appendChild(e);
        }
        if ((attr = this.getAttr()) != null && attr.length() > 0) {
            e = adv.createElement(queryAttrTag, attr.trim());
            adv.appendChild(e);
            String value = this.getValue();
            if (value != null && value.length() > 0) {
                e = adv.createElement(queryValueTag, value.trim());
                adv.appendChild(e);
            } else if (threshold < 0) {
                throw new IllegalStateException("Attribute specified, but no value was specified.");
            }
        }
        return adv;
    }

    @Deprecated
    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

