/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.logging.Logging;

public final class RdvConfigAdv
extends ExtendableAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(RdvConfigAdv.class.getName());
    private static final String advType = "jxta:RdvConfig";
    private static final String RDV_CONFIG_ATTR = "config";
    private static final String MAX_TTL_ATTR = "maxTTL";
    private static final String AUTO_RDV_INTERVAL_ATTR = "autoRendezvousInterval";
    private static final String PROBE_RELAYS_ATTR = "probeRelays";
    private static final String MAX_CLIENTS_ATTR = "maxClients";
    private static final String LEASE_DURATION_ATTR = "leaseDuration";
    private static final String LEASE_MARGIN_ATTR = "leaseMargin";
    private static final String MIN_HAPPY_PEERVIEW_ATTR = "minHappyPeerView";
    private static final String SEEDS_RDV_ELEMENT = "seeds";
    private static final String USE_ONLY_SEEDS_ATTR = "useOnlySeeds";
    private static final String CONNECT_DELAY_ATTR = "connectDelay";
    private static final String SEED_RDV_ADDR_ELEMENT = "addr";
    private static final String SEED_RDV_ADDR_SEEDING_ATTR = "seeding";
    private static final String ACL_URI = "acl";
    private static final String PROPAGATE_RESPOND_ATTR = "propagateRespondProbability";
    private static final String[] INDEXFIELDS = new String[0];
    private RendezVousConfiguration configuration = RendezVousConfiguration.EDGE;
    private long autoRendezvousCheckInterval = 0L;
    private boolean probeRelays = true;
    private int maxClients = -1;
    private int maximumTTL = -1;
    private long leaseDuration = 0L;
    private long leaseMargin = 0L;
    private int minHappyPeerView = -1;
    private boolean useOnlySeeds = false;
    private long seedRendezvousConnectDelay = 0L;
    private final Set<URI> seedRendezvous = new HashSet<URI>();
    private final Set<URI> seedingURIs = new HashSet<URI>();
    private URI aclURI = null;

    public static String getAdvertisementType() {
        return advType;
    }

    private RdvConfigAdv() {
    }

    private RdvConfigAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RdvConfigAdv.getAdvertisementType()) && !RdvConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration<Attribute> eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute aRdvAttr = eachAttr.nextElement();
            if (super.handleAttribute(aRdvAttr)) continue;
            if (RDV_CONFIG_ATTR.equals(aRdvAttr.getName())) {
                String config = aRdvAttr.getValue().trim();
                if ("adhoc".equals(config)) {
                    this.configuration = RendezVousConfiguration.AD_HOC;
                    continue;
                }
                if ("client".equals(config)) {
                    this.configuration = RendezVousConfiguration.EDGE;
                    continue;
                }
                if ("rendezvous".equals(config)) {
                    this.configuration = RendezVousConfiguration.RENDEZVOUS;
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized Rendezvous configuration :" + config);
            }
            if (MAX_TTL_ATTR.equals(aRdvAttr.getName())) {
                this.maximumTTL = Integer.parseInt(aRdvAttr.getValue().trim());
                continue;
            }
            if (AUTO_RDV_INTERVAL_ATTR.equals(aRdvAttr.getName())) {
                this.autoRendezvousCheckInterval = Long.parseLong(aRdvAttr.getValue().trim());
                continue;
            }
            if (PROBE_RELAYS_ATTR.equals(aRdvAttr.getName())) {
                this.probeRelays = Boolean.valueOf(aRdvAttr.getValue().trim());
                continue;
            }
            if (MAX_CLIENTS_ATTR.equals(aRdvAttr.getName())) {
                this.maxClients = Integer.parseInt(aRdvAttr.getValue().trim());
                continue;
            }
            if (LEASE_DURATION_ATTR.equals(aRdvAttr.getName())) {
                this.leaseDuration = Long.parseLong(aRdvAttr.getValue().trim());
                continue;
            }
            if (LEASE_MARGIN_ATTR.equals(aRdvAttr.getName())) {
                this.leaseMargin = Long.parseLong(aRdvAttr.getValue().trim());
                continue;
            }
            if (MIN_HAPPY_PEERVIEW_ATTR.equals(aRdvAttr.getName())) {
                this.minHappyPeerView = Integer.parseInt(aRdvAttr.getValue().trim());
                continue;
            }
            if (PROPAGATE_RESPOND_ATTR.equals(aRdvAttr.getName())) continue;
            if ("Flags".equals(aRdvAttr.getName())) {
                boolean onlySeeds = aRdvAttr.getValue().indexOf("UseOnlySeeds") != -1;
                this.setUseOnlySeeds(onlySeeds);
                continue;
            }
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Attribute: " + aRdvAttr.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Element: " + elem.toString());
        }
        if (this.maximumTTL != -1 && this.maximumTTL < 0) {
            throw new IllegalArgumentException("Maximum TTL must be >= 0");
        }
        if (this.autoRendezvousCheckInterval < 0L) {
            throw new IllegalArgumentException("Auto Rendezvous Check Interval must be >= 0");
        }
        if (this.seedRendezvousConnectDelay < 0L) {
            throw new IllegalArgumentException("Seed Rendezvous Connect Delay must be >= 0");
        }
        if (-1 != this.minHappyPeerView && this.minHappyPeerView <= 0) {
            throw new IllegalArgumentException("Min Happy Peer View must be > 0");
        }
        if (this.seedingURIs.isEmpty() && this.seedRendezvous.isEmpty() && this.useOnlySeeds && this.configuration == RendezVousConfiguration.EDGE) {
            throw new IllegalArgumentException("Must specify rendezvous if 'useOnlySeeds' is enabled and configured as client");
        }
    }

    public String getAdvType() {
        return RdvConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return RdvConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        return ID.nullID;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (SEEDS_RDV_ELEMENT.equals(elem.getName())) {
            Enumeration eachSeedElem = elem.getChildren();
            while (eachSeedElem.hasMoreElements()) {
                XMLElement aSeedElem = (XMLElement)eachSeedElem.nextElement();
                if (SEED_RDV_ADDR_ELEMENT.equals(aSeedElem.getName())) {
                    String endpAddrString = aSeedElem.getTextValue();
                    if (null == endpAddrString) continue;
                    URI endpAddr = URI.create(endpAddrString.trim());
                    Attribute seedingAttr = aSeedElem.getAttribute(SEED_RDV_ADDR_SEEDING_ATTR);
                    if (null != seedingAttr && Boolean.valueOf(seedingAttr.getValue().trim()).booleanValue()) {
                        this.seedingURIs.add(endpAddr);
                        continue;
                    }
                    this.seedRendezvous.add(endpAddr);
                    continue;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Element: " + aSeedElem.getName());
            }
            Enumeration<Attribute> eachAttr = elem.getAttributes();
            while (eachAttr.hasMoreElements()) {
                Attribute aSeedAttr = eachAttr.nextElement();
                if (USE_ONLY_SEEDS_ATTR.equals(aSeedAttr.getName())) {
                    this.useOnlySeeds = Boolean.valueOf(aSeedAttr.getValue().trim());
                    continue;
                }
                if (CONNECT_DELAY_ATTR.equals(aSeedAttr.getName())) {
                    this.seedRendezvousConnectDelay = Long.parseLong(aSeedAttr.getValue().trim());
                    continue;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Attribute: " + aSeedAttr.getName());
            }
            return true;
        }
        if (ACL_URI.equals(elem.getName())) {
            String addrElement = elem.getTextValue();
            if (null != addrElement) {
                this.aclURI = URI.create(addrElement.trim());
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (!(adv instanceof Attributable)) {
            throw new IllegalStateException("Only Attributable documents are supported.");
        }
        Attributable attrDoc = (Attributable)((Object)adv);
        if (RendezVousConfiguration.AD_HOC == this.configuration) {
            attrDoc.addAttribute(RDV_CONFIG_ATTR, "adhoc");
        } else if (RendezVousConfiguration.EDGE == this.configuration) {
            attrDoc.addAttribute(RDV_CONFIG_ATTR, "client");
        } else if (RendezVousConfiguration.RENDEZVOUS == this.configuration) {
            attrDoc.addAttribute(RDV_CONFIG_ATTR, "rendezvous");
        }
        if (this.maximumTTL != -1) {
            if (this.maximumTTL < 0) {
                throw new IllegalStateException("Maximum TTL must be >= 0");
            }
            attrDoc.addAttribute(MAX_TTL_ATTR, Integer.toString(this.maximumTTL));
        }
        if (this.seedingURIs.isEmpty() && this.seedRendezvous.isEmpty() && this.useOnlySeeds && this.configuration == RendezVousConfiguration.EDGE) {
            throw new IllegalStateException("Must specify rendezvous if 'useOnlySeeds' is enabled and configured as client");
        }
        if (0L != this.autoRendezvousCheckInterval) {
            if (this.autoRendezvousCheckInterval < 0L) {
                throw new IllegalStateException("Auto Rendezvous Check Interval must be >= 0");
            }
            attrDoc.addAttribute(AUTO_RDV_INTERVAL_ATTR, Long.toString(this.autoRendezvousCheckInterval));
        }
        if (!this.probeRelays) {
            attrDoc.addAttribute(PROBE_RELAYS_ATTR, Boolean.toString(this.probeRelays));
        }
        if (-1 != this.maxClients) {
            if (this.maxClients < 0) {
                throw new IllegalStateException("Max Clients must be >= 0");
            }
            attrDoc.addAttribute(MAX_CLIENTS_ATTR, Integer.toString(this.maxClients));
        }
        if (0L != this.leaseDuration) {
            if (this.leaseDuration < 0L) {
                throw new IllegalStateException("Lease Duration must be >= 0");
            }
            attrDoc.addAttribute(LEASE_DURATION_ATTR, Long.toString(this.leaseDuration));
        }
        if (0L != this.leaseMargin) {
            if (this.leaseMargin < 0L) {
                throw new IllegalStateException("Lease Margin must be >= 0");
            }
            attrDoc.addAttribute(LEASE_MARGIN_ATTR, Long.toString(this.leaseMargin));
        }
        if (-1 != this.minHappyPeerView) {
            if (this.minHappyPeerView < 0) {
                throw new IllegalStateException("Min Happy Peer View must be > 0");
            }
            attrDoc.addAttribute(MIN_HAPPY_PEERVIEW_ATTR, Integer.toString(this.minHappyPeerView));
        }
        if (!this.seedRendezvous.isEmpty() || !this.seedingURIs.isEmpty()) {
            Object aSeed;
            Object seedsElem = adv.createElement(SEEDS_RDV_ELEMENT);
            adv.appendChild(seedsElem);
            Attributable attrSeeds = (Attributable)seedsElem;
            if (this.useOnlySeeds) {
                attrSeeds.addAttribute(USE_ONLY_SEEDS_ATTR, Boolean.toString(this.useOnlySeeds));
            }
            if (0L != this.seedRendezvousConnectDelay) {
                if (this.seedRendezvousConnectDelay < 0L) {
                    throw new IllegalStateException("Seed Rendezvous Connect Delay must be >= 0");
                }
                attrSeeds.addAttribute(CONNECT_DELAY_ATTR, Long.toString(this.seedRendezvousConnectDelay));
            }
            for (URI seedRendezvou : this.seedRendezvous) {
                aSeed = adv.createElement(SEED_RDV_ADDR_ELEMENT, seedRendezvou.toString());
                seedsElem.appendChild(aSeed);
            }
            for (URI seedingURI : this.seedingURIs) {
                aSeed = adv.createElement(SEED_RDV_ADDR_ELEMENT, seedingURI.toString());
                seedsElem.appendChild(aSeed);
                Attributable seedAttr = (Attributable)aSeed;
                seedAttr.addAttribute(SEED_RDV_ADDR_SEEDING_ATTR, Boolean.TRUE.toString());
            }
            if (this.aclURI != null) {
                Object acl = adv.createElement(ACL_URI, this.aclURI.toString());
                adv.appendChild(acl);
            }
        }
        return adv;
    }

    public String[] getIndexFields() {
        return INDEXFIELDS;
    }

    public RendezVousConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RendezVousConfiguration newstate) {
        this.configuration = newstate;
    }

    public long getAutoRendezvousCheckInterval() {
        return this.autoRendezvousCheckInterval;
    }

    public void setAutoRendezvousCheckInterval(long newvalue) {
        if (newvalue < 0L) {
            throw new IllegalArgumentException("Auto Rendezvous Check Interval must be >= 0");
        }
        this.autoRendezvousCheckInterval = newvalue;
    }

    public boolean getProbeRelays() {
        return this.probeRelays;
    }

    public void setProbeRelays(boolean doProbe) {
        this.probeRelays = doProbe;
    }

    public URI[] getSeedRendezvous() {
        return this.seedRendezvous.toArray(new URI[this.seedRendezvous.size()]);
    }

    public void addSeedRendezvous(URI addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedRendezvous.add(addr);
    }

    public void addSeedRendezvous(String addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedRendezvous.add(URI.create(addr));
    }

    public boolean removeSeedRendezvous(URI addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        return this.seedRendezvous.remove(addr);
    }

    public void clearSeedRendezvous() {
        this.seedRendezvous.clear();
    }

    public URI[] getSeedingURIs() {
        return this.seedingURIs.toArray(new URI[this.seedingURIs.size()]);
    }

    public void addSeedingURI(URI addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedingURIs.add(addr);
    }

    public void addSeedingURI(String addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedingURIs.add(URI.create(addr));
    }

    public boolean removeSeedingURI(URI addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        return this.seedingURIs.remove(addr);
    }

    public void clearSeedingURIs() {
        this.seedingURIs.clear();
    }

    public boolean getUseOnlySeeds() {
        return this.useOnlySeeds;
    }

    public void setUseOnlySeeds(boolean onlySeeds) {
        this.useOnlySeeds = onlySeeds;
    }

    public long getSeedRendezvousConnectDelay() {
        return this.seedRendezvousConnectDelay;
    }

    public void setSeedRendezvousConnectDelay(long newvalue) {
        if (-1L != newvalue && newvalue < 0L) {
            throw new IllegalArgumentException("Seed Rendezvous Connect Delay must be >= 0");
        }
        this.seedRendezvousConnectDelay = newvalue;
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public void setLeaseDuration(long newvalue) {
        if (-1L != newvalue && newvalue < 0L) {
            throw new IllegalArgumentException("Lease Duration must be >= 0");
        }
        this.leaseDuration = newvalue;
    }

    public long getLeaseMargin() {
        return this.leaseMargin;
    }

    public void setLeaseMargin(long newvalue) {
        if (-1L != newvalue && newvalue < 0L) {
            throw new IllegalArgumentException("Lease Margin must be >= 0");
        }
        this.leaseMargin = newvalue;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public void setMaxClients(int newvalue) {
        if (-1 != newvalue && newvalue <= 0) {
            throw new IllegalArgumentException("Max Clients must be > 0");
        }
        this.maxClients = newvalue;
    }

    public int getMaxTTL() {
        return this.maximumTTL;
    }

    public void setMaxTTL(int newvalue) {
        if (-1 != newvalue && newvalue <= 0) {
            throw new IllegalArgumentException("Max TTL must be >= 0");
        }
        this.maximumTTL = newvalue;
    }

    public int getMinHappyPeerView() {
        return this.minHappyPeerView;
    }

    public void setMinHappyPeerView(int newvalue) {
        if (-1 != newvalue && newvalue <= 0) {
            throw new IllegalArgumentException("Min Happy Peer View size must be > 0");
        }
        this.minHappyPeerView = newvalue;
    }

    public URI getAclUri() {
        return this.aclURI;
    }

    public void setAclUri(URI uri) {
        this.aclURI = uri;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RendezVousConfiguration {
        AD_HOC,
        EDGE,
        RENDEZVOUS;

    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RdvConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new RdvConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new RdvConfigAdv((XMLElement)root);
        }
    }
}

