/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;
import net.jxta.logging.Logging;

public final class RelayConfigAdv
extends ExtendableAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(RelayConfigAdv.class.getName());
    private static final String advType = "jxta:RelayConfig";
    private static final String RELAY_CLIENT_ATTR = "client";
    private static final String RELAY_SERVER_ATTR = "server";
    private static final String RELAY_CLIENT_ELEMENT = "client";
    private static final String RELAY_CLIENT_SERVERS_ATTR = "maxRelays";
    private static final String RELAY_CLIENT_LEASE_ATTR = "maxLease";
    private static final String RELAY_CLIENT_POLL_ATTR = "messengerPollInterval";
    private static final String RELAY_CLIENT_SEEDS_ELEMENT = "seeds";
    private static final String USE_ONLY_SEEDS_ATTR = "useOnlySeeds";
    private static final String SEED_RELAY_ADDR_ELEMENT = "addr";
    private static final String SEED_RELAY_ADDR_SEEDING_ATTR = "seeding";
    private static final String RELAY_SERVER_ELEMENT = "server";
    private static final String RELAY_SERVER_CLIENTS_ATTR = "maxClients";
    private static final String RELAY_SERVER_QUEUE_ATTR = "clientQueue";
    private static final String RELAY_SERVER_LEASE_ATTR = "leaseDuration";
    private static final String RELAY_SERVER_STALL_ATTR = "stallTimeout";
    private static final String RELAY_SERVER_ANNOUNCE_ATTR = "announceInterval";
    private static final String ACL_URI = "acl";
    private static final String[] fields = new String[0];
    private boolean clientEnabled = false;
    private int maxRelays = -1;
    private long maxClientLeaseDuration = -1L;
    private long messengerPollInterval = -1L;
    private boolean useOnlySeeds = false;
    private Set<EndpointAddress> seedRelays = new HashSet<EndpointAddress>();
    private Set<URI> seedingURIs = new HashSet<URI>();
    private boolean serverEnabled = false;
    private int maxClients = -1;
    private int maxClientMessageQueue = -1;
    private long maxServerLeaseDuration = -1L;
    private long stallTimeout = -1L;
    private long announceInterval = -1L;
    private URI aclURI = null;

    public static String getAdvertisementType() {
        return advType;
    }

    private RelayConfigAdv() {
    }

    private RelayConfigAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(RelayConfigAdv.getAdvertisementType()) && !RelayConfigAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration<Attribute> eachAttr = doc.getAttributes();
        while (eachAttr.hasMoreElements()) {
            Attribute aRelayAttr = eachAttr.nextElement();
            if (super.handleAttribute(aRelayAttr)) continue;
            if ("client".equals(aRelayAttr.getName())) {
                this.clientEnabled = Boolean.valueOf(aRelayAttr.getValue().trim());
                continue;
            }
            if ("server".equals(aRelayAttr.getName())) {
                this.serverEnabled = Boolean.valueOf(aRelayAttr.getValue().trim());
                continue;
            }
            if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Attribute: " + aRelayAttr.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning("Unhandled Element: " + elem.toString());
        }
        if (-1 != this.maxRelays && this.maxRelays <= 0) {
            throw new IllegalArgumentException("Max relays must not be negative or zero.");
        }
        if (-1L != this.maxClientLeaseDuration && this.maxClientLeaseDuration <= 0L) {
            throw new IllegalArgumentException("Max lease duration must not be negative or zero.");
        }
        if (-1L != this.messengerPollInterval && this.messengerPollInterval <= 0L) {
            throw new IllegalArgumentException("Messenger poll interval must not be negative or zero.");
        }
        if (this.useOnlySeeds && this.clientEnabled && this.seedRelays.isEmpty() && this.seedingURIs.isEmpty()) {
            throw new IllegalArgumentException("Cannot specify 'useOnlySeeds' and no seed relays");
        }
        if (-1 != this.maxClients && this.maxClients <= 0) {
            throw new IllegalArgumentException("Max clients must not be negative or zero.");
        }
        if (-1 != this.maxClientMessageQueue && this.maxClientMessageQueue <= 0) {
            throw new IllegalArgumentException("Max client queue must not be negative or zero.");
        }
        if (-1L != this.maxServerLeaseDuration && this.maxServerLeaseDuration <= 0L) {
            throw new IllegalArgumentException("Max lease duration must not be negative or zero.");
        }
        if (-1L != this.stallTimeout && this.stallTimeout <= 0L) {
            throw new IllegalArgumentException("Client stall timeout duration must not be negative or zero.");
        }
        if (-1L != this.announceInterval && this.announceInterval <= 0L) {
            throw new IllegalArgumentException("Announce interval must not be negative or zero.");
        }
    }

    public RelayConfigAdv clone() {
        RelayConfigAdv result;
        try {
            result = (RelayConfigAdv)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
        result.setAnnounceInterval(this.getAnnounceInterval());
        result.setClientEnabled(this.isClientEnabled());
        result.setClientLeaseDuration(this.getClientLeaseDuration());
        result.setClientMessageQueueSize(this.getClientMessageQueueSize());
        result.setMaxClients(this.getMaxClients());
        result.setMaxRelays(this.getMaxRelays());
        result.setMessengerPollInterval(this.getMessengerPollInterval());
        result.setServerEnabled(this.isServerEnabled());
        result.setServerLeaseDuration(this.getServerLeaseDuration());
        result.setStallTimeout(this.getStallTimeout());
        result.setUseOnlySeeds(this.getUseOnlySeeds());
        return result;
    }

    public String getAdvType() {
        return RelayConfigAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return RelayConfigAdv.getAdvertisementType();
    }

    public ID getID() {
        return ID.nullID;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if ("client".equals(elem.getName())) {
            Enumeration<Attribute> eachAttr = elem.getAttributes();
            while (eachAttr.hasMoreElements()) {
                Attribute aRelayAttr = eachAttr.nextElement();
                if (RELAY_CLIENT_SERVERS_ATTR.equals(aRelayAttr.getName())) {
                    this.maxRelays = Integer.parseInt(aRelayAttr.getValue().trim());
                    continue;
                }
                if (RELAY_CLIENT_LEASE_ATTR.equals(aRelayAttr.getName())) {
                    this.maxClientLeaseDuration = Long.parseLong(aRelayAttr.getValue().trim());
                    continue;
                }
                if (RELAY_CLIENT_POLL_ATTR.equals(aRelayAttr.getName())) {
                    this.messengerPollInterval = Long.parseLong(aRelayAttr.getValue().trim());
                    continue;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Attribute: " + aRelayAttr.getName());
            }
            Enumeration elements = elem.getChildren();
            while (elements.hasMoreElements()) {
                XMLElement seedsElem = (XMLElement)elements.nextElement();
                if (RELAY_CLIENT_SEEDS_ELEMENT.equals(seedsElem.getName())) {
                    Enumeration<Attribute> eachSeedsAttr = seedsElem.getAttributes();
                    while (eachSeedsAttr.hasMoreElements()) {
                        Attribute aRelayAttr = eachSeedsAttr.nextElement();
                        if (USE_ONLY_SEEDS_ATTR.equals(aRelayAttr.getName())) {
                            this.useOnlySeeds = Boolean.valueOf(aRelayAttr.getValue().trim());
                            continue;
                        }
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.warning("Unhandled Attribute: " + aRelayAttr.getName());
                    }
                    Enumeration addrElements = seedsElem.getChildren();
                    while (addrElements.hasMoreElements()) {
                        XMLElement addrElem = (XMLElement)addrElements.nextElement();
                        if (SEED_RELAY_ADDR_ELEMENT.equals(addrElem.getName())) {
                            String endpAddrString = addrElem.getTextValue();
                            if (null == endpAddrString) continue;
                            URI endpURI = URI.create(endpAddrString.trim());
                            Attribute seedingAttr = addrElem.getAttribute(SEED_RELAY_ADDR_SEEDING_ATTR);
                            if (null != seedingAttr && Boolean.valueOf(seedingAttr.getValue().trim()).booleanValue()) {
                                this.seedingURIs.add(endpURI);
                                continue;
                            }
                            this.seedRelays.add(new EndpointAddress(endpURI));
                            continue;
                        }
                        if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                        LOG.warning("Unhandled Element: " + elem.toString());
                    }
                    continue;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Element: " + elem.toString());
            }
            return true;
        }
        if ("server".equals(elem.getName())) {
            Enumeration<Attribute> eachAttr = elem.getAttributes();
            while (eachAttr.hasMoreElements()) {
                Attribute aRelayAttr = eachAttr.nextElement();
                if (RELAY_SERVER_CLIENTS_ATTR.equals(aRelayAttr.getName())) {
                    this.maxClients = Integer.parseInt(aRelayAttr.getValue().trim());
                    continue;
                }
                if (RELAY_SERVER_QUEUE_ATTR.equals(aRelayAttr.getName())) {
                    this.maxClientMessageQueue = Integer.parseInt(aRelayAttr.getValue().trim());
                    continue;
                }
                if (RELAY_SERVER_LEASE_ATTR.equals(aRelayAttr.getName())) {
                    this.maxServerLeaseDuration = Long.parseLong(aRelayAttr.getValue().trim());
                    continue;
                }
                if (RELAY_SERVER_STALL_ATTR.equals(aRelayAttr.getName())) {
                    this.stallTimeout = Long.parseLong(aRelayAttr.getValue().trim());
                    continue;
                }
                if (RELAY_SERVER_ANNOUNCE_ATTR.equals(aRelayAttr.getName())) {
                    this.announceInterval = Long.parseLong(aRelayAttr.getValue().trim());
                    continue;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled Attribute: " + aRelayAttr.getName());
            }
            return true;
        }
        if (ACL_URI.equals(elem.getName())) {
            String addrElement = elem.getTextValue();
            if (null != addrElement) {
                this.aclURI = URI.create(addrElement.trim());
            }
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (!(adv instanceof Attributable)) {
            throw new IllegalStateException("Only Attributable documents are supported.");
        }
        if (-1 != this.maxRelays && this.maxRelays <= 0) {
            throw new IllegalStateException("Max relays must not be negative or zero.");
        }
        if (-1L != this.maxClientLeaseDuration && this.maxClientLeaseDuration <= 0L) {
            throw new IllegalStateException("Max lease duration must not be negative or zero.");
        }
        if (-1L != this.messengerPollInterval && this.messengerPollInterval <= 0L) {
            throw new IllegalStateException("Messenger poll interval must not be negative or zero.");
        }
        if (this.useOnlySeeds && this.clientEnabled && this.seedRelays.isEmpty() && this.seedingURIs.isEmpty()) {
            throw new IllegalStateException("Cannot specify 'useOnlySeeds' and no seed relays");
        }
        if (-1 != this.maxClients && this.maxClients <= 0) {
            throw new IllegalStateException("Max clients must not be negative or zero.");
        }
        if (-1 != this.maxClientMessageQueue && this.maxClientMessageQueue <= 0) {
            throw new IllegalStateException("Max client queue must not be negative or zero.");
        }
        if (-1L != this.maxServerLeaseDuration && this.maxServerLeaseDuration <= 0L) {
            throw new IllegalStateException("Max lease duration must not be negative or zero.");
        }
        if (-1L != this.stallTimeout && this.stallTimeout <= 0L) {
            throw new IllegalStateException("Client stall timeout duration must not be negative or zero.");
        }
        if (-1L != this.announceInterval && this.announceInterval <= 0L) {
            throw new IllegalStateException("Announce interval must not be negative or zero.");
        }
        Attributable attrDoc = (Attributable)((Object)adv);
        if (this.clientEnabled) {
            attrDoc.addAttribute("client", Boolean.TRUE.toString());
        }
        if (this.serverEnabled) {
            attrDoc.addAttribute("server", Boolean.TRUE.toString());
        }
        Object clientElem = adv.createElement("client");
        adv.appendChild(clientElem);
        Attributable attrElem = (Attributable)clientElem;
        if (-1 != this.maxRelays) {
            attrElem.addAttribute(RELAY_CLIENT_SERVERS_ATTR, Integer.toString(this.maxRelays));
        }
        if (-1L != this.maxClientLeaseDuration) {
            attrElem.addAttribute(RELAY_CLIENT_LEASE_ATTR, Long.toString(this.maxClientLeaseDuration));
        }
        if (-1L != this.messengerPollInterval) {
            attrElem.addAttribute(RELAY_CLIENT_POLL_ATTR, Long.toString(this.messengerPollInterval));
        }
        if (!this.seedRelays.isEmpty() || !this.seedingURIs.isEmpty()) {
            Object addrElement;
            Object seedsElem = adv.createElement(RELAY_CLIENT_SEEDS_ELEMENT);
            clientElem.appendChild(seedsElem);
            attrElem = (Attributable)seedsElem;
            if (this.useOnlySeeds) {
                attrElem.addAttribute(USE_ONLY_SEEDS_ATTR, Boolean.TRUE.toString());
            }
            for (EndpointAddress seedRelay : this.seedRelays) {
                addrElement = adv.createElement(SEED_RELAY_ADDR_ELEMENT, seedRelay.toString());
                seedsElem.appendChild(addrElement);
            }
            for (URI seedingURI : this.seedingURIs) {
                addrElement = adv.createElement(SEED_RELAY_ADDR_ELEMENT, seedingURI.toString());
                seedsElem.appendChild(addrElement);
                ((Attributable)addrElement).addAttribute(SEED_RELAY_ADDR_SEEDING_ATTR, Boolean.TRUE.toString());
            }
        }
        Object serverElem = adv.createElement("server");
        adv.appendChild(serverElem);
        attrElem = (Attributable)serverElem;
        if (-1 != this.maxClients) {
            attrElem.addAttribute(RELAY_SERVER_CLIENTS_ATTR, Integer.toString(this.maxClients));
        }
        if (-1 != this.maxClientMessageQueue) {
            attrElem.addAttribute(RELAY_SERVER_QUEUE_ATTR, Integer.toString(this.maxClientMessageQueue));
        }
        if (-1L != this.maxServerLeaseDuration) {
            attrElem.addAttribute(RELAY_SERVER_LEASE_ATTR, Long.toString(this.maxServerLeaseDuration));
        }
        if (-1L != this.stallTimeout) {
            attrElem.addAttribute(RELAY_SERVER_STALL_ATTR, Long.toString(this.stallTimeout));
        }
        if (-1L != this.announceInterval) {
            attrElem.addAttribute(RELAY_SERVER_ANNOUNCE_ATTR, Long.toString(this.announceInterval));
        }
        if (this.aclURI != null) {
            Object acl = adv.createElement(ACL_URI, this.aclURI.toString());
            adv.appendChild(acl);
        }
        return adv;
    }

    public String[] getIndexFields() {
        return fields;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.clientEnabled = enabled;
    }

    public int getMaxRelays() {
        return this.maxRelays;
    }

    public void setMaxRelays(int newvalue) {
        if (-1 != newvalue && newvalue <= 0) {
            throw new IllegalArgumentException("Max Relays must be > 0");
        }
        this.maxRelays = newvalue;
    }

    public long getClientLeaseDuration() {
        return this.maxClientLeaseDuration;
    }

    public void setClientLeaseDuration(long newvalue) {
        if (-1L != newvalue && newvalue <= 0L) {
            throw new IllegalArgumentException("Lease Duration must be > 0");
        }
        this.maxClientLeaseDuration = newvalue;
    }

    public long getMessengerPollInterval() {
        return this.messengerPollInterval;
    }

    public void setMessengerPollInterval(long newvalue) {
        if (-1L != newvalue && newvalue <= 0L) {
            throw new IllegalArgumentException("Poll interval must be > 0");
        }
        this.messengerPollInterval = newvalue;
    }

    public boolean getUseOnlySeeds() {
        return this.useOnlySeeds;
    }

    public void setUseOnlySeeds(boolean onlySeeds) {
        this.useOnlySeeds = onlySeeds;
    }

    public EndpointAddress[] getSeedRelays() {
        return this.seedRelays.toArray(new EndpointAddress[this.seedRelays.size()]);
    }

    public void addSeedRelay(EndpointAddress addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedRelays.add(addr);
    }

    public void addSeedRelay(String addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedRelays.add(new EndpointAddress(addr));
    }

    public boolean removeSeedRelay(EndpointAddress addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        return this.seedRelays.remove(addr);
    }

    public void clearSeedRelays() {
        this.seedRelays.clear();
    }

    public URI[] getSeedingURIs() {
        return this.seedingURIs.toArray(new URI[this.seedingURIs.size()]);
    }

    public void addSeedingURI(URI addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedingURIs.add(addr);
    }

    public void addSeedingURI(String addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        this.seedingURIs.add(URI.create(addr));
    }

    public boolean removeSeedingURI(URI addr) {
        if (null == addr) {
            throw new IllegalArgumentException("addr may not be null");
        }
        return this.seedingURIs.remove(addr);
    }

    public void clearSeedingURIs() {
        this.seedingURIs.clear();
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    public int getMaxClients() {
        return this.maxClients;
    }

    public void setMaxClients(int newvalue) {
        if (-1 != newvalue && newvalue <= 0) {
            throw new IllegalArgumentException("Max Clients must be > 0");
        }
        this.maxClients = newvalue;
    }

    public int getClientMessageQueueSize() {
        return this.maxClientMessageQueue;
    }

    public void setClientMessageQueueSize(int newvalue) {
        if (-1 != newvalue && newvalue <= 0) {
            throw new IllegalArgumentException("Client Message Queue Size must be > 0");
        }
        this.maxClientMessageQueue = newvalue;
    }

    public long getServerLeaseDuration() {
        return this.maxServerLeaseDuration;
    }

    public void setServerLeaseDuration(long newvalue) {
        if (-1L != newvalue && newvalue <= 0L) {
            throw new IllegalArgumentException("Lease Duration must be >= 0");
        }
        this.maxServerLeaseDuration = newvalue;
    }

    public long getStallTimeout() {
        return this.stallTimeout;
    }

    public void setStallTimeout(long newvalue) {
        if (-1L != newvalue && newvalue <= 0L) {
            throw new IllegalArgumentException("Stall timeout must be > 0");
        }
        this.stallTimeout = newvalue;
    }

    public long getAnnounceInterval() {
        return this.announceInterval;
    }

    public void setAnnounceInterval(long newvalue) {
        if (-1L != newvalue && newvalue <= 0L) {
            throw new IllegalArgumentException("Announce Interval must be > 0");
        }
        this.announceInterval = newvalue;
    }

    public URI getAclUri() {
        return this.aclURI;
    }

    public void setAclUri(URI uri) {
        this.aclURI = uri;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return RelayConfigAdv.advType;
        }

        public Advertisement newInstance() {
            return new RelayConfigAdv();
        }

        public Advertisement newInstance(Element root) {
            return new RelayConfigAdv(root);
        }
    }
}

