/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core.filer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.FilerException;
import net.jxta.impl.xindice.core.filer.Streamable;

public abstract class Paged {
    private static final Logger LOG = Logger.getLogger(Paged.class.getName());
    private static final int MAX_DIRTY_SIZE = 128;
    private static final int DEFAULT_DESCRIPTORS_MAX = 16;
    protected static final byte UNUSED = 0;
    protected static final byte OVERFLOW = 126;
    protected static final byte DELETED = 127;
    protected static final int NO_PAGE = -1;
    protected boolean sync = true;
    private final Map<Long, WeakReference<Page>> pages = new WeakHashMap<Long, WeakReference<Page>>();
    private Map<Long, Page> dirty = new HashMap<Long, Page>();
    private final Object dirtyLock = new Object();
    private final Stack<RandomAccessFile> descriptors = new Stack();
    private int descriptorsCount;
    private int descriptorsMax = 16;
    private boolean opened;
    private File file;
    private final FileHeader fileHeader = this.createFileHeader();

    public Paged() {
    }

    public Paged(File file) {
        this();
        this.setFile(file);
    }

    protected final void setFile(File file) {
        this.file = file;
    }

    protected final File getFile() {
        return this.file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final RandomAccessFile getDescriptor() throws IOException {
        Stack<RandomAccessFile> stack = this.descriptors;
        synchronized (stack) {
            if (!this.descriptors.empty()) {
                return this.descriptors.pop();
            }
            if (this.descriptorsCount < this.descriptorsMax) {
                ++this.descriptorsCount;
                return new RandomAccessFile(this.file, "rw");
            }
            while (true) {
                try {
                    this.descriptors.wait();
                    return this.descriptors.pop();
                }
                catch (InterruptedException e) {
                    continue;
                }
                catch (EmptyStackException emptyStackException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putDescriptor(RandomAccessFile raf) {
        if (raf != null) {
            Stack<RandomAccessFile> stack = this.descriptors;
            synchronized (stack) {
                this.descriptors.push(raf);
                this.descriptors.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeDescriptor(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Stack<RandomAccessFile> stack = this.descriptors;
            synchronized (stack) {
                --this.descriptorsCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Page getPage(long pageNum) throws IOException {
        Page page;
        Long lp = pageNum;
        Paged paged = this;
        synchronized (paged) {
            WeakReference<Page> ref;
            page = this.dirty.get(lp);
            if (page == null && (ref = this.pages.get(lp)) != null) {
                page = (Page)ref.get();
            }
            if (page == null) {
                page = new Page(lp);
                this.pages.put(page.pageNum, new WeakReference<Page>(page));
            }
        }
        page.read();
        return page;
    }

    protected final Value readValue(Page page) throws IOException {
        PageHeader sph = page.getPageHeader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(sph.getRecordLen());
        Page p = page;
        while (true) {
            PageHeader ph = p.getPageHeader();
            p.streamTo(bos);
            long nextPage = ph.getNextPage();
            if (nextPage == -1L) break;
            p = this.getPage(nextPage);
        }
        return new Value(bos.toByteArray());
    }

    protected final Value readValue(long page) throws IOException {
        return this.readValue(this.getPage(page));
    }

    protected final void writeValue(Page page, Value value) throws IOException {
        if (value == null) {
            throw new IOException("Can't write a null value");
        }
        InputStream is = value.getInputStream();
        PageHeader hdr = page.getPageHeader();
        hdr.setRecordLen(value.getLength());
        page.streamFrom(is);
        while (is.available() > 0) {
            Page lpage = page;
            PageHeader lhdr = hdr;
            long np = lhdr.getNextPage();
            if (np != -1L) {
                page = this.getPage(np);
            } else {
                page = this.getFreePage();
                lhdr.setNextPage(page.getPageNum());
            }
            hdr = page.getPageHeader();
            hdr.setStatus((byte)126);
            page.streamFrom(is);
            lpage.write();
        }
        long np = hdr.getNextPage();
        if (np != -1L) {
            this.unlinkPages(np);
        }
        hdr.setNextPage(-1L);
        page.write();
    }

    protected final void writeValue(long page, Value value) throws IOException {
        this.writeValue(this.getPage(page), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unlinkPages(Page page) throws IOException {
        if (page.pageNum < this.fileHeader.pageCount) {
            long nextPage = page.header.nextPage;
            page.header.setStatus((byte)127);
            page.header.setNextPage(-1L);
            page.write();
            page = nextPage == -1L ? null : this.getPage(nextPage);
        }
        if (page != null) {
            long firstPage = page.pageNum;
            while (page.header.nextPage != -1L) {
                page = this.getPage(page.header.nextPage);
            }
            long lastPage = page.pageNum;
            FileHeader fileHeader = this.fileHeader;
            synchronized (fileHeader) {
                if (this.fileHeader.lastFreePage != -1L) {
                    Page p = this.getPage(this.fileHeader.lastFreePage);
                    p.header.setNextPage(firstPage);
                    p.write();
                }
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setFirstFreePage(firstPage);
                }
                this.fileHeader.setLastFreePage(lastPage);
            }
        }
    }

    protected final void unlinkPages(long pageNum) throws IOException {
        this.unlinkPages(this.getPage(pageNum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Page getFreePage() throws IOException {
        Page p = null;
        FileHeader fileHeader = this.fileHeader;
        synchronized (fileHeader) {
            if (this.fileHeader.firstFreePage != -1L) {
                p = this.getPage(this.fileHeader.firstFreePage);
                this.fileHeader.setFirstFreePage(p.getPageHeader().nextPage);
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setLastFreePage(-1L);
                }
            }
        }
        if (p == null) {
            p = this.getPage(this.fileHeader.incTotalCount());
        }
        p.header.setNextPage(-1L);
        p.header.setStatus((byte)0);
        return p;
    }

    protected final void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean create() throws DBException {
        try {
            this.createFile();
            this.fileHeader.write();
            this.flush();
            return true;
        }
        catch (Exception e) {
            throw new FilerException(70, "Error creating " + this.file.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile() throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = this.getDescriptor();
            long o = (long)this.fileHeader.headerSize + (this.fileHeader.pageCount + 1L) * (long)this.fileHeader.pageSize - 1L;
            raf.seek(o);
            raf.write(0);
        }
        finally {
            this.putDescriptor(raf);
        }
    }

    public boolean open() throws DBException {
        RandomAccessFile raf = null;
        try {
            if (this.exists()) {
                raf = this.getDescriptor();
                this.fileHeader.read();
                this.opened = true;
            } else {
                this.opened = false;
            }
            boolean bl = this.opened;
            this.putDescriptor(raf);
            return bl;
        }
        catch (Exception e) {
            try {
                throw new FilerException(70, "Error opening " + this.file.getName(), e);
            }
            catch (Throwable throwable) {
                this.putDescriptor(raf);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close() throws DBException {
        if (this.isOpened()) {
            try {
                this.opened = false;
                this.flush();
                Stack<RandomAccessFile> stack = this.descriptors;
                synchronized (stack) {
                    int total = this.descriptorsCount;
                    while (!this.descriptors.empty()) {
                        this.closeDescriptor(this.descriptors.pop());
                    }
                    int n = this.descriptorsCount;
                    while (this.descriptorsCount > 0 && n > 0) {
                        try {
                            this.descriptors.wait(500L);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                        }
                        if (this.descriptors.isEmpty()) {
                            --n;
                            continue;
                        }
                        this.closeDescriptor(this.descriptors.pop());
                    }
                    if (this.descriptorsCount > 0) {
                        LOG.fine(this.descriptorsCount + " out of " + total + " files were not closed during close.");
                    }
                }
            }
            catch (Exception e) {
                this.opened = true;
                throw new FilerException(70, "Error closing " + this.file.getName(), e);
            }
        }
        return true;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean drop() throws DBException {
        try {
            this.close();
            return !this.exists() || this.getFile().delete();
        }
        catch (Exception e) {
            throw new FilerException(271, "Can't drop " + this.file.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirty(Page page) throws IOException {
        Object object = this.dirtyLock;
        synchronized (object) {
            this.dirty.put(page.pageNum, page);
            if (this.dirty.size() > 128) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws DBException {
        Collection<Page> pages;
        int error = 0;
        Object object = this.dirtyLock;
        synchronized (object) {
            pages = this.dirty.values();
            this.dirty = new HashMap<Long, Page>();
        }
        Iterator<Page> i$ = pages.iterator();
        while (i$.hasNext()) {
            Page page;
            Page p = page = i$.next();
            try {
                p.flush();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception while flushing page", e);
                ++error;
            }
        }
        if (this.fileHeader.dirty) {
            try {
                this.fileHeader.write();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Exception while flushing file header", e);
                ++error;
            }
        }
        if (error != 0) {
            throw new FilerException(70, "Error performing flush! Failed to flush " + error + " pages!");
        }
    }

    public abstract FileHeader createFileHeader();

    public abstract FileHeader createFileHeader(boolean var1) throws IOException;

    public abstract FileHeader createFileHeader(long var1);

    public abstract FileHeader createFileHeader(long var1, int var3);

    public abstract PageHeader createPageHeader();

    public static Value[] insertArrayValue(Value[] vals, Value val, int idx) {
        Value[] newVals = new Value[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static Value[] deleteArrayValue(Value[] vals, int idx) {
        Value[] newVals = new Value[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static long[] insertArrayLong(long[] vals, long val, int idx) {
        long[] newVals = new long[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static long[] deleteArrayLong(long[] vals, int idx) {
        long[] newVals = new long[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static int[] insertArrayInt(int[] vals, int val, int idx) {
        int[] newVals = new int[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static int[] deleteArrayInt(int[] vals, int idx) {
        int[] newVals = new int[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    public static short[] insertArrayShort(short[] vals, short val, int idx) {
        short[] newVals = new short[vals.length + 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        newVals[idx] = val;
        if (idx < vals.length) {
            System.arraycopy(vals, idx, newVals, idx + 1, vals.length - idx);
        }
        return newVals;
    }

    public static short[] deleteArrayShort(short[] vals, int idx) {
        short[] newVals = new short[vals.length - 1];
        if (idx > 0) {
            System.arraycopy(vals, 0, newVals, 0, idx);
        }
        if (idx < newVals.length) {
            System.arraycopy(vals, idx + 1, newVals, idx, newVals.length - idx);
        }
        return newVals;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Page
    implements Comparable<Page> {
        private final Long pageNum;
        private final PageHeader header;
        private final long offset;
        private byte[] data;
        private int keyPos;
        private int dataPos;

        public Page(Long pageNum) {
            this.header = Paged.this.createPageHeader();
            this.pageNum = pageNum;
            this.offset = (long)Paged.this.fileHeader.headerSize + pageNum * (long)Paged.this.fileHeader.pageSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void read() throws IOException {
            if (this.data == null) {
                RandomAccessFile raf = null;
                try {
                    byte[] data = new byte[Paged.this.fileHeader.pageSize];
                    raf = Paged.this.getDescriptor();
                    raf.seek(this.offset);
                    raf.read(data);
                    ByteArrayInputStream bis = new ByteArrayInputStream(data);
                    this.header.read(new DataInputStream(bis));
                    this.keyPos = Paged.this.fileHeader.pageHeaderSize;
                    this.dataPos = this.keyPos + this.header.keyLen;
                    this.data = data;
                    Paged.this.putDescriptor(raf);
                }
                catch (Throwable throwable) {
                    Paged.this.putDescriptor(raf);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException {
            Page page = this;
            synchronized (page) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(Paged.this.fileHeader.getPageHeaderSize());
                this.header.write(new DataOutputStream(bos));
                byte[] b = bos.toByteArray();
                System.arraycopy(b, 0, this.data, 0, b.length);
            }
            Paged.this.addDirty(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush() throws IOException {
            RandomAccessFile raf = null;
            try {
                raf = Paged.this.getDescriptor();
                if (this.offset >= raf.length()) {
                    long o = (long)Paged.this.fileHeader.headerSize + Paged.this.fileHeader.totalCount * 3L / 2L * (long)Paged.this.fileHeader.pageSize + (long)(Paged.this.fileHeader.pageSize - 1);
                    raf.seek(o);
                    raf.writeByte(0);
                }
                raf.seek(this.offset);
                raf.write(this.data);
                if (Paged.this.sync) {
                    raf.getFD().sync();
                }
            }
            finally {
                Paged.this.putDescriptor(raf);
            }
        }

        public Long getPageNum() {
            return this.pageNum;
        }

        public PageHeader getPageHeader() {
            return this.header;
        }

        public synchronized void setKey(Key key) {
            this.header.setKey(key);
            key.copyTo(this.data, this.keyPos);
            this.dataPos = this.keyPos + this.header.keyLen;
        }

        public synchronized Key getKey() {
            if (this.header.keyLen > 0) {
                return new Key(this.data, this.keyPos, this.header.keyLen);
            }
            return null;
        }

        public synchronized void streamTo(OutputStream os) throws IOException {
            if (this.header.dataLen > 0) {
                os.write(this.data, this.dataPos, this.header.dataLen);
            }
        }

        public synchronized void streamFrom(InputStream is) throws IOException {
            int avail = is.available();
            this.header.dataLen = Paged.this.fileHeader.workSize - this.header.keyLen;
            if (avail < this.header.dataLen) {
                this.header.dataLen = avail;
            }
            if (this.header.dataLen > 0) {
                is.read(this.data, this.keyPos + this.header.keyLen, this.header.dataLen);
            }
        }

        @Override
        public int compareTo(Page o) {
            return (int)(this.pageNum - o.pageNum);
        }
    }

    public abstract class PageHeader
    implements Streamable {
        private boolean dirty = false;
        private byte status = 0;
        private int keyLen = 0;
        private int keyHash = 0;
        private int dataLen = 0;
        private int recordLen = 0;
        private long nextPage = -1L;

        public PageHeader() {
        }

        public PageHeader(DataInputStream dis) throws IOException {
            this.read(dis);
        }

        public synchronized void read(DataInputStream dis) throws IOException {
            this.status = dis.readByte();
            this.dirty = false;
            if (this.status == 0) {
                return;
            }
            this.keyLen = dis.readInt();
            if (this.keyLen < 0) {
                this.keyLen = 0;
            }
            this.keyHash = dis.readInt();
            this.dataLen = dis.readInt();
            this.recordLen = dis.readInt();
            this.nextPage = dis.readLong();
        }

        public synchronized void write(DataOutputStream dos) throws IOException {
            this.dirty = false;
            dos.writeByte(this.status);
            dos.writeInt(this.keyLen);
            dos.writeInt(this.keyHash);
            dos.writeInt(this.dataLen);
            dos.writeInt(this.recordLen);
            dos.writeLong(this.nextPage);
        }

        public final synchronized boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void setDirty() {
            this.dirty = true;
        }

        public final synchronized void setStatus(byte status) {
            this.status = status;
            this.dirty = true;
        }

        public final synchronized byte getStatus() {
            return this.status;
        }

        public final synchronized void setKey(Key key) {
            this.setRecordLen(0);
            this.dataLen = 0;
            this.keyHash = key.getHash();
            this.keyLen = key.getLength();
            this.dirty = true;
        }

        public final synchronized void setKeyLen(int keyLen) {
            this.keyLen = keyLen;
            this.dirty = true;
        }

        public final synchronized int getKeyLen() {
            return this.keyLen;
        }

        public final synchronized void setKeyHash(int keyHash) {
            this.keyHash = keyHash;
            this.dirty = true;
        }

        public final synchronized int getKeyHash() {
            return this.keyHash;
        }

        public final synchronized void setDataLen(int dataLen) {
            this.dataLen = dataLen;
            this.dirty = true;
        }

        public final synchronized int getDataLen() {
            return this.dataLen;
        }

        public synchronized void setRecordLen(int recordLen) {
            this.recordLen = recordLen;
            this.dirty = true;
        }

        public final synchronized int getRecordLen() {
            return this.recordLen;
        }

        public final synchronized void setNextPage(long nextPage) {
            this.nextPage = nextPage;
            this.dirty = true;
        }

        public final synchronized long getNextPage() {
            return this.nextPage;
        }
    }

    public abstract class FileHeader {
        private boolean dirty = false;
        private int workSize;
        private short headerSize;
        private int pageSize;
        private long pageCount;
        private long totalCount;
        private long firstFreePage = -1L;
        private long lastFreePage = -1L;
        private byte pageHeaderSize = (byte)64;
        private short maxKeySize = (short)256;
        private long recordCount;

        public FileHeader() {
            this(1024L);
        }

        public FileHeader(long pageCount) {
            this(pageCount, 4096);
        }

        public FileHeader(long pageCount, int pageSize) {
            this.pageSize = pageSize;
            this.pageCount = pageCount;
            this.totalCount = pageCount;
            this.headerSize = (short)4096;
            this.calculateWorkSize();
        }

        public FileHeader(boolean read) throws IOException {
            if (read) {
                this.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void read() throws IOException {
            RandomAccessFile raf = null;
            try {
                raf = Paged.this.getDescriptor();
                raf.seek(0L);
                this.read(raf);
                this.calculateWorkSize();
            }
            finally {
                Paged.this.putDescriptor(raf);
            }
        }

        public synchronized void read(RandomAccessFile raf) throws IOException {
            this.headerSize = raf.readShort();
            this.pageSize = raf.readInt();
            this.pageCount = raf.readLong();
            this.totalCount = raf.readLong();
            this.firstFreePage = raf.readLong();
            this.lastFreePage = raf.readLong();
            this.pageHeaderSize = raf.readByte();
            this.maxKeySize = raf.readShort();
            this.recordCount = raf.readLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void write() throws IOException {
            if (!this.dirty) {
                return;
            }
            RandomAccessFile raf = null;
            try {
                raf = Paged.this.getDescriptor();
                raf.seek(0L);
                this.write(raf);
                this.dirty = false;
            }
            finally {
                Paged.this.putDescriptor(raf);
            }
        }

        public synchronized void write(RandomAccessFile raf) throws IOException {
            raf.writeShort(this.headerSize);
            raf.writeInt(this.pageSize);
            raf.writeLong(this.pageCount);
            raf.writeLong(this.totalCount);
            raf.writeLong(this.firstFreePage);
            raf.writeLong(this.lastFreePage);
            raf.writeByte(this.pageHeaderSize);
            raf.writeShort(this.maxKeySize);
            raf.writeLong(this.recordCount);
        }

        public final synchronized void setDirty() {
            this.dirty = true;
        }

        public final synchronized boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void setHeaderSize(short headerSize) {
            this.headerSize = headerSize;
            this.dirty = true;
        }

        public final synchronized short getHeaderSize() {
            return this.headerSize;
        }

        public final synchronized void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final synchronized int getPageSize() {
            return this.pageSize;
        }

        public final synchronized void setPageCount(long pageCount) {
            this.pageCount = pageCount;
            this.dirty = true;
        }

        public final synchronized long getPageCount() {
            return this.pageCount;
        }

        public final synchronized void setTotalCount(long totalCount) {
            this.totalCount = totalCount;
            this.dirty = true;
        }

        public final synchronized long incTotalCount() {
            this.dirty = true;
            return this.totalCount++;
        }

        public final synchronized long getTotalCount() {
            return this.totalCount;
        }

        public final synchronized void setFirstFreePage(long firstFreePage) {
            this.firstFreePage = firstFreePage;
            this.dirty = true;
        }

        public final synchronized long getFirstFreePage() {
            return this.firstFreePage;
        }

        public final synchronized void setLastFreePage(long lastFreePage) {
            this.lastFreePage = lastFreePage;
            this.dirty = true;
        }

        public final synchronized long getLastFreePage() {
            return this.lastFreePage;
        }

        public final synchronized void setPageHeaderSize(byte pageHeaderSize) {
            this.pageHeaderSize = pageHeaderSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final synchronized byte getPageHeaderSize() {
            return this.pageHeaderSize;
        }

        public final synchronized void setMaxKeySize(short maxKeySize) {
            this.maxKeySize = maxKeySize;
            this.dirty = true;
        }

        public final synchronized short getMaxKeySize() {
            return this.maxKeySize;
        }

        public final synchronized void incRecordCount() {
            ++this.recordCount;
            this.dirty = true;
        }

        public final synchronized void decRecordCount() {
            --this.recordCount;
            this.dirty = true;
        }

        public final synchronized long getRecordCount() {
            return this.recordCount;
        }

        private synchronized void calculateWorkSize() {
            this.workSize = this.pageSize - this.pageHeaderSize;
        }

        public final synchronized int getWorkSize() {
            return this.workSize;
        }
    }
}

