/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.client.JMXConnection;
import com.sun.jbi.ui.client.JMXConnectionProperties;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.JMXConnectionException;
import java.util.Properties;

public abstract class JMXConnectionFactory {
    public static final String FACTORY_IMPL_CLASS_PROP = "com.sun.jbi.tools.jmx.connection.factory";
    public static final String FACTORY_IMPL_CLASS = "com.sun.jbi.ui.client.jmxremote.RemoteJMXConnectionFactory";
    private static I18NBundle sI18NBundle = null;
    private static String sFullPropertyFileName = null;

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.client");
        }
        return sI18NBundle;
    }

    public abstract JMXConnection getConnection(Properties var1) throws JMXConnectionException;

    public static Properties getConnectionProperties(Properties provprops, String host, String port, String username, String password) {
        Properties props = JMXConnectionProperties.getJMXConnectionPropertyMap(provprops, null, host, port, username, password);
        return props;
    }

    public static JMXConnectionFactory newInstance(String factoryImplName) throws JMXConnectionException {
        if (factoryImplName == null || factoryImplName.trim().equals("")) {
            return JMXConnectionFactory.newInstance();
        }
        try {
            Class<?> cl = Class.forName(factoryImplName);
            return (JMXConnectionFactory)cl.newInstance();
        }
        catch (Exception ex) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(JMXConnectionFactory.getI18NBundle(), "jbi.ui.client.connection.factory.error", new Object[]{factoryImplName}, ex), null);
        }
    }

    public static JMXConnectionFactory newInstance(Properties props) throws JMXConnectionException {
        String facImplname = null;
        if (props != null) {
            facImplname = props.getProperty(FACTORY_IMPL_CLASS_PROP);
        }
        return JMXConnectionFactory.newInstance(facImplname);
    }

    public static JMXConnectionFactory newInstance() throws JMXConnectionException {
        String factoryImplClass = JMXConnectionProperties.getInstance().getDefaultConnectionFactory();
        if (factoryImplClass == null) {
            factoryImplClass = FACTORY_IMPL_CLASS;
        }
        JMXConnectionFactory impl = null;
        try {
            impl = (JMXConnectionFactory)Class.forName(factoryImplClass).newInstance();
        }
        catch (Exception ex) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(JMXConnectionFactory.getI18NBundle(), "jbi.ui.client.connection.factory.error", new Object[]{factoryImplClass}, ex), null);
        }
        return impl;
    }
}

