/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;

public class ViewDependency {
    private Connection con;
    private String user;
    private String view;
    private DatabaseMetaData dmd;
    private LinkedList tables;
    private LinkedList columns;

    public ViewDependency(ConnectionProvider connectionProvider, String string, String string2) throws SQLException {
        this.con = connectionProvider.getConnection();
        this.user = string;
        this.view = string2;
        this.dmd = connectionProvider.getDatabaseMetaData();
        this.tables = new LinkedList();
        this.columns = new LinkedList();
    }

    public LinkedList getTables() {
        return this.tables;
    }

    public LinkedList getColumns() {
        return this.columns;
    }

    public void constructPK() {
        try {
            String string = this.dmd.getDatabaseProductName();
            if (string == null) {
                return;
            }
            if ((string = string.trim()).equalsIgnoreCase("Oracle")) {
                this.getOraclePKTable(this.user, this.view);
                this.getOracleViewColumns();
                return;
            }
            if (string.equalsIgnoreCase("Microsoft SQL Server")) {
                this.getMSSQLServerPKTable(this.user, this.view);
                this.getMSSQLServerViewColumns();
                return;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void getOraclePKTable(String string, String string2) throws SQLException {
        String string3 = "select OWNER, REFERENCED_OWNER, REFERENCED_NAME, REFERENCED_TYPE from ALL_DEPENDENCIES where NAME = ? AND OWNER = ?";
        PreparedStatement preparedStatement = this.con.prepareStatement(string3);
        preparedStatement.setString(1, string2);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string4 = resultSet.getString(4).trim();
            if (string4.equalsIgnoreCase("TABLE")) {
                this.tables.add(resultSet.getString(3).trim());
                continue;
            }
            if (!string4.equalsIgnoreCase("VIEW")) continue;
            this.getOraclePKTable(resultSet.getString(2), resultSet.getString(3));
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void getMSSQLServerPKTable(String string, String string2) throws SQLException {
        CallableStatement callableStatement = this.con.prepareCall("{call sp_depends(?)}");
        callableStatement.setString(1, string2);
        try {
            ResultSet resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(2).trim().toLowerCase();
                String string4 = resultSet.getString(1).trim();
                int n = string4.lastIndexOf(".");
                string4 = string4.substring(n + 1);
                if (string3.indexOf("table") != -1 && !this.tables.contains(string4)) {
                    this.tables.add(string4);
                    continue;
                }
                if (!string3.equals("view")) continue;
                this.getMSSQLServerPKTable(string, string4);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            Object var4_5 = null;
            return;
        }
    }

    private void getOracleViewColumns() throws SQLException {
        String string = null;
        String string2 = "select TEXT from ALL_VIEWS where VIEW_NAME = ?";
        PreparedStatement preparedStatement = this.con.prepareStatement(string2);
        preparedStatement.setString(1, this.view);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            string = resultSet.getString(1).trim();
        }
        resultSet.close();
        preparedStatement.close();
        if (string == null) {
            return;
        }
        int n = string.indexOf(" ");
        int n2 = string.toLowerCase().indexOf("from");
        string = string.substring(n, n2).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            this.columns.add(string3.toLowerCase());
        }
    }

    private void getMSSQLServerViewColumns() throws SQLException {
        String string = null;
        CallableStatement callableStatement = this.con.prepareCall("{call sp_helptext(?)}");
        callableStatement.setString(1, this.view);
        try {
            ResultSet resultSet = callableStatement.executeQuery();
            if (resultSet != null) {
                while (resultSet.next()) {
                    string = string + resultSet.getString(1).trim();
                }
            }
            resultSet.close();
            callableStatement.close();
            if (string == null) {
                return;
            }
            int n = string.toLowerCase().indexOf("select") + 6;
            int n2 = string.toLowerCase().indexOf("from");
            string = string.substring(n, n2).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                this.columns.add(string2.toLowerCase());
            }
        }
        catch (Exception exception) {
            Object var2_4 = null;
            return;
        }
    }
}

