/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.literal.LiteralObjectSerializerBase;
import com.sun.xml.rpc.processor.modeler.rmi.LiteralSimpleTypeCreator;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class GenericLiteralObjectSerializer
extends LiteralObjectSerializerBase
implements Initializable {
    protected Class targetClass = null;
    protected List members = new ArrayList();
    protected Map xmlToJavaType = new HashMap();
    protected Map javaToXmlType = new HashMap();
    protected InternalTypeMappingRegistry registry;
    protected Collection memberOrder;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public GenericLiteralObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(type, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public GenericLiteralObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        super(type, isNullable, encodingStyle, encodeType);
        this.init(ver);
        LiteralSimpleTypeCreator typeCreator = new LiteralSimpleTypeCreator();
        typeCreator.initializeJavaToXmlTypeMap(this.javaToXmlType);
    }

    public void addTypeRelation(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new IllegalArgumentException("Neither javaType nor xmlType may be null");
        }
        this.javaToXmlType.put(javaType, xmlType);
        this.xmlToJavaType.put(xmlType, javaType);
    }

    public void setTargetClass(Class targetClass) {
        this.clearMembers();
        this.doSetTargetClass(targetClass);
        this.targetClass = targetClass;
    }

    protected void doSetTargetClass(Class targetClass) {
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
        ParameterMemberInfo[] pmemberInfos = ((DynamicInternalTypeMappingRegistry)registry).getDynamicRegistryMembers(this.targetClass, this.type, "");
        int msize = this.members.size();
        int pmsize = 0;
        if (pmemberInfos != null) {
            pmsize = pmemberInfos.length;
            this.members = this.orderCurrentMembers(this.members, pmemberInfos);
        }
        Iterator eachMember = this.members.iterator();
        for (int i = 0; i < this.members.size(); ++i) {
            MemberInfo currentMember = (MemberInfo)this.members.get(i);
            Class pmJavaClass = null;
            QName pmXmlType = null;
            String pmName = null;
            if (i < pmsize) {
                ParameterMemberInfo pmInfo = pmemberInfos[i];
                pmJavaClass = pmInfo.getMemberJavaClass();
                pmXmlType = pmInfo.getMemberXmlType();
                pmName = pmInfo.getMemberName();
            }
            if (currentMember.xmlType == null && currentMember.javaType.isArray()) {
                QName qName = currentMember.xmlType = currentMember.name != null ? currentMember.name : currentMember.xmlType;
            }
            if (currentMember.javaType == pmJavaClass && currentMember.name.getLocalPart().equalsIgnoreCase(pmName)) {
                if (pmXmlType != null) {
                    currentMember.xmlType = pmXmlType;
                }
                if (pmName != null) {
                    currentMember.name = new QName("", pmName);
                }
            }
            currentMember.serializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
            currentMember.deserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
        }
    }

    public void clearMembers() {
        this.members.clear();
    }

    public void addMember(MemberInfo member) throws Exception {
        for (MemberInfo existingMember : this.members) {
            if (!existingMember.name.equals(member.name)) continue;
            throw new EncodingException("soap.duplicate.data.member", new Object[]{member.name});
        }
        if (member.xmlType == null) {
            member.xmlType = (QName)this.javaToXmlType.get(member.javaType);
        }
        if (member.javaType == null) {
            member.javaType = (Class)this.xmlToJavaType.get(member.xmlType);
        }
        this.members.add(member);
    }

    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.doSerializeInstance(obj, writer, context);
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        return this.doDeserialize(null, reader, context);
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        ParameterMemberInfo[] pmemberInfos = ((DynamicInternalTypeMappingRegistry)this.registry).getDynamicRegistryMembers(this.targetClass, this.type, "");
        int msize = this.members.size();
        int pmsize = 0;
        if (pmemberInfos != null) {
            pmsize = pmemberInfos.length;
        }
        this.members = this.memberOrder == null || this.memberOrder.size() == 0 ? this.getMemberOrder(instance, this.members) : this.checkFieldCase(this.members);
        for (int i = 0; i < this.members.size(); ++i) {
            MemberInfo currentMember = (MemberInfo)this.members.get(i);
            Class pmJavaClass = null;
            QName pmXmlType = null;
            String pmName = null;
            if (i < pmsize) {
                ParameterMemberInfo pmInfo = pmemberInfos[i];
                pmJavaClass = pmInfo.getMemberJavaClass();
                pmXmlType = pmInfo.getMemberXmlType();
                pmName = pmInfo.getMemberName();
            }
            if (currentMember.javaType == pmJavaClass && currentMember.name.getLocalPart().equalsIgnoreCase(pmName)) {
                if (pmXmlType != null) {
                    currentMember.xmlType = pmXmlType;
                }
                currentMember.name = new QName("", pmName);
            }
            if (currentMember.serializer == null) {
                Class<?> javaType = instance.getClass();
                currentMember.serializer = (JAXRPCSerializer)this.registry.getSerializer(this.encodingStyle, javaType, currentMember.xmlType);
            }
            currentMember.serializer.serialize(currentMember.getter.get(instance), currentMember.name, null, writer, context);
        }
    }

    protected Object doDeserialize(SOAPDeserializationState state, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object instance = this.targetClass.newInstance();
        ParameterMemberInfo[] pmemberInfos = ((DynamicInternalTypeMappingRegistry)this.registry).getDynamicRegistryMembers(this.targetClass, this.type, "");
        int msize = this.members.size();
        int pmsize = 0;
        if (pmemberInfos != null) {
            pmsize = pmemberInfos.length;
        }
        this.members = this.memberOrder == null || this.memberOrder.size() == 0 ? this.getMemberOrder(instance, this.members) : this.checkFieldCase(this.members);
        SOAPGenericObjectInstanceBuilder builder = null;
        boolean isComplete = true;
        int lastMemberIndex = this.members.size();
        reader.nextElementContent();
        block0: for (int memberCount = 0; memberCount < lastMemberIndex; ++memberCount) {
            int memberIndex = memberCount;
            do {
                Class pmJavaClass = null;
                QName pmXmlType = null;
                String pmName = null;
                if (memberIndex < pmsize) {
                    ParameterMemberInfo pmInfo = pmemberInfos[memberIndex];
                    pmJavaClass = pmInfo.getMemberJavaClass();
                    pmXmlType = pmInfo.getMemberXmlType();
                    pmName = pmInfo.getMemberName();
                }
                QName elementName = reader.getName();
                MemberInfo currentMember = (MemberInfo)this.members.get(memberIndex);
                if (currentMember.javaType == pmJavaClass && currentMember.name.getLocalPart().equalsIgnoreCase(pmName)) {
                    if (pmXmlType != null) {
                        currentMember.xmlType = pmXmlType;
                    }
                    if (pmName != null) {
                        currentMember.name = new QName("", pmName);
                    }
                }
                int i = 0;
                while (reader.getState() == 2 && i < lastMemberIndex) {
                    reader.nextElementContent();
                }
                if (reader.getState() != 1) continue;
                if (currentMember.serializer != null && currentMember.javaType.isArray()) {
                    currentMember.name = ((LiteralObjectSerializerBase)currentMember.serializer).getXmlType();
                }
                if (reader.getName().equals(currentMember.name)) {
                    Object member;
                    if (currentMember.deserializer == null) {
                        QName xmlType = currentMember.xmlType != null ? currentMember.xmlType : SerializerBase.getType(reader);
                        currentMember.deserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
                    }
                    if ((member = currentMember.deserializer.deserialize(currentMember.name, reader, context)) instanceof SOAPDeserializationState) {
                        if (builder == null) {
                            builder = new SOAPGenericObjectInstanceBuilder(instance);
                        }
                        state = GenericLiteralObjectSerializer.registerWithMemberState(instance, state, member, memberIndex, builder);
                        isComplete = false;
                        continue block0;
                    }
                    currentMember.setter.set(instance, member);
                    continue block0;
                }
                if (memberIndex == lastMemberIndex) {
                    memberIndex = 0;
                    continue;
                }
                ++memberIndex;
            } while (memberIndex < memberCount);
        }
        XMLReaderUtil.verifyReaderState(reader, 2);
        return isComplete ? instance : state;
    }

    protected void verifyType(XMLReader reader) throws Exception {
        QName actualType = GenericLiteralObjectSerializer.getType(reader);
        if (actualType != null) {
            // empty if block
        }
    }

    private List checkFieldCase(List members) {
        for (String name : this.memberOrder) {
            for (int i = 0; i < members.size(); ++i) {
                MemberInfo info = (MemberInfo)members.get(i);
                if (!name.equalsIgnoreCase(info.name.getLocalPart()) || name.equals(info.name.getLocalPart())) continue;
                String ns = info.name.getNamespaceURI();
                info.name = new QName(ns, name);
                info.xmlType = new QName(ns, name);
            }
        }
        return members;
    }

    protected List getMemberOrder(Object instance, List membersAlphabetically) {
        if (membersAlphabetically == null) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        Class<?> targetClass = instance.getClass();
        int introspectedSize = membersAlphabetically.size();
        Field[] fields = targetClass.getDeclaredFields();
        int flen = fields != null ? fields.length : 0;
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        if (flen < introspectedSize) {
            for (Class<?> superClass = targetClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                ArrayList<Field> superList = null;
                Field[] superFields = superClass.getDeclaredFields();
                if (superFields == null) continue;
                superList = new ArrayList<Field>(Arrays.asList(superFields));
                for (int i = 0; i < superList.size(); ++i) {
                    Field obj = superList.get(i);
                    fieldList.add(i, obj);
                }
            }
        }
        fields = null;
        fields = fieldList.toArray(new Field[fieldList.size()]);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int fieldModifiers = field.getModifiers();
            if (Modifier.isTransient(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
            String name = field.getName();
            members.add(name);
        }
        if (members.size() == 0) {
            return membersAlphabetically;
        }
        ArrayList<MemberInfo> orderedMembers = new ArrayList<MemberInfo>();
        for (int i = 0; i < members.size(); ++i) {
            String name = (String)members.get(i);
            for (int j = 0; j < membersAlphabetically.size(); ++j) {
                MemberInfo info = (MemberInfo)membersAlphabetically.get(j);
                if (!name.equalsIgnoreCase(info.name.getLocalPart())) continue;
                if (!name.equals(info.name.getLocalPart())) {
                    String ns = info.name.getNamespaceURI();
                    info.name = new QName(ns, name);
                    info.xmlType = new QName(ns, name);
                }
                orderedMembers.add(info);
            }
        }
        if (orderedMembers.size() == 0) {
            return membersAlphabetically;
        }
        return orderedMembers;
    }

    private List orderCurrentMembers(List members, ParameterMemberInfo[] pmemberInfos) {
        ArrayList<MemberInfo> newMembers = new ArrayList<MemberInfo>();
        MemberInfo[] memberInfos = members.toArray(new MemberInfo[members.size()]);
        if (memberInfos.length != pmemberInfos.length) {
            return members;
        }
        block0: for (int i = 0; i < pmemberInfos.length; ++i) {
            ParameterMemberInfo pminfo = pmemberInfos[i];
            Class pmJavaClass = pminfo.getMemberJavaClass();
            QName pmXmlType = pminfo.getMemberXmlType();
            String pmName = pminfo.getMemberName();
            for (int j = 0; j < memberInfos.length; ++j) {
                MemberInfo minfo = memberInfos[j];
                if (minfo.javaType != pmJavaClass || !minfo.name.getLocalPart().equalsIgnoreCase(pmName)) continue;
                minfo.xmlType = pmXmlType;
                newMembers.add(minfo);
                continue block0;
            }
        }
        if (newMembers.size() != members.size()) {
            return members;
        }
        return newMembers;
    }

    protected class SOAPGenericObjectInstanceBuilder
    implements SOAPInstanceBuilder {
        Object instance;

        SOAPGenericObjectInstanceBuilder(Object instance) {
            this.instance = instance;
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public void construct() {
        }

        public void setMember(int index, Object memberValue) {
            try {
                ((MemberInfo)GenericLiteralObjectSerializer.this.members.get((int)index)).setter.set(this.instance, memberValue);
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void initialize() {
        }

        public void setInstance(Object instance) {
        }

        public Object getInstance() {
            return this.instance;
        }
    }

    public static class MemberInfo {
        QName name = null;
        QName xmlType = null;
        Class javaType = null;
        JAXRPCSerializer serializer = null;
        JAXRPCDeserializer deserializer = null;
        GetterMethod getter = null;
        SetterMethod setter = null;
    }

    public static interface SetterMethod {
        public void set(Object var1, Object var2) throws Exception;
    }

    public static interface GetterMethod {
        public Object get(Object var1) throws Exception;
    }
}

