/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.MessageLayout;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout
extends PolicyAssertion
implements SecurityAssertionValidator {
    MessageLayout ml;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean populated = false;

    public Layout() {
    }

    public Layout(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
    }

    public MessageLayout getMessageLayout() {
        this.populate();
        return this.ml;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isLax(assertion)) {
                    this.ml = MessageLayout.Lax;
                    continue;
                }
                if (PolicyUtil.isLaxTsFirst(assertion)) {
                    this.ml = MessageLayout.LaxTsFirst;
                    continue;
                }
                if (PolicyUtil.isLaxTsLast(assertion)) {
                    this.ml = MessageLayout.LaxTsLast;
                    continue;
                }
                if (PolicyUtil.isStrict(assertion)) {
                    this.ml = MessageLayout.Strict;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "Layout");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

