/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class SecurityPolicyValidator
implements PolicyAssertionValidator {
    private static final ArrayList<QName> supportedAssertions = new ArrayList();

    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion policyAssertion) {
        String uri = policyAssertion.getName().getNamespaceURI();
        if (uri.equals("http://schemas.sun.com/2006/03/wss/server") || uri.equals("http://schemas.sun.com/ws/2006/05/trust/server")) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        if (policyAssertion instanceof SecurityAssertionValidator) {
            SecurityAssertionValidator.AssertionFitness fitness = ((SecurityAssertionValidator)((Object)policyAssertion)).validate(false);
            if (fitness == SecurityAssertionValidator.AssertionFitness.IS_VALID) {
                return PolicyAssertionValidator.Fitness.SUPPORTED;
            }
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        if (supportedAssertions.contains(policyAssertion.getName())) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion policyAssertion) {
        String uri = policyAssertion.getName().getNamespaceURI();
        if (uri.equals("http://schemas.sun.com/2006/03/wss/client") || uri.equals("http://schemas.sun.com/2006/03/wss/client") || uri.equals("http://schemas.sun.com/ws/2006/05/sc/client") || uri.equals("http://schemas.sun.com/ws/2006/05/trust/client")) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        if (policyAssertion instanceof SecurityAssertionValidator) {
            return ((SecurityAssertionValidator)((Object)policyAssertion)).validate(true) == SecurityAssertionValidator.AssertionFitness.IS_VALID ? PolicyAssertionValidator.Fitness.SUPPORTED : PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        if (supportedAssertions.contains(policyAssertion.getName())) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }

    public String[] declareSupportedDomains() {
        return new String[]{"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "http://schemas.xmlsoap.org/ws/2005/02/trust", "http://schemas.sun.com/2006/03/wss/client", "http://schemas.sun.com/2006/03/wss/server", "http://schemas.sun.com/ws/2006/05/sc/client"};
    }

    static {
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "CanonicalizationAlgorithm"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic256"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic192"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic128"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TripleDes"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic256Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic192Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic192Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TripleDesRsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic256Sha256"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic256Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic192Sha256"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic128Sha256"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic192Sha256"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TripleDesSha256"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic256Sha256Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic192Sha256Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Basic128Sha256Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "TripleDesSha256Rsa15"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "InclusiveC14N"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "InclusiveC14NWithComments"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "ExclusiveC14NWithComments"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "InclusiveC14NWithComments"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "ExclusiveC14NWithComments"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "STRTransform10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "XPathFilter20"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Strict"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Lax"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "LaxTsFirst"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "LaxTsLast"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeTimestamp"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "EncryptBeforeSigning"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "EncryptSignature"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "ProtectTokens"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "OnlySignEntireHeadersAndBody"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Body"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "XPath"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssUsernameToken10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssUsernameToken11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "Issuer"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequestSecurityTokenTemplate"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireDerivedKeys"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireExternalReference"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireInternalReference"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireKeyIdentifierReference"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireIssuerSerialReference"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireEmbeddedTokenReference"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireThumbprintReference"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509V1Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509V3Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509Pkcs7Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509PkiPathV1Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509V1Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509V3Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509Pkcs7Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssX509PkiPathV1Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssKerberosV5ApReqToken11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssGssKerberosV5ApReqToken11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "SC10SecurityContextToken"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV10Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV11Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV10Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV11Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV20Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssRelV10Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssRelV20Token10"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssRelV10Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssRelV20Token11"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "SupportingTokens"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "SignedSupportingTokens"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "EndorsingSupportingTokens"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "SignedEndorsingSupportingTokens"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefKeyIdentifier"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefIssuerSerial"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefExternalURI"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefEmbeddedToken"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefKeyIdentifier"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefIssuerSerial"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefExternalURI"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefEmbeddedToken"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefThumbprint"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportRefEncryptedKey"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportClientChallenge"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportServerChallenge"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireClientEntropy"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "RequireServerEntropy"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "MustSupportIssuedTokens"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "NoPassword"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestSecurityToken"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestType"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "TokenType"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "AuthenticationType"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "OnBehalfOf"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "KeyType"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "KeySize"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "SignatureAlgorithm"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "EncryptionAlgorithm"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "CanonicalizationAlgorithm"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "ComputedKeyAlgorithm"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Encryption"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "ProofEncryption"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "UseKey"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "SignWith"));
        supportedAssertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "EncryptWith"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "DisableStreamingSecurity"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "DisableStreamingSecurity"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "EncryptHeaderContent"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "EncryptHeaderContent"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "DisableInclusivePrefixList"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "DisableInclusivePrefixList"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "DisablePayloadBuffering"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "DisablePayloadBuffering"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "KeyStore"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "TrustStore"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "KeyStore"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "TrustStore"));
        supportedAssertions.add(new QName("http://schemas.sun.com/ws/2006/05/sc/client", "SCClientConfiguration"));
        supportedAssertions.add(new QName("http://schemas.sun.com/ws/2006/05/trust/client", "PreconfiguredSTS"));
        supportedAssertions.add(new QName("http://schemas.sun.com/ws/2006/05/trust/server", "STSConfiguration"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "CertStore"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "CertStore"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/client", "BSP10"));
        supportedAssertions.add(new QName("http://schemas.sun.com/2006/03/wss/server", "BSP10"));
    }
}

