/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.util;

import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.secconv.WSSCElementFactory;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.WSTrustSOAPFaultException;
import com.sun.xml.ws.security.trust.impl.bindings.AttributedURI;
import com.sun.xml.ws.security.trust.impl.bindings.EndpointReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPFault;

public class WSTrustUtil {
    public static final String MEX_NS = "http://schemas.xmlsoap.org/ws/2004/09/mex";
    public static final String Metadata = "Metadata";
    public static final String MetadataSection = "MetadataSection";
    public static final String MetadataReference = "MetadataReference";

    private WSTrustUtil() {
    }

    public static SOAPFault createSOAP11Fault(WSTrustSOAPFaultException sfex) {
        throw new UnsupportedOperationException("To Do");
    }

    public static SOAPFault createSOAP12Fault(WSTrustSOAPFaultException sfex) {
        throw new UnsupportedOperationException("To Do");
    }

    public static byte[] generateRandomSecret(int keySize) {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[keySize];
        random.nextBytes(secret);
        return secret;
    }

    public static SecurityContextToken createSecurityContextToken(WSSCElementFactory eleFac) throws WSSecureConversationException {
        URI idURI;
        String identifier = "urn:uuid:" + UUID.randomUUID().toString();
        try {
            idURI = new URI(identifier);
        }
        catch (URISyntaxException ex) {
            throw new WSSecureConversationException(ex.getMessage(), ex);
        }
        String wsuId = "uuid-" + UUID.randomUUID().toString();
        return eleFac.createSecurityContextToken(idURI, null, wsuId);
    }

    public static AppliesTo createAppliesTo(String appliesTo) {
        AttributedURI uri = new AttributedURI();
        uri.setValue(appliesTo);
        EndpointReference epr = new EndpointReference();
        epr.setAddress(uri);
        AppliesTo applTo = new ObjectFactory().createAppliesTo();
        applTo.getAny().add(new com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory().createEndpointReference(epr));
        return applTo;
    }

    public static String getAppliesToURI(AppliesTo appliesTo) {
        List<Object> list = appliesTo.getAny();
        EndpointReference epr = null;
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                AttributedURI uri;
                JAXBElement ele;
                String local;
                Object obj = list.get(i);
                if (obj instanceof EndpointReference) {
                    epr = (EndpointReference)obj;
                } else if (obj instanceof JAXBElement && (local = (ele = (JAXBElement)obj).getName().getLocalPart()).equalsIgnoreCase("EndpointReference")) {
                    epr = (EndpointReference)ele.getValue();
                }
                if (epr == null || (uri = epr.getAddress()) == null) continue;
                return uri.getValue();
            }
        }
        return null;
    }

    public static boolean isMetadata(PolicyAssertion assertion) {
        if (!WSTrustUtil.isMEXNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals(Metadata);
    }

    public static boolean isMEXNS(PolicyAssertion assertion) {
        return MEX_NS.equals(assertion.getName().getNamespaceURI());
    }

    public static boolean isMetadataSection(PolicyAssertion assertion) {
        if (!WSTrustUtil.isMEXNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals(MetadataSection);
    }

    public static boolean isMetadataReference(PolicyAssertion assertion) {
        if (!WSTrustUtil.isMEXNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals(MetadataReference);
    }

    public static boolean isAddressingMetadata(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals(Metadata);
    }
}

