/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServletEndpointContext;
import javax.xml.ws.WebServiceContext;

public class SubjectAccessor {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private static ThreadLocal<Subject> wssThreadCtx = new ThreadLocal();

    public static Subject getRequesterSubject(Object context) throws XWSSecurityException {
        if (context instanceof ProcessingContext) {
            return (Subject)((ProcessingContext)context).getExtraneousProperty("javax.security.auth.Subject");
        }
        if (context instanceof ServletEndpointContext) {
            MessageContext msgContext = ((ServletEndpointContext)context).getMessageContext();
            if (msgContext != null) {
                Subject subject = (Subject)msgContext.getProperty("javax.security.auth.Subject");
                return subject;
            }
            return null;
        }
        if (context instanceof javax.xml.ws.handler.MessageContext) {
            javax.xml.ws.handler.MessageContext msgContext = (javax.xml.ws.handler.MessageContext)context;
            Subject subject = (Subject)msgContext.get((Object)"javax.security.auth.Subject");
            return subject;
        }
        try {
            if (context instanceof WebServiceContext) {
                WebServiceContext wsCtx = (WebServiceContext)context;
                javax.xml.ws.handler.MessageContext msgContext = wsCtx.getMessageContext();
                if (msgContext != null) {
                    Subject subject = (Subject)msgContext.get((Object)"javax.security.auth.Subject");
                    return subject;
                }
                return null;
            }
        }
        catch (NoClassDefFoundError ncde) {
            log.log(Level.SEVERE, "WSS0761.context.not.instanceof.servletendpointcontext");
            throw new XWSSecurityException("'context' argument is not an instanceof ServletEndpointContext, WebServiceContext or com.sun.xml.wss.ProcessingContext");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WSS0761.context.not.instanceof.servletendpointcontext");
            throw new XWSSecurityException("'context' argument is not an instanceof ServletEndpointContext, WebServiceContext or com.sun.xml.wss.ProcessingContext");
        }
        return null;
    }

    public static Subject getRequesterSubject() {
        return wssThreadCtx.get();
    }

    public static void setRequesterSubject(Subject sub) {
        wssThreadCtx.set(sub);
    }
}

