/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.jaxws.impl;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLInput;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOutput;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.assembler.PipeConfiguration;
import com.sun.xml.ws.message.stream.LazyStreamBasedMessage;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicyMerger;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelTranslator;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelUnmarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.policy.CallbackHandler;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.SCTokenWrapper;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyGenerator;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityRecipient;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.AsymmetricBinding;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.CallbackHandlerConfiguration;
import com.sun.xml.ws.security.policy.CertStoreConfig;
import com.sun.xml.ws.security.policy.KeyStore;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.policy.TrustStore;
import com.sun.xml.ws.security.policy.Validator;
import com.sun.xml.ws.security.policy.ValidatorConfiguration;
import com.sun.xml.ws.security.policy.WSSAssertion;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.NewSecurityRecipient;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.jaxws.impl.RMPolicyResolver;
import com.sun.xml.wss.jaxws.impl.logging.LogStringsMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityPipeBase
implements Pipe {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.jaxws.impl", "com.sun.xml.wss.jaxws.impl.logging.LogStrings");
    protected Pipe nextPipe;
    protected boolean optimized = true;
    protected boolean transportOptimization = false;
    protected Hashtable<String, IssuedTokenContext> issuedTokenContextMap = new Hashtable();
    protected PipeConfiguration pipeConfig = null;
    protected static final JAXBContext jaxbContext;
    protected boolean disablePayloadBuffer = false;
    protected AlgorithmSuite bindingLevelAlgSuite = null;
    private final QName optServerSecurity = new QName("http://schemas.sun.com/2006/03/wss/server", "DisableStreamingSecurity");
    private final QName optClientSecurity = new QName("http://schemas.sun.com/2006/03/wss/client", "DisableStreamingSecurity");
    private final QName disableSPBuffering = new QName("http://schemas.sun.com/2006/03/wss/server", "DisablePayloadBuffering");
    private final QName disableCPBuffering = new QName("http://schemas.sun.com/2006/03/wss/client", "DisablePayloadBuffering");
    protected boolean disableIncPrefix = false;
    private final QName disableIncPrefixServer = new QName("http://schemas.sun.com/2006/03/wss/server", "DisableInclusivePrefixList");
    private final QName disableIncPrefixClient = new QName("http://schemas.sun.com/2006/03/wss/client", "DisableInclusivePrefixList");
    protected boolean encHeaderContent = false;
    private final QName encHeaderContentServer = new QName("http://schemas.sun.com/2006/03/wss/server", "EncryptHeaderContent");
    private final QName encHeaderContentClient = new QName("http://schemas.sun.com/2006/03/wss/client", "EncryptHeaderContent");
    private final QName bsp10Server = new QName("http://schemas.sun.com/2006/03/wss/server", "BSP10");
    private final QName bsp10Client = new QName("http://schemas.sun.com/2006/03/wss/client", "BSP10");
    protected boolean bsp10 = false;
    protected static final ArrayList<String> securityPolicyNamespaces;
    protected static final List<PolicyAssertion> EMPTY_LIST;
    protected SecurityEnvironment secEnv = null;
    protected static final boolean debug;
    protected boolean isSOAP12 = false;
    protected SOAPVersion soapVersion = null;
    protected SOAPFactory soapFactory = null;
    protected PolicyMap wsPolicyMap = null;
    protected HashMap<WSDLBoundOperation, SecurityPolicyHolder> outMessagePolicyMap = null;
    protected HashMap<WSDLBoundOperation, SecurityPolicyHolder> inMessagePolicyMap = null;
    protected HashMap<String, SecurityPolicyHolder> outProtocolPM = null;
    protected HashMap<String, SecurityPolicyHolder> inProtocolPM = null;
    public static final URI ISSUE_REQUEST_URI;
    public static final URI CANCEL_REQUEST_URI;
    protected Policy bpMSP = null;
    protected long timestampTimeOut = 0L;
    protected WSDLBoundOperation cachedOperation = null;
    protected Policy wsitConfig = null;
    protected Marshaller marshaller = null;
    protected Unmarshaller unmarshaller = null;
    boolean hasIssuedTokens = false;
    boolean hasSecureConversation = false;
    boolean hasReliableMessaging = false;
    AddressingVersion addVer = null;

    public SecurityPipeBase(PipeConfiguration config, Pipe nextPipe) {
        this.nextPipe = nextPipe;
        this.pipeConfig = config;
        this.inMessagePolicyMap = new HashMap();
        this.outMessagePolicyMap = new HashMap();
        this.soapVersion = this.pipeConfig.getBinding().getSOAPVersion();
        this.isSOAP12 = this.soapVersion == SOAPVersion.SOAP_12;
        this.wsPolicyMap = this.pipeConfig.getPolicyMap();
        this.soapFactory = this.pipeConfig.getBinding().getSOAPVersion().saajSoapFactory;
        this.inProtocolPM = new HashMap();
        this.outProtocolPM = new HashMap();
        try {
            this.marshaller = jaxbContext.createMarshaller();
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0001_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0001_PROBLEM_MAR_UNMAR(), ex);
        }
        if (this.wsPolicyMap != null) {
            this.collectPolicies();
        }
        this.hasReliableMessaging = this.isReliableMessagingEnabled(this.wsPolicyMap, this.pipeConfig.getWSDLModel());
    }

    protected SecurityPipeBase(SecurityPipeBase that) {
        this.nextPipe = that.nextPipe;
        this.pipeConfig = that.pipeConfig;
        this.transportOptimization = that.transportOptimization;
        this.optimized = that.optimized;
        this.disableIncPrefix = that.disableIncPrefix;
        this.encHeaderContent = that.encHeaderContent;
        this.issuedTokenContextMap = that.issuedTokenContextMap;
        this.secEnv = that.secEnv;
        this.isSOAP12 = that.isSOAP12;
        this.soapVersion = that.soapVersion;
        this.soapFactory = that.soapFactory;
        this.addVer = that.addVer;
        this.wsPolicyMap = that.wsPolicyMap;
        this.outMessagePolicyMap = that.outMessagePolicyMap;
        this.inMessagePolicyMap = that.inMessagePolicyMap;
        this.bindingLevelAlgSuite = that.bindingLevelAlgSuite;
        this.inProtocolPM = that.inProtocolPM;
        this.outProtocolPM = that.outProtocolPM;
        this.hasIssuedTokens = that.hasIssuedTokens;
        this.hasSecureConversation = that.hasSecureConversation;
        this.hasReliableMessaging = that.hasReliableMessaging;
        this.timestampTimeOut = that.timestampTimeOut;
        try {
            this.marshaller = jaxbContext.createMarshaller();
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0001_PROBLEM_MAR_UNMAR(), ex);
            throw new RuntimeException("Problem creating JAXB Marshaller/Unmarshaller", ex);
        }
    }

    protected SOAPMessage secureOutboundMessage(SOAPMessage message, ProcessingContext ctx) {
        try {
            ctx.setSOAPMessage(message);
            SecurityAnnotator.secureMessage(ctx);
            return ctx.getSOAPMessage();
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe);
        }
    }

    protected RuntimeException generateInternalError(PolicyException ex) {
        SOAPFault fault = null;
        try {
            if (this.isSOAP12) {
                fault = this.soapFactory.createFault(ex.getMessage(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(MessageConstants.WSSE_INTERNAL_SERVER_ERROR);
            } else {
                fault = this.soapFactory.createFault(ex.getMessage(), MessageConstants.WSSE_INTERNAL_SERVER_ERROR);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0002_INTERNAL_SERVER_ERROR(), e);
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0002_INTERNAL_SERVER_ERROR(), e);
        }
        return new SOAPFaultException(fault);
    }

    protected Message secureOutboundMessage(Message message, ProcessingContext ctx) {
        try {
            JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
            context.setSOAPVersion(this.soapVersion);
            context.setJAXWSMessage(message, this.soapVersion);
            context.isOneWayMessage(message.isOneWay(this.pipeConfig.getWSDLModel()));
            context.setDisableIncPrefix(this.disableIncPrefix);
            context.setEncHeaderContent(this.encHeaderContent);
            context.setBSP(this.bsp10);
            SecurityAnnotator.secureMessage(context);
            return context.getJAXWSMessage();
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe);
        }
    }

    protected SOAPMessage verifyInboundMessage(SOAPMessage message, ProcessingContext ctx) throws WssSoapFaultException, XWSSecurityException {
        try {
            ctx.setSOAPMessage(message);
            if (debug) {
                DumpFilter.process(ctx);
            }
            NewSecurityRecipient.validateMessage(ctx);
            return ctx.getSOAPMessage();
        }
        catch (WssSoapFaultException soapFaultException) {
            throw this.getSOAPFaultException(soapFaultException);
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            throw this.getSOAPFaultException(wsfe);
        }
    }

    protected Message verifyInboundMessage(Message message, ProcessingContext ctx) throws XWSSecurityException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
        context.setDisablePayloadBuffering(this.disablePayloadBuffer);
        context.setDisableIncPrefix(this.disableIncPrefix);
        context.setEncHeaderContent(this.encHeaderContent);
        context.setBSP(this.bsp10);
        if (debug) {
            try {
                ((LazyStreamBasedMessage)message).print();
            }
            catch (XMLStreamException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0003_PROBLEM_PRINTING_MSG(), ex);
                throw new XWSSecurityException(LogStringsMessages.WSSPIPE_0003_PROBLEM_PRINTING_MSG(), ex);
            }
        }
        SecurityRecipient recipient = new SecurityRecipient(((LazyStreamBasedMessage)message).readMessage(), this.soapVersion);
        return recipient.validateMessage(context);
    }

    public void setNextPipe(Pipe pipe) {
        this.nextPipe = pipe;
    }

    protected List<PolicyAssertion> getIssuedTokenPoliciesFromBootstrapPolicy(Token scAssertion) {
        SCTokenWrapper token = (SCTokenWrapper)scAssertion;
        return token.getIssuedTokens();
    }

    protected MessagePolicy getOutgoingXWSSecurityPolicy(Packet packet, boolean isSCMessage) {
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            return this.getOutgoingXWSBootstrapPolicy(scToken);
        }
        Message message = packet.getMessage();
        WSDLBoundOperation operation = null;
        operation = this.isTrustMessage(packet) ? this.getWSDLOpFromAction(packet, false) : message.getOperation(this.pipeConfig.getWSDLModel());
        MessagePolicy mp = null;
        if (this.outMessagePolicyMap == null) {
            return new MessagePolicy();
        }
        SecurityPolicyHolder sph = this.outMessagePolicyMap.get(operation);
        if (sph == null) {
            return new MessagePolicy();
        }
        mp = sph.getMessagePolicy();
        return mp;
    }

    protected WSDLBoundOperation getOperation(Message message) {
        if (this.cachedOperation == null) {
            this.cachedOperation = message.getOperation(this.pipeConfig.getWSDLModel());
        }
        return this.cachedOperation;
    }

    protected MessagePolicy getInboundXWSBootstrapPolicy(Token scAssertion) {
        return ((SCTokenWrapper)scAssertion).getMessagePolicy();
    }

    protected MessagePolicy getOutgoingXWSBootstrapPolicy(Token scAssertion) {
        return ((SCTokenWrapper)scAssertion).getMessagePolicy();
    }

    protected ProcessingContext initializeInboundProcessingContext(Packet packet) {
        ProcessingContextImpl ctx = null;
        if (this.optimized) {
            ctx = new JAXBFilterProcessingContext(packet.invocationProperties);
            ((JAXBFilterProcessingContext)ctx).setAddressingVersion(this.addVer);
            ((JAXBFilterProcessingContext)ctx).setSOAPVersion(this.soapVersion);
            ((JAXBFilterProcessingContext)ctx).setSecure(packet.wasTransportSecure);
            ((JAXBFilterProcessingContext)ctx).setBSP(this.bsp10);
        } else {
            ctx = new ProcessingContextImpl(packet.invocationProperties);
        }
        ctx.setTimestampTimeout(this.timestampTimeOut);
        ctx.setIssuedTokenContextMap(this.issuedTokenContextMap);
        ctx.setAlgorithmSuite(this.getAlgoSuite(this.getBindingAlgorithmSuite(packet)));
        ctx.hasIssuedToken(this.bindingHasIssuedTokenPolicy());
        ctx.setSecurityEnvironment(this.secEnv);
        ctx.isInboundMessage(true);
        return ctx;
    }

    protected boolean bindingHasIssuedTokenPolicy() {
        return this.hasIssuedTokens;
    }

    protected boolean bindingHasSecureConversationPolicy() {
        return this.hasSecureConversation;
    }

    protected boolean bindingHasRMPolicy() {
        return this.hasReliableMessaging;
    }

    protected ProcessingContext initializeOutgoingProcessingContext(Packet packet, boolean isSCMessage) {
        ProcessingContextImpl ctx = null;
        if (this.optimized) {
            ctx = new JAXBFilterProcessingContext(packet.invocationProperties);
            ((JAXBFilterProcessingContext)ctx).setAddressingVersion(this.addVer);
            ((JAXBFilterProcessingContext)ctx).setSOAPVersion(this.soapVersion);
            ((JAXBFilterProcessingContext)ctx).setBSP(this.bsp10);
        } else {
            ctx = new ProcessingContextImpl(packet.invocationProperties);
        }
        ctx.setIssuedTokenContextMap(this.issuedTokenContextMap);
        ctx.setAlgorithmSuite(this.getAlgoSuite(this.getBindingAlgorithmSuite(packet)));
        try {
            MessagePolicy policy = null;
            if (this.isRMMessage(packet)) {
                SecurityPolicyHolder holder = this.outProtocolPM.get("RM");
                policy = holder.getMessagePolicy();
            } else if (this.isSCCancel(packet)) {
                SecurityPolicyHolder holder = this.outProtocolPM.get("SC");
                policy = holder.getMessagePolicy();
            } else {
                policy = this.getOutgoingXWSSecurityPolicy(packet, isSCMessage);
            }
            if (debug) {
                policy.dumpMessages(true);
            }
            if (policy.getAlgorithmSuite() != null) {
                ctx.setAlgorithmSuite(policy.getAlgorithmSuite());
            }
            ctx.setWSSAssertion(policy.getWSSAssertion());
            ctx.setSecurityPolicy(policy);
            ctx.setSecurityEnvironment(this.secEnv);
            ctx.isInboundMessage(false);
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0006_PROBLEM_INIT_OUT_PROC_CONTEXT(), e);
        }
        return ctx;
    }

    protected SOAPFault getSOAPFault(WssSoapFaultException sfe) {
        SOAPFault fault = null;
        try {
            if (this.isSOAP12) {
                fault = this.soapFactory.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = this.soapFactory.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0002_INTERNAL_SERVER_ERROR());
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0002_INTERNAL_SERVER_ERROR(), e);
        }
        return fault;
    }

    protected SOAPFaultException getSOAPFaultException(WssSoapFaultException sfe) {
        SOAPFault fault = null;
        try {
            if (this.isSOAP12) {
                fault = this.soapFactory.createFault(sfe.getFaultString(), SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(sfe.getFaultCode());
            } else {
                fault = this.soapFactory.createFault(sfe.getFaultString(), sfe.getFaultCode());
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0002_INTERNAL_SERVER_ERROR());
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0002_INTERNAL_SERVER_ERROR(), e);
        }
        return new SOAPFaultException(fault);
    }

    protected SOAPFaultException getSOAPFaultException(XWSSecurityException xwse) {
        QName qname = null;
        qname = xwse.getCause() instanceof PolicyViolationException ? MessageConstants.WSSE_RECEIVER_POLICY_VIOLATION : MessageConstants.WSSE_FAILED_AUTHENTICATION;
        WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(qname, xwse.getMessage(), xwse);
        return this.getSOAPFaultException(wsfe);
    }

    protected void collectPolicies() {
        try {
            if (this.wsPolicyMap == null) {
                return;
            }
            QName serviceName = this.pipeConfig.getWSDLModel().getOwner().getName();
            QName portName = this.pipeConfig.getWSDLModel().getName();
            PolicyMerger policyMerge = PolicyMerger.getMerger();
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
            Policy endpointPolicy = this.wsPolicyMap.getEndpointEffectivePolicy(endpointKey);
            if (endpointPolicy != null) {
                if (endpointPolicy.contains(AddressingVersion.W3C.policyNsUri)) {
                    this.addVer = AddressingVersion.W3C;
                } else if (endpointPolicy.contains(AddressingVersion.MEMBER.policyNsUri)) {
                    this.addVer = AddressingVersion.MEMBER;
                }
                if (endpointPolicy.contains(this.optServerSecurity) || endpointPolicy.contains(this.optClientSecurity)) {
                    this.optimized = false;
                }
                if (endpointPolicy.contains(this.disableCPBuffering) || endpointPolicy.contains(this.disableSPBuffering)) {
                    this.disablePayloadBuffer = true;
                }
                if (endpointPolicy.contains(this.disableIncPrefixServer) || endpointPolicy.contains(this.disableIncPrefixClient)) {
                    this.disableIncPrefix = true;
                }
                if (endpointPolicy.contains(this.encHeaderContentServer) || endpointPolicy.contains(this.encHeaderContentClient)) {
                    this.encHeaderContent = true;
                }
            }
            if (endpointPolicy.contains(this.bsp10Client) || endpointPolicy.contains(this.bsp10Server)) {
                this.bsp10 = true;
            }
            this.buildProtocolPolicy(endpointPolicy);
            ArrayList<Policy> policyList = new ArrayList<Policy>();
            if (endpointPolicy != null) {
                policyList.add(endpointPolicy);
            }
            for (WSDLBoundOperation wSDLBoundOperation : this.pipeConfig.getWSDLModel().getBinding().getBindingOperations()) {
                QName operationName = wSDLBoundOperation.getName();
                WSDLOperation wsdlOperation = wSDLBoundOperation.getOperation();
                WSDLInput input = wsdlOperation.getInput();
                WSDLOutput output = wsdlOperation.getOutput();
                QName inputMessageName = input.getMessage().getName();
                QName outputMessageName = null;
                if (output != null) {
                    outputMessageName = output.getMessage().getName();
                }
                PolicyMapKey messageKey = PolicyMap.createWsdlMessageScopeKey(serviceName, portName, operationName);
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(serviceName, portName, operationName);
                Policy operationPolicy = this.wsPolicyMap.getOperationEffectivePolicy(operationKey);
                if (operationPolicy != null) {
                    policyList.add(operationPolicy);
                }
                Policy imPolicy = null;
                imPolicy = this.wsPolicyMap.getInputMessageEffectivePolicy(messageKey);
                if (imPolicy != null) {
                    policyList.add(imPolicy);
                }
                Policy imEP = policyMerge.merge(policyList);
                SecurityPolicyHolder outPH = this.addOutgoingMP(wSDLBoundOperation, imEP);
                if (imPolicy != null) {
                    policyList.remove(imPolicy);
                }
                SecurityPolicyHolder inPH = null;
                Policy omPolicy = null;
                omPolicy = this.wsPolicyMap.getOutputMessageEffectivePolicy(messageKey);
                if (omPolicy != null) {
                    policyList.add(omPolicy);
                }
                Policy omEP = policyMerge.merge(policyList);
                if (omPolicy != null) {
                    policyList.remove(omPolicy);
                }
                inPH = this.addIncomingMP(wSDLBoundOperation, omEP);
                Iterator<? extends WSDLFault> faults = wSDLBoundOperation.getOperation().getFaults().iterator();
                ArrayList<Policy> faultPL = new ArrayList<Policy>();
                faultPL.add(endpointPolicy);
                if (operationPolicy != null) {
                    faultPL.add(operationPolicy);
                }
                while (faults.hasNext()) {
                    WSDLFault fault = faults.next();
                    PolicyMapKey fKey = null;
                    fKey = PolicyMap.createWsdlFaultMessageScopeKey(serviceName, portName, operationName, new QName(operationName.getNamespaceURI(), fault.getName()));
                    Policy fPolicy = this.wsPolicyMap.getFaultMessageEffectivePolicy(fKey);
                    if (fPolicy == null) continue;
                    faultPL.add(fPolicy);
                    Policy ep = policyMerge.merge(faultPL);
                    if (inPH != null) {
                        this.addIncomingFaultPolicy(ep, inPH, fault);
                    }
                    if (outPH != null) {
                        this.addOutgoingFaultPolicy(ep, outPH, fault);
                    }
                    faultPL.remove(fPolicy);
                }
            }
        }
        catch (PolicyException pe) {
            throw this.generateInternalError(pe);
        }
    }

    protected List<PolicyAssertion> getInBoundSCP(Message message) {
        if (this.inMessagePolicyMap == null) {
            return Collections.emptyList();
        }
        SecurityPolicyHolder sph = null;
        Collection<SecurityPolicyHolder> coll = this.inMessagePolicyMap.values();
        for (SecurityPolicyHolder ph : coll) {
            if (ph == null) continue;
            sph = ph;
            break;
        }
        if (sph == null) {
            return EMPTY_LIST;
        }
        return sph.getSecureConversationTokens();
    }

    protected List<PolicyAssertion> getOutBoundSCP(Message message) {
        if (this.outMessagePolicyMap == null) {
            return Collections.emptyList();
        }
        SecurityPolicyHolder sph = null;
        Collection<SecurityPolicyHolder> coll = this.outMessagePolicyMap.values();
        for (SecurityPolicyHolder ph : coll) {
            if (ph == null) continue;
            sph = ph;
            break;
        }
        if (sph == null) {
            return EMPTY_LIST;
        }
        return sph.getSecureConversationTokens();
    }

    protected List<PolicyAssertion> getSecureConversationPolicies(Message message, String scope) {
        if (this.outMessagePolicyMap == null) {
            return Collections.emptyList();
        }
        SecurityPolicyHolder sph = null;
        Collection<SecurityPolicyHolder> coll = this.outMessagePolicyMap.values();
        for (SecurityPolicyHolder ph : coll) {
            if (ph == null) continue;
            sph = ph;
            break;
        }
        if (sph == null) {
            return EMPTY_LIST;
        }
        return sph.getSecureConversationTokens();
    }

    protected ArrayList<PolicyAssertion> getTokens(Policy policy) {
        ArrayList<PolicyAssertion> tokenList = new ArrayList<PolicyAssertion>();
        for (AssertionSet assertionSet : policy) {
            for (PolicyAssertion assertion : assertionSet) {
                Binding sb;
                if (PolicyUtil.isAsymmetricBinding(assertion)) {
                    sb = (AsymmetricBinding)((Object)assertion);
                    this.addToken(sb.getInitiatorToken(), tokenList);
                    this.addToken(sb.getRecipientToken(), tokenList);
                    continue;
                }
                if (PolicyUtil.isSymmetricBinding(assertion)) {
                    sb = (SymmetricBinding)((Object)assertion);
                    Token token = sb.getProtectionToken();
                    if (token != null) {
                        this.addToken(token, tokenList);
                        continue;
                    }
                    this.addToken(sb.getEncryptionToken(), tokenList);
                    this.addToken(sb.getSignatureToken(), tokenList);
                    continue;
                }
                if (!PolicyUtil.isSupportingTokens(assertion)) continue;
                SupportingTokens st = (SupportingTokens)((Object)assertion);
                Iterator itr = st.getTokens();
                while (itr.hasNext()) {
                    this.addToken((Token)itr.next(), tokenList);
                }
            }
        }
        return tokenList;
    }

    private void addConfigAssertions(Policy policy, SecurityPolicyHolder sph) {
        for (AssertionSet assertionSet : policy) {
            for (PolicyAssertion assertion : assertionSet) {
                if (!PolicyUtil.isConfigPolicyAssertion(assertion)) continue;
                sph.addConfigAssertions(assertion);
            }
        }
    }

    private void addToken(Token token, ArrayList<PolicyAssertion> list) {
        if (PolicyUtil.isSecureConversationToken((PolicyAssertion)((Object)token)) || PolicyUtil.isIssuedToken((PolicyAssertion)((Object)token))) {
            list.add((PolicyAssertion)((Object)token));
        }
    }

    protected PolicyMapKey getOperationKey(Message message) {
        WSDLBoundOperation operation = message.getOperation(this.pipeConfig.getWSDLModel());
        WSDLOperation wsdlOperation = operation.getOperation();
        QName serviceName = this.pipeConfig.getWSDLModel().getOwner().getName();
        QName portName = this.pipeConfig.getWSDLModel().getName();
        PolicyMapKey messageKey = PolicyMap.createWsdlMessageScopeKey(serviceName, portName, wsdlOperation.getName());
        return messageKey;
    }

    protected abstract SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation var1, Policy var2) throws PolicyException;

    protected abstract SecurityPolicyHolder addIncomingMP(WSDLBoundOperation var1, Policy var2) throws PolicyException;

    protected AlgorithmSuite getBindingAlgorithmSuite(Packet packet) {
        return this.bindingLevelAlgSuite;
    }

    protected void cacheMessage(Packet packet) {
        Message message = null;
        if (!this.optimized) {
            try {
                message = packet.getMessage();
                message = Messages.create(message.readAsSOAPMessage());
                packet.setMessage(message);
            }
            catch (SOAPException se) {
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0005_PROBLEM_PROC_SOAP_MESSAGE(), se);
                throw new WebServiceException(LogStringsMessages.WSSPIPE_0005_PROBLEM_PROC_SOAP_MESSAGE(), (Throwable)se);
            }
        }
    }

    private boolean hasTargets(NestedPolicy policy) {
        AssertionSet as = policy.getAssertionSet();
        boolean foundTargets = false;
        for (PolicyAssertion assertion : as) {
            if (!PolicyUtil.isSignedParts(assertion) && !PolicyUtil.isEncryptParts(assertion)) continue;
            foundTargets = true;
            break;
        }
        return foundTargets;
    }

    protected Policy getEffectiveBootstrapPolicy(NestedPolicy bp) throws PolicyException {
        try {
            ArrayList<Policy> pl = new ArrayList<Policy>();
            pl.add(bp);
            Policy mbp = this.getMessageBootstrapPolicy();
            if (mbp != null) {
                pl.add(mbp);
            }
            PolicyMerger pm = PolicyMerger.getMerger();
            Policy ep = pm.merge(pl);
            return ep;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0007_PROBLEM_GETTING_EFF_BOOT_POLICY(), e);
            throw new PolicyException(LogStringsMessages.WSSPIPE_0007_PROBLEM_GETTING_EFF_BOOT_POLICY(), e);
        }
    }

    private Policy getMessageBootstrapPolicy() throws PolicyException, IOException {
        if (this.bpMSP == null) {
            PolicySourceModel model = this.unmarshalPolicy("com/sun/xml/ws/security/impl/policyconv/boot-msglevel-policy.xml");
            this.bpMSP = PolicyModelTranslator.getTranslator().translate(model);
        }
        return this.bpMSP;
    }

    private Policy getMessageLevelBSP() throws PolicyException {
        QName serviceName = this.pipeConfig.getWSDLModel().getOwner().getName();
        QName portName = this.pipeConfig.getWSDLModel().getName();
        PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(serviceName, portName, Constants.bsOperationName);
        Policy operationLevelEP = this.wsPolicyMap.getOperationEffectivePolicy(operationKey);
        return operationLevelEP;
    }

    protected PolicySourceModel unmarshalPolicy(String resource) throws PolicyException, IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (is == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(is);
        PolicySourceModel model = PolicyModelUnmarshaller.getXmlUnmarshaller().unmarshalModel(reader);
        ((Reader)reader).close();
        return model;
    }

    protected final void cacheOperation(Message msg) {
        this.cachedOperation = msg.getOperation(this.pipeConfig.getWSDLModel());
    }

    protected final void resetCachedOperation() {
        this.cachedOperation = null;
    }

    protected boolean isSCMessage(Packet packet) {
        if (!this.bindingHasSecureConversationPolicy()) {
            return false;
        }
        if (!this.isAddressingEnabled()) {
            return false;
        }
        String action = this.getAction(packet);
        return Constants.rstSCTURI.equals(action);
    }

    protected boolean isSCCancel(Packet packet) {
        if (!this.bindingHasSecureConversationPolicy()) {
            return false;
        }
        if (!this.isAddressingEnabled()) {
            return false;
        }
        String action = this.getAction(packet);
        return "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel".equals(action);
    }

    protected boolean isAddressingEnabled() {
        return this.addVer != null;
    }

    protected boolean isTrustMessage(Packet packet) {
        if (!this.isAddressingEnabled()) {
            return false;
        }
        String action = this.getAction(packet);
        return "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/Issue".equals(action);
    }

    protected boolean isRMMessage(Packet packet) {
        if (!this.isAddressingEnabled()) {
            return false;
        }
        if (!this.bindingHasRMPolicy()) {
            return false;
        }
        String action = this.getAction(packet);
        return "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence".equals(action) || "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(action);
    }

    protected String getAction(Packet packet) {
        HeaderList hl = packet.getMessage().getHeaders();
        String action = hl.getAction(this.addVer, this.pipeConfig.getBinding().getSOAPVersion());
        return action;
    }

    protected WSDLBoundOperation getWSDLOpFromAction(Packet packet, boolean isIncomming) {
        String uriValue = this.getAction(packet);
        Set<WSDLBoundOperation> keys = this.outMessagePolicyMap.keySet();
        for (WSDLBoundOperation wbo : keys) {
            WSDLOperation wo = wbo.getOperation();
            String action = this.getAction(wo, isIncomming);
            if (action == null || !action.equals(uriValue)) continue;
            return wbo;
        }
        return null;
    }

    protected void buildProtocolPolicy(Policy endpointPolicy) throws PolicyException {
        if (endpointPolicy == null) {
            return;
        }
        try {
            RMPolicyResolver rr = new RMPolicyResolver();
            Policy msgLevelPolicy = rr.getOperationLevelPolicy();
            PolicyMerger merger = PolicyMerger.getMerger();
            ArrayList<Policy> pList = new ArrayList<Policy>(2);
            pList.add(endpointPolicy);
            pList.add(msgLevelPolicy);
            Policy effectivePolicy = merger.merge(pList);
            this.addIncomingProtocolPolicy(effectivePolicy, "RM");
            this.addOutgoingProtocolPolicy(effectivePolicy, "RM");
            pList.remove(msgLevelPolicy);
            pList.add(this.getMessageBootstrapPolicy());
            PolicyMerger pm = PolicyMerger.getMerger();
            Policy ep = pm.merge(pList);
            this.addIncomingProtocolPolicy(ep, "SC");
            this.addOutgoingProtocolPolicy(ep, "SC");
        }
        catch (IOException ie) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0008_PROBLEM_BUILDING_PROTOCOL_POLICY(), ie);
            throw new PolicyException(LogStringsMessages.WSSPIPE_0008_PROBLEM_BUILDING_PROTOCOL_POLICY(), ie);
        }
    }

    protected SecurityPolicyHolder constructPolicyHolder(Policy effectivePolicy, boolean isServer, boolean isIncoming) throws PolicyException {
        return this.constructPolicyHolder(effectivePolicy, isServer, isIncoming, false);
    }

    protected SecurityPolicyHolder constructPolicyHolder(Policy effectivePolicy, boolean isServer, boolean isIncoming, boolean ignoreST) throws PolicyException {
        XWSSPolicyGenerator xwssPolicyGenerator = new XWSSPolicyGenerator(effectivePolicy, isServer, isIncoming);
        xwssPolicyGenerator.process(ignoreST);
        this.bindingLevelAlgSuite = xwssPolicyGenerator.getBindingLevelAlgSuite();
        MessagePolicy messagePolicy = xwssPolicyGenerator.getXWSSPolicy();
        SecurityPolicyHolder sph = new SecurityPolicyHolder();
        sph.setMessagePolicy(messagePolicy);
        sph.setBindingLevelAlgSuite(xwssPolicyGenerator.getBindingLevelAlgSuite());
        ArrayList<PolicyAssertion> tokenList = this.getTokens(effectivePolicy);
        this.addConfigAssertions(effectivePolicy, sph);
        for (PolicyAssertion token : tokenList) {
            if (PolicyUtil.isSecureConversationToken(token)) {
                NestedPolicy bootstrapPolicy = ((SecureConversationToken)((Object)token)).getBootstrapPolicy();
                Policy effectiveBP = null;
                effectiveBP = this.hasTargets(bootstrapPolicy) ? bootstrapPolicy : this.getEffectiveBootstrapPolicy(bootstrapPolicy);
                xwssPolicyGenerator = new XWSSPolicyGenerator(effectiveBP, isServer, isIncoming);
                xwssPolicyGenerator.process(ignoreST);
                MessagePolicy bmp = xwssPolicyGenerator.getXWSSPolicy();
                if (isServer && isIncoming) {
                    EncryptionPolicy optionalPolicy = new EncryptionPolicy();
                    EncryptionPolicy.FeatureBinding fb = (EncryptionPolicy.FeatureBinding)optionalPolicy.getFeatureBinding();
                    optionalPolicy.newX509CertificateKeyBinding();
                    EncryptionTarget target = new EncryptionTarget();
                    target.setQName(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion"));
                    target.setEnforce(false);
                    fb.addTargetBinding(target);
                }
                SCTokenWrapper sct = new SCTokenWrapper(token, bmp);
                sph.addSecureConversationToken(sct);
                this.hasSecureConversation = true;
                List<PolicyAssertion> iList = this.getIssuedTokenPoliciesFromBootstrapPolicy(sct);
                if (iList.isEmpty()) continue;
                this.hasIssuedTokens = true;
                continue;
            }
            if (!PolicyUtil.isIssuedToken(token)) continue;
            sph.addIssuedToken(token);
            this.hasIssuedTokens = true;
        }
        return sph;
    }

    protected String populateConfigProperties(Set configAssertions, Properties props) {
        if (configAssertions == null) {
            return null;
        }
        for (PolicyAssertion as : configAssertions) {
            if ("KeyStore".equals(as.getName().getLocalPart())) {
                this.populateKeystoreProps(props, (KeyStore)((Object)as));
                continue;
            }
            if ("TrustStore".equals(as.getName().getLocalPart())) {
                this.populateTruststoreProps(props, (TrustStore)((Object)as));
                continue;
            }
            if ("CallbackHandlerConfiguration".equals(as.getName().getLocalPart())) {
                String ret = this.populateCallbackHandlerProps(props, (CallbackHandlerConfiguration)((Object)as));
                if (ret == null) continue;
                return ret;
            }
            if ("ValidatorConfiguration".equals(as.getName().getLocalPart())) {
                this.populateValidatorProps(props, (ValidatorConfiguration)((Object)as));
                continue;
            }
            if (!"CertStore".equals(as.getName().getLocalPart())) continue;
            this.populateCertStoreProps(props, (CertStoreConfig)((Object)as));
        }
        return null;
    }

    private void populateKeystoreProps(Properties props, KeyStore store) {
        if (store.getLocation() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0014_KEYSTORE_URL_NULL_CONFIG_ASSERTION());
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0014_KEYSTORE_URL_NULL_CONFIG_ASSERTION());
        }
        props.put("keystore.url", store.getLocation());
        if (store.getType() != null) {
            props.put("keystore.type", store.getType());
        } else {
            props.put("keystore.type", "JKS");
        }
        if (store.getPassword() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0015_KEYSTORE_PASSWORD_NULL_CONFIG_ASSERTION());
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0015_KEYSTORE_PASSWORD_NULL_CONFIG_ASSERTION());
        }
        props.put("keystore.password", new String(store.getPassword()));
        if (store.getAlias() != null) {
            props.put("my.alias", store.getAlias());
        }
        if (store.getKeyPassword() != null) {
            props.put("key.password", store.getKeyPassword());
        }
        if (store.getAliasSelectorClassName() != null) {
            props.put("keystore.certselector", store.getAliasSelectorClassName());
        }
    }

    private void populateTruststoreProps(Properties props, TrustStore store) {
        if (store.getLocation() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0016_TRUSTSTORE_URL_NULL_CONFIG_ASSERTION());
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0016_TRUSTSTORE_URL_NULL_CONFIG_ASSERTION());
        }
        props.put("truststore.url", store.getLocation());
        if (store.getType() != null) {
            props.put("truststore.type", store.getType());
        } else {
            props.put("truststore.type", "JKS");
        }
        if (store.getPassword() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0017_TRUSTSTORE_PASSWORD_NULL_CONFIG_ASSERTION());
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0017_TRUSTSTORE_PASSWORD_NULL_CONFIG_ASSERTION());
        }
        props.put("truststore.password", new String(store.getPassword()));
        if (store.getPeerAlias() != null) {
            props.put("peerentity.alias", store.getPeerAlias());
        }
        if (store.getSTSAlias() != null) {
            props.put("sts.alias", store.getSTSAlias());
        }
        if (store.getServiceAlias() != null) {
            props.put("service.alias", store.getServiceAlias());
        }
        if (store.getCertSelectorClassName() != null) {
            props.put("truststore.certselector", store.getCertSelectorClassName());
        }
    }

    private String populateCallbackHandlerProps(Properties props, CallbackHandlerConfiguration conf) {
        if (conf.getTimestampTimeout() != null) {
            this.timestampTimeOut = Long.parseLong(conf.getTimestampTimeout()) * 1000L;
        }
        Iterator<? extends PolicyAssertion> it = conf.getCallbackHandlers();
        while (it.hasNext()) {
            String def;
            QName qname;
            PolicyAssertion p = it.next();
            CallbackHandler hd = (CallbackHandler)p;
            String name = hd.getHandlerName();
            String ret = hd.getHandler();
            if ("xwssCallbackHandler".equals(name)) {
                if (ret != null && !"".equals(ret)) {
                    return ret;
                }
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0018_NULL_OR_EMPTY_XWSS_CALLBACK_HANDLER_CLASSNAME());
                throw new RuntimeException(LogStringsMessages.WSSPIPE_0018_NULL_OR_EMPTY_XWSS_CALLBACK_HANDLER_CLASSNAME());
            }
            if ("usernameHandler".equals(name)) {
                if (ret != null && !"".equals(ret)) {
                    props.put("username.callback.handler", ret);
                    continue;
                }
                qname = new QName("default");
                def = hd.getAttributeValue(qname);
                if (def != null && !"".equals(def)) {
                    props.put("my.username", def);
                    continue;
                }
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0019_NULL_OR_EMPTY_USERNAME_HANDLER_CLASSNAME());
                throw new RuntimeException(LogStringsMessages.WSSPIPE_0019_NULL_OR_EMPTY_USERNAME_HANDLER_CLASSNAME());
            }
            if ("passwordHandler".equals(name)) {
                if (ret != null && !"".equals(ret)) {
                    props.put("password.callback.handler", ret);
                    continue;
                }
                qname = new QName("default");
                def = hd.getAttributeValue(qname);
                if (def != null && !"".equals(def)) {
                    props.put("my.password", def);
                    continue;
                }
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0020_NULL_OR_EMPTY_PASSWORD_HANDLER_CLASSNAME());
                throw new RuntimeException(LogStringsMessages.WSSPIPE_0020_NULL_OR_EMPTY_PASSWORD_HANDLER_CLASSNAME());
            }
            if ("samlHandler".equals(name)) {
                if (ret == null || "".equals(ret)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0021_NULL_OR_EMPTY_SAML_HANDLER_CLASSNAME());
                    throw new RuntimeException(LogStringsMessages.WSSPIPE_0021_NULL_OR_EMPTY_SAML_HANDLER_CLASSNAME());
                }
                props.put("saml.callback.handler", ret);
                continue;
            }
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0009_UNSUPPORTED_CALLBACK_TYPE_ENCOUNTERED(name));
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0009_UNSUPPORTED_CALLBACK_TYPE_ENCOUNTERED(name));
        }
        return null;
    }

    private void populateValidatorProps(Properties props, ValidatorConfiguration conf) {
        if (conf.getMaxClockSkew() != null) {
            props.put("max.clock.skew", conf.getMaxClockSkew());
        }
        if (conf.getTimestampFreshnessLimit() != null) {
            props.put("timestamp.freshness.limit", conf.getTimestampFreshnessLimit());
        }
        if (conf.getMaxNonceAge() != null) {
            props.put("max.nonce.age", conf.getMaxNonceAge());
        }
        if (conf.getRevocationEnabled() != null) {
            props.put("revocation.enabled", conf.getRevocationEnabled());
        }
        Iterator<? extends PolicyAssertion> it = conf.getValidators();
        while (it.hasNext()) {
            PolicyAssertion p = it.next();
            Validator v = (Validator)((Object)p);
            String name = v.getValidatorName();
            String validator = v.getValidator();
            if (validator == null || "".equals(validator)) {
                log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0022_NULL_OR_EMPTY_VALIDATOR_CLASSNAME(name));
                throw new RuntimeException(LogStringsMessages.WSSPIPE_0022_NULL_OR_EMPTY_VALIDATOR_CLASSNAME(name));
            }
            if ("usernameValidator".equals(name)) {
                props.put("username.validator", validator);
                continue;
            }
            if ("timestampValidator".equals(name)) {
                props.put("timestamp.validator", validator);
                continue;
            }
            if ("certificateValidator".equals(name)) {
                props.put("certificate.validator", validator);
                continue;
            }
            if ("samlAssertionValidator".equals(name)) {
                props.put("saml.validator", validator);
                continue;
            }
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0010_UNKNOWN_VALIDATOR_TYPE_CONFIG(name));
            throw new RuntimeException(LogStringsMessages.WSSPIPE_0010_UNKNOWN_VALIDATOR_TYPE_CONFIG(name));
        }
    }

    private void populateCertStoreProps(Properties props, CertStoreConfig certStoreConfig) {
        if (certStoreConfig.getCallbackHandlerClassName() != null) {
            props.put("certstore.cbh", certStoreConfig.getCallbackHandlerClassName());
        }
        if (certStoreConfig.getCertSelectorClassName() != null) {
            props.put("certstore.certselector", certStoreConfig.getCertSelectorClassName());
        }
        if (certStoreConfig.getCRLSelectorClassName() != null) {
            props.put("certstore.crlselector", certStoreConfig.getCRLSelectorClassName());
        }
    }

    protected Class loadClass(String classname) throws Exception {
        if (classname == null) {
            return null;
        }
        Class<?> ret = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                ret = loader.loadClass(classname);
                return ret;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        loader = this.getClass().getClassLoader();
        try {
            ret = loader.loadClass(classname);
            return ret;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, LogStringsMessages.WSSPIPE_0011_COULD_NOT_FIND_USER_CLASS(), classname);
            throw new XWSSecurityException(LogStringsMessages.WSSPIPE_0011_COULD_NOT_FIND_USER_CLASS());
        }
    }

    protected com.sun.xml.wss.impl.AlgorithmSuite getAlgoSuite(AlgorithmSuite suite) {
        if (suite == null) {
            return null;
        }
        com.sun.xml.wss.impl.AlgorithmSuite als = new com.sun.xml.wss.impl.AlgorithmSuite(suite.getDigestAlgorithm(), suite.getEncryptionAlgorithm(), suite.getSymmetricKeyAlgorithm(), suite.getAsymmetricKeyAlgorithm());
        return als;
    }

    protected com.sun.xml.wss.impl.WSSAssertion getWssAssertion(WSSAssertion asser) {
        com.sun.xml.wss.impl.WSSAssertion assertion = new com.sun.xml.wss.impl.WSSAssertion(asser.getRequiredProperties(), asser.getType());
        return assertion;
    }

    private boolean isReliableMessagingEnabled(PolicyMap policyMap, WSDLPort port) {
        if (policyMap == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(port.getOwner().getName(), port.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            return policy != null && policy.contains("http://schemas.xmlsoap.org/ws/2005/02/rm/policy");
        }
        catch (PolicyException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSPIPE_0012_PROBLEM_CHECKING_RELIABLE_MESSAGE_ENABLE(), e);
            throw new WebServiceException(LogStringsMessages.WSSPIPE_0012_PROBLEM_CHECKING_RELIABLE_MESSAGE_ENABLE(), (Throwable)e);
        }
    }

    protected abstract void addIncomingFaultPolicy(Policy var1, SecurityPolicyHolder var2, WSDLFault var3) throws PolicyException;

    protected abstract void addOutgoingFaultPolicy(Policy var1, SecurityPolicyHolder var2, WSDLFault var3) throws PolicyException;

    protected abstract void addIncomingProtocolPolicy(Policy var1, String var2) throws PolicyException;

    protected abstract void addOutgoingProtocolPolicy(Policy var1, String var2) throws PolicyException;

    protected abstract String getAction(WSDLOperation var1, boolean var2);

    static {
        EMPTY_LIST = Collections.emptyList();
        try {
            debug = Boolean.valueOf(System.getProperty("DebugSecurity"));
            ISSUE_REQUEST_URI = new URI("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue");
            CANCEL_REQUEST_URI = new URI("http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel");
            jaxbContext = WSTrustElementFactory.getContext();
            securityPolicyNamespaces = new ArrayList();
            securityPolicyNamespaces.add(Constants.SECURITY_POLICY_2005_07_NAMESPACE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

