/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.message.stream.LazyStreamBasedMessage;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyHolder;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityRecipient;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.secconv.NewWSSCPlugin;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.trust.TrustPlugin;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.NewSecurityRecipient;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.misc.DefaultCallbackHandler;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.misc.WSITProviderSecurityEnvironment;
import com.sun.xml.wss.jaxws.impl.Constants;
import com.sun.xml.wss.jaxws.impl.PolicyResolverImpl;
import com.sun.xml.wss.provider.wsit.WSITAuthContextBase;
import com.sun.xml.wss.provider.wsit.WSITClientAuthModule;
import com.sun.xml.wss.provider.wsit.logging.LogStringsMessages;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSITClientAuthContext
extends WSITAuthContextBase
implements ClientAuthContext {
    private static TrustPlugin trustPlugin = WSTrustFactory.newTrustPlugin(null);
    private static NewWSSCPlugin scPlugin = WSSCFactory.newNewSCPlugin(null);
    private Set trustConfig = null;
    private CallbackHandler handler = null;
    WSITClientAuthModule authModule = null;

    public WSITClientAuthContext(String operation, Subject subject, Map map) {
        super(map);
        Properties props;
        Iterator it = this.outMessagePolicyMap.values().iterator();
        SecurityPolicyHolder holder = (SecurityPolicyHolder)it.next();
        Set configAssertions = holder.getConfigAssertions("http://schemas.sun.com/2006/03/wss/client");
        this.trustConfig = holder.getConfigAssertions("http://schemas.sun.com/ws/2006/05/trust/client");
        boolean isACC = this.isGFAppClient();
        String isGF = System.getProperty("com.sun.aas.installRoot");
        if (isACC || isGF != null) {
            try {
                props = new Properties();
                this.populateConfigProperties(configAssertions, props);
                String jmacHandler = props.getProperty("jmac.callbackhandler");
                this.handler = this.loadGFHandler(true, jmacHandler);
                this.secEnv = new WSITProviderSecurityEnvironment(this.handler, map, props);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), ex);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0027_ERROR_POPULATING_CLIENT_CONFIG_PROP(), (Throwable)ex);
            }
        } else {
            props = new Properties();
            this.handler = this.configureClientHandler(configAssertions, props);
            this.secEnv = new DefaultSecurityEnvironmentImpl(this.handler, props);
        }
        this.authModule = new WSITClientAuthModule();
        try {
            this.authModule.initialize(null, null, null, map);
        }
        catch (AuthException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0028_ERROR_INIT_AUTH_MODULE(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0028_ERROR_INIT_AUTH_MODULE(), e);
        }
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        try {
            Packet packet = this.getRequestPacket(messageInfo);
            boolean isTrustMsg = false;
            if ("true".equals(packet.invocationProperties.get("isTrustMessage"))) {
                isTrustMsg = true;
                String action = (String)packet.invocationProperties.get("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue");
                HeaderList headers = packet.getMessage().getHeaders();
                headers.fillRequestAddressingHeaders(packet, this.addVer, this.soapVersion, false, action);
            }
            messageInfo.getMap().put("IS_TRUST_MSG", isTrustMsg);
            this.invokeSCPlugin(packet);
            Packet ret = this.secureRequest(packet, clientSubject, false);
            this.setRequestPacket(messageInfo, ret);
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0050_ERROR_SECURE_REQUEST(), e);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0050_ERROR_SECURE_REQUEST(), (Throwable)this.getSOAPFaultException(e));
        }
        return AuthStatus.SEND_SUCCESS;
    }

    public Packet secureRequest(Packet packet, Subject clientSubject, boolean isSCMessage) throws XWSSecurityException {
        Message msg = packet.getMessage();
        this.invokeTrustPlugin(packet, isSCMessage);
        ProcessingContext ctx = this.initializeOutgoingProcessingContext(packet, isSCMessage);
        try {
            if (!this.optimized) {
                if (!isSCMessage) {
                    this.cacheOperation(msg, packet);
                }
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.secureOutboundMessage(soapMessage, ctx);
                msg = Messages.create(soapMessage);
            } else {
                msg = this.secureOutboundMessage(msg, ctx);
            }
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)se);
        }
        packet.setMessage(msg);
        return packet;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        try {
            boolean isTrustMsg;
            Packet ret = this.getResponsePacket(messageInfo);
            if (!this.optimized) {
                try {
                    SOAPMessage sm = ret.getMessage().readAsSOAPMessage();
                    Message newMsg = Messages.create(sm);
                    ret.setMessage(newMsg);
                }
                catch (SOAPException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0033_ERROR_VALIDATE_RESPONSE(), ex);
                    throw new WebServiceException(LogStringsMessages.WSITPVD_0033_ERROR_VALIDATE_RESPONSE(), (Throwable)ex);
                }
            }
            ret = this.validateResponse(ret, clientSubject, serviceSubject);
            this.resetCachedOperation(ret);
            Boolean trustMsgProp = (Boolean)messageInfo.getMap().get("IS_TRUST_MSG");
            boolean bl = isTrustMsg = trustMsgProp != null ? trustMsgProp : false;
            if (isTrustMsg) {
                this.getAction(ret);
            }
            this.setResponsePacket(messageInfo, ret);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0033_ERROR_VALIDATE_RESPONSE(), ex);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0033_ERROR_VALIDATE_RESPONSE(), (Throwable)this.getSOAPFaultException(ex));
        }
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.cancelSecurityContextToken();
        this.issuedTokenContextMap.clear();
    }

    public Packet validateResponse(Packet req, Subject clientSubject, Subject serviceSubject) throws XWSSecurityException {
        ProcessingContext ctx = this.initializeInboundProcessingContext(req);
        ctx.setExtraneousProperty("OperationResolver", new PolicyResolverImpl(this.inMessagePolicyMap, this.inProtocolPM, this.cachedOperation(req), this.pipeConfig, this.addVer, true));
        Message msg = req.getMessage();
        try {
            if (!this.optimized) {
                SOAPMessage soapMessage = msg.readAsSOAPMessage();
                soapMessage = this.verifyInboundMessage(soapMessage, ctx);
                if (msg.isFault()) {
                    if (debug) {
                        DumpFilter.process(ctx);
                    }
                    SOAPFault fault = soapMessage.getSOAPBody().getFault();
                    throw new SOAPFaultException(fault);
                }
                msg = Messages.create(soapMessage);
            } else {
                msg = this.verifyInboundMessage(msg, ctx);
            }
        }
        catch (XWSSecurityException xwse) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), xwse);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(xwse));
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), se);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)se);
        }
        req.setMessage(msg);
        return req;
    }

    @Override
    protected SOAPMessage secureOutboundMessage(SOAPMessage message, ProcessingContext ctx) {
        try {
            ctx.setSOAPMessage(message);
            SecurityAnnotator.secureMessage(ctx);
            return ctx.getSOAPMessage();
        }
        catch (WssSoapFaultException soapFaultException) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), soapFaultException);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(soapFaultException));
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), wsfe);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(wsfe));
        }
    }

    @Override
    protected Message secureOutboundMessage(Message message, ProcessingContext ctx) {
        try {
            JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
            context.setSOAPVersion(this.soapVersion);
            context.setJAXWSMessage(message, this.soapVersion);
            context.isOneWayMessage(message.isOneWay(this.pipeConfig.getWSDLModel()));
            context.setDisableIncPrefix(this.disableIncPrefix);
            context.setEncHeaderContent(this.encHeaderContent);
            SecurityAnnotator.secureMessage(context);
            return context.getJAXWSMessage();
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), wsfe);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0029_ERROR_SECURING_OUTBOUND_MSG(), (Throwable)this.getSOAPFaultException(wsfe));
        }
    }

    protected SOAPMessage verifyInboundMessage(SOAPMessage message, ProcessingContext ctx) throws WssSoapFaultException, XWSSecurityException {
        try {
            ctx.setSOAPMessage(message);
            if (debug) {
                DumpFilter.process(ctx);
            }
            NewSecurityRecipient.validateMessage(ctx);
            return ctx.getSOAPMessage();
        }
        catch (WssSoapFaultException soapFaultException) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), soapFaultException);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(soapFaultException));
        }
        catch (XWSSecurityException xwse) {
            WssSoapFaultException wsfe = SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INTERNAL_SERVER_ERROR, xwse.getMessage(), xwse);
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), wsfe);
            throw new WebServiceException(LogStringsMessages.WSITPVD_0035_ERROR_VERIFY_INBOUND_MSG(), (Throwable)this.getSOAPFaultException(wsfe));
        }
    }

    protected Message verifyInboundMessage(Message message, ProcessingContext ctx) throws XWSSecurityException {
        JAXBFilterProcessingContext context = (JAXBFilterProcessingContext)ctx;
        if (debug) {
            try {
                ((LazyStreamBasedMessage)message).print();
            }
            catch (XMLStreamException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0003_PROBLEM_PRINTING_MSG(), ex);
                throw new XWSSecurityException(LogStringsMessages.WSITPVD_0003_PROBLEM_PRINTING_MSG(), ex);
            }
        }
        SecurityRecipient recipient = new SecurityRecipient(((LazyStreamBasedMessage)message).readMessage(), this.soapVersion);
        return recipient.validateMessage(context);
    }

    @Override
    protected SecurityPolicyHolder addOutgoingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, false);
        this.outMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected SecurityPolicyHolder addIncomingMP(WSDLBoundOperation operation, Policy policy) throws PolicyException {
        SecurityPolicyHolder sph = this.constructPolicyHolder(policy, false, true);
        this.inMessagePolicyMap.put(operation, sph);
        return sph;
    }

    @Override
    protected void addIncomingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.inProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, false, true, true));
    }

    @Override
    protected void addOutgoingProtocolPolicy(Policy effectivePolicy, String protocol) throws PolicyException {
        this.outProtocolPM.put(protocol, this.constructPolicyHolder(effectivePolicy, false, false, true));
    }

    @Override
    protected void addIncomingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, true);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected void addOutgoingFaultPolicy(Policy effectivePolicy, SecurityPolicyHolder sph, WSDLFault fault) throws PolicyException {
        SecurityPolicyHolder faultPH = this.constructPolicyHolder(effectivePolicy, false, false);
        sph.addFaultPolicy(fault, faultPH);
    }

    @Override
    protected String getAction(WSDLOperation operation, boolean inComming) {
        if (!inComming) {
            return operation.getInput().getAction();
        }
        return operation.getOutput().getAction();
    }

    public JAXBElement startSecureConversation(Packet packet) throws WSSecureConversationException {
        List<PolicyAssertion> toks = this.getOutBoundSCP(packet.getMessage());
        if (toks.isEmpty()) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0030_NO_POLICY_FOUND_FOR_SC());
            throw new WSSecureConversationException(LogStringsMessages.WSITPVD_0030_NO_POLICY_FOUND_FOR_SC());
        }
        Token tok = (Token)((Object)toks.get(0));
        IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(tok.getTokenId());
        if (ctx == null) {
            RequestSecurityToken rst = scPlugin.createIssueRequest((PolicyAssertion)((Object)tok));
            Packet requestPacket = scPlugin.createIssuePacket((PolicyAssertion)((Object)tok), rst, this.pipeConfig.getWSDLModel(), this.pipeConfig.getBinding(), jaxbContext, packet.endpointAddress.toString(), packet);
            try {
                Packet secureRequestPacket = this.secureRequest(requestPacket, null, true);
                Packet responsePacket = this.nextPipe.process(secureRequestPacket);
                Packet validatedResponsePacket = this.validateResponse(responsePacket, null, null);
                RequestSecurityTokenResponse rstr = scPlugin.getRSTR(jaxbContext, validatedResponsePacket);
                ctx = new IssuedTokenContextImpl();
                ctx = scPlugin.processRSTR(ctx, rst, rstr, packet.endpointAddress.toString());
                this.issuedTokenContextMap.put(tok.getTokenId(), ctx);
            }
            catch (XWSSecurityException e) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0036_ERROR_PROC_REQ_PACKET(), e);
                throw new RuntimeException(LogStringsMessages.WSITPVD_0036_ERROR_PROC_REQ_PACKET(), e);
            }
        }
        SecurityTokenReference str = (SecurityTokenReference)ctx.getUnAttachedSecurityTokenReference();
        return WSTrustElementFactory.newInstance().toJAXBElement(str);
    }

    private CallbackHandler configureClientHandler(Set configAssertions, Properties props) {
        String ret = this.populateConfigProperties(configAssertions, props);
        try {
            if (ret != null) {
                Class handler = this.loadClass(ret);
                Object obj = handler.newInstance();
                if (!(obj instanceof CallbackHandler)) {
                    log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
                    throw new RuntimeException(LogStringsMessages.WSITPVD_0031_INVALID_CALLBACK_HANDLER_CLASS(ret));
                }
                return (CallbackHandler)obj;
            }
            return new DefaultCallbackHandler("client", props);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0032_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
            throw new RuntimeException(LogStringsMessages.WSITPVD_0032_ERROR_CONFIGURE_CLIENT_HANDLER(), e);
        }
    }

    private void invokeSCPlugin(Packet packet) {
        List<PolicyAssertion> policies = this.getOutBoundSCP(packet.getMessage());
        for (PolicyAssertion scAssertion : policies) {
            Token scToken = (Token)((Object)scAssertion);
            if (this.issuedTokenContextMap.get(scToken.getTokenId()) != null) continue;
            RequestSecurityToken rst = scPlugin.createIssueRequest(scAssertion);
            Packet requestPacket = scPlugin.createIssuePacket(scAssertion, rst, this.pipeConfig.getWSDLModel(), this.pipeConfig.getBinding(), jaxbContext, packet.endpointAddress.toString(), packet);
            try {
                Packet secureRequestPacket = this.secureRequest(requestPacket, null, true);
                Packet responsePacket = this.nextPipe.process(secureRequestPacket);
                Packet validatedResponsePacket = this.validateResponse(responsePacket, null, null);
                RequestSecurityTokenResponse rstr = scPlugin.getRSTR(jaxbContext, validatedResponsePacket);
                IssuedTokenContext ctx = new IssuedTokenContextImpl();
                ctx = scPlugin.processRSTR(ctx, rst, rstr, packet.endpointAddress.toString());
                this.issuedTokenContextMap.put(((Token)((Object)scAssertion)).getTokenId(), ctx);
            }
            catch (XWSSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void cancelSecurityContextToken() {
        Enumeration keys = this.issuedTokenContextMap.keys();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            IssuedTokenContext ctx = (IssuedTokenContext)this.issuedTokenContextMap.get(id);
            if (!(ctx.getSecurityToken() instanceof SecurityContextToken)) continue;
            try {
                RequestSecurityToken rst = scPlugin.createCancelRequest(ctx);
                Packet cancelPacket = scPlugin.createCancelPacket(rst, this.pipeConfig.getWSDLModel(), this.pipeConfig.getBinding(), jaxbContext, ctx.getEndpointAddress());
                Packet secCancelPacket = this.secureRequest(cancelPacket, null, false);
                Packet response = this.nextPipe.process(secCancelPacket);
                Packet cancelResponse = this.validateResponse(response, null, null);
                RequestSecurityTokenResponse rstr = scPlugin.getRSTR(jaxbContext, cancelResponse);
                ctx = scPlugin.processRSTR(ctx, rst, rstr, ctx.getEndpointAddress());
                this.issuedTokenContextMap.remove(id);
            }
            catch (XWSSecurityException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSITPVD_0049_ERROR_CANCEL_SECURITY_CONTEXT_TOKEN(), ex);
                throw new WebServiceException(LogStringsMessages.WSITPVD_0049_ERROR_CANCEL_SECURITY_CONTEXT_TOKEN(), (Throwable)this.getSOAPFaultException(ex));
            }
        }
    }

    private void invokeTrustPlugin(Packet packet, boolean isSCMessage) {
        List<PolicyAssertion> policies = null;
        if (isSCMessage) {
            Token scToken = (Token)packet.invocationProperties.get(Constants.SC_ASSERTION);
            policies = this.getIssuedTokenPoliciesFromBootstrapPolicy(scToken);
        } else {
            policies = this.getIssuedTokenPolicies(packet, Constants.OPERATION_SCOPE);
        }
        PolicyAssertion preSetSTSAssertion = null;
        Object stsEP = null;
        Object wsdlLocation = null;
        Object serviceName = null;
        Object portName = null;
        if (this.trustConfig != null) {
            Iterator it = this.trustConfig.iterator();
            while (it != null && it.hasNext()) {
                preSetSTSAssertion = (PolicyAssertion)it.next();
            }
        }
        for (PolicyAssertion issuedTokenAssertion : policies) {
            IssuedTokenContext ctx = trustPlugin.process(issuedTokenAssertion, preSetSTSAssertion, packet.endpointAddress.toString());
            this.issuedTokenContextMap.put(((Token)((Object)issuedTokenAssertion)).getTokenId(), ctx);
        }
    }

    protected List<PolicyAssertion> getIssuedTokenPolicies(Packet packet, String scope) {
        if (this.outMessagePolicyMap == null) {
            return new ArrayList<PolicyAssertion>();
        }
        WSDLBoundOperation operation = null;
        operation = this.isTrustMessage(packet) ? this.getWSDLOpFromAction(packet, false) : this.getOperation(packet.getMessage(), packet);
        SecurityPolicyHolder sph = (SecurityPolicyHolder)this.outMessagePolicyMap.get(operation);
        if (sph == null) {
            return EMPTY_LIST;
        }
        return sph.getIssuedTokens();
    }
}

