/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrManagedConnection;
import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.util.ResourceBundle;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;

public class JaxrConnection
implements Connection {
    private JaxrManagedConnection mc;
    private boolean supportsLocalTx;
    Log log = LogFactory.getLog((String)"com.sun.connector.jaxr");

    public JaxrConnection(JaxrManagedConnection jaxrManagedConnection, boolean bl) {
        this.mc = jaxrManagedConnection;
        this.supportsLocalTx = bl;
    }

    public RegistryService getRegistryService() throws JAXRException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Getting RegistryService");
        }
        return this.getJaxrConnection().getRegistryService();
    }

    public void close() throws JAXRException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"JAXRConnection close - delegating to managedConnection");
        }
        if (this.mc == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ManagedConnection removing JAXR Connection");
        }
        this.mc.removeJaxrConnection(this);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ManagedConnection sending connection closed Event");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ManagedConnection - connection closed Event Sent");
        }
        this.mc = null;
    }

    public boolean isClosed() throws JAXRException {
        return this.mc == null ? true : this.getJaxrConnection().isClosed();
    }

    public boolean isSynchronous() throws JAXRException {
        return this.getJaxrConnection().isSynchronous();
    }

    public void setSynchronous(boolean bl) throws JAXRException {
        this.getJaxrConnection().setSynchronous(bl);
    }

    public void setCredentials(Set set) throws JAXRException {
        this.getJaxrConnection().setCredentials(set);
    }

    public Set getCredentials() throws JAXRException {
        return this.getJaxrConnection().getCredentials();
    }

    void associateConnection(JaxrManagedConnection jaxrManagedConnection) throws ResourceException {
        try {
            this.checkIfValid();
        }
        catch (JAXRException jAXRException) {
            throw new IllegalStateException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Unable_to_associate_JAXR_Connection,_Connection_is_invalid"));
        }
        this.mc.removeJaxrConnection(this);
        jaxrManagedConnection.addJaxrConnection(this);
        this.mc = jaxrManagedConnection;
    }

    void checkIfValid() throws JAXRException {
        if (this.mc == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Connection_is_invalid"));
        }
    }

    Connection getJaxrConnection() throws JAXRException {
        this.checkIfValid();
        try {
            return this.mc.getJaxrConnection();
        }
        catch (ResourceException resourceException) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Unable_to_obtain_JAXR_Connection_") + resourceException.getMessage());
        }
    }

    void invalidate() {
        this.mc = null;
    }
}

