/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.GenericJMSRAProperties;
import com.sun.genericra.outbound.ConnectionFactory;
import com.sun.genericra.outbound.ConnectionManager;
import com.sun.genericra.outbound.ConnectionRequestInfo;
import com.sun.genericra.outbound.ManagedConnection;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.ObjectBuilder;
import com.sun.genericra.util.ObjectBuilderFactory;
import com.sun.genericra.util.SecurityUtils;
import com.sun.genericra.util.StringUtils;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class AbstractManagedConnectionFactory
extends GenericJMSRAProperties
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static boolean inAppClientContainer = false;
    private static final String INACC_SYSTEM_PROP_KEY = "genericra.inAppClientContainer";
    private static Logger logger = LogUtils.getLogger();
    private String connectionFactoryJndiName;
    private String clientId = null;
    private boolean connectionValidationEnabled = false;
    private boolean useProxyMessages = false;
    private PrintWriter logWriter;
    private javax.jms.ConnectionFactory connectionFactory = null;
    protected int destinationMode = 0;

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter pw) throws ResourceException {
        this.logWriter = pw;
    }

    public Object createConnectionFactory() throws ResourceException {
        ConnectionManager cm = new ConnectionManager();
        return new ConnectionFactory(this, cm);
    }

    public Object createConnectionFactory(javax.resource.spi.ConnectionManager cm) throws ResourceException {
        return new ConnectionFactory(this, cm);
    }

    public javax.resource.spi.ManagedConnection createManagedConnection(Subject subject, javax.resource.spi.ConnectionRequestInfo cri) throws ResourceException {
        try {
            this.initializeConnectionFactory();
            PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cri);
            Connection physicalCon = this.createPhysicalConnection(pc);
            return new ManagedConnection(this, pc, (ConnectionRequestInfo)cri, physicalCon);
        }
        catch (ResourceException e) {
            throw ExceptionUtils.newResourceException(e);
        }
        catch (JMSException e) {
            throw ExceptionUtils.newResourceException(e);
        }
    }

    private Connection createPhysicalConnection(PasswordCredential pc) throws JMSException {
        Object physicalCon = null;
        physicalCon = this.getSupportsXA() ? this.createXAConnection(pc, this.connectionFactory) : this.createConnection(pc, this.connectionFactory);
        return physicalCon;
    }

    protected abstract XAConnection createXAConnection(PasswordCredential var1, javax.jms.ConnectionFactory var2) throws JMSException;

    protected abstract Connection createConnection(PasswordCredential var1, javax.jms.ConnectionFactory var2) throws JMSException;

    protected abstract String getActualConnectionFactoryClassName();

    private void initializeConnectionFactory() throws ResourceException {
        if (this.connectionFactory == null) {
            ObjectBuilder cfBuilder = null;
            ObjectBuilderFactory obf = new ObjectBuilderFactory();
            if (this.getProviderIntegrationMode().equalsIgnoreCase("jndi")) {
                cfBuilder = obf.createUsingJndiName(this.getConnectionFactoryJndiName(), this.getJndiProperties());
            } else {
                cfBuilder = obf.createUsingClassName(this.getActualConnectionFactoryClassName());
                cfBuilder.setProperties(this.getConnectionFactoryProperties());
            }
            String setMethod = this.getCommonSetterMethodName();
            if (!StringUtils.isNull(setMethod)) {
                cfBuilder.setCommonSetterMethodName(setMethod);
            }
            this.connectionFactory = (javax.jms.ConnectionFactory)cfBuilder.build();
        }
    }

    public javax.resource.spi.ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, javax.resource.spi.ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (connectionSet == null) {
            return null;
        }
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        Iterator iter = connectionSet.iterator();
        ManagedConnection mc = null;
        while (iter.hasNext()) {
            try {
                mc = (ManagedConnection)iter.next();
                this.debug("Matching managed connections ->" + mc);
            }
            catch (NoSuchElementException nsee) {
                throw ExceptionUtils.newResourceException(nsee);
            }
            if (!(pc == null && this.equals(mc.getManagedConnectionFactory()) ? !mc.isDestroyed() : SecurityUtils.isPasswordCredentialEqual(pc, mc.getPasswordCredential()) && !mc.isDestroyed())) continue;
            return mc;
        }
        return null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public boolean isInAppClientContainer() {
        return inAppClientContainer;
    }

    public boolean getUseProxyMessages() {
        return this.useProxyMessages;
    }

    public void setUseProxyMessages(boolean flag) {
        this.useProxyMessages = flag;
    }

    public boolean getConnectionValidationEnabled() {
        return this.connectionValidationEnabled;
    }

    public void setConnectionValidationEnabled(boolean connectionValidationEnabled) {
        this.connectionValidationEnabled = connectionValidationEnabled;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractManagedConnectionFactory)) {
            return false;
        }
        this.debug("equals - no false yet");
        AbstractManagedConnectionFactory other = (AbstractManagedConnectionFactory)obj;
        boolean eq = StringUtils.isEqual(this.clientId, other.clientId) && StringUtils.isEqual(this.connectionFactoryJndiName, other.connectionFactoryJndiName) && this.destinationMode == other.destinationMode;
        this.debug(" equals - final: " + eq);
        return eq;
    }

    public int getDestinationMode() {
        return this.destinationMode;
    }

    private void debug(String s) {
        logger.log(Level.FINEST, "[AbstractMCF] " + s);
    }

    static {
        String s = System.getProperty(INACC_SYSTEM_PROP_KEY);
        if (s != null) {
            inAppClientContainer = Boolean.valueOf(s);
        }
    }
}

