/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ResourceAdapterConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.ArchiveFactory;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class DeploymentHandler {
    private static final HashMap<String, String> nextPageMap = new HashMap();

    protected static void deploy(String[] targets, Properties deploymentProps, String location, HandlerContext handlerCtx) throws Exception {
        deploymentProps.setProperty("force", "false");
        String appType = deploymentProps.getProperty("appType");
        deploymentProps.remove("appType");
        boolean status = DeploymentHandler.invokeDeploymentFacility(targets, deploymentProps, location, handlerCtx);
        if (status) {
            // empty if block
        }
        String type = AMXUtil.getAppType(deploymentProps.getProperty("name"));
        String nextPage = (String)handlerCtx.getInputValue("listPageLink");
        if ("X-RARModuleConfig".equals(type)) {
            nextPage = nextPageMap.get(type);
            Properties rarProps = new Properties();
            DeploymentHandler.setProperty(rarProps, "threadPool", (String)handlerCtx.getInputValue("threadpool"), "");
            DeploymentHandler.setProperty(rarProps, "registry", (String)handlerCtx.getInputValue("registryType"), "");
            DeploymentHandler.setProperty(rarProps, "target", (String)handlerCtx.getInputValue("target"), "");
            DeploymentHandler.setProperty(rarProps, "listPageLink", (String)handlerCtx.getInputValue("listPageLink"), "");
            DeploymentHandler.setProperty(rarProps, "cancelPage", (String)handlerCtx.getInputValue("cancelPage"), "applications/connectorModules.jsf");
            DeploymentHandler.setProperty(rarProps, "filePath", location, "");
            DeploymentHandler.setProperty(rarProps, "name", deploymentProps.getProperty("name"), "");
            if (status) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.deploy.connectorModule"), null);
            }
            handlerCtx.setOutputValue("rarProps", (Object)rarProps);
        } else if (GuiUtil.isEmpty(nextPage)) {
            nextPage = nextPageMap.get(type);
        }
        handlerCtx.setOutputValue("nextPage", (Object)nextPage);
    }

    private static void setProperty(Properties rarProps, String key, String value, String defValue) {
        rarProps.setProperty(key, value == null ? defValue : value);
    }

    protected static boolean invokeDeploymentFacility(String[] targets, Properties props, String archivePath, HandlerContext handlerCtx) throws Exception {
        if (archivePath == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.deploy.nullArchiveError"));
        }
        if (targets == null) {
            String defaultTarget = AMXUtil.isEE() ? "domain" : "server";
            targets = new String[]{defaultTarget};
        }
        archivePath = archivePath.replace('\\', '/');
        AbstractArchive archive = new ArchiveFactory().openArchive(archivePath);
        DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
        JESProgressObject progressObject = null;
        progressObject = df.deploy(df.createTargets(targets), (Archive)archive, null, (Map)props);
        DeploymentStatus status = null;
        do {
            if ((status = progressObject.getCompletedStatus()) != null) continue;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (status == null);
        boolean ret = DeploymentHandler.checkDeployStatus(status, handlerCtx, true);
        return ret;
    }

    private static boolean checkDeployStatus(DeploymentStatus status, HandlerContext handlerCtx, boolean stopProcessing) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DeploymentStatus.parseDeploymentStatus((DeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status != null && status.getStatus() == 0) {
            if (stopProcessing) {
                GuiUtil.handleError(handlerCtx, statusString);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusString);
            }
            return false;
        }
        if (status != null && status.getStatus() == 1) {
            GuiUtil.prepareAlert(handlerCtx, "warning", GuiUtil.getMessage("deploy.warning"), statusString);
            return false;
        }
        return true;
    }

    public static void redeploy(HandlerContext handlerCtx) {
        try {
            String filePath = (String)handlerCtx.getInputValue("filePath");
            String origPath = (String)handlerCtx.getInputValue("origPath");
            String appName = (String)handlerCtx.getInputValue("appName");
            Properties deploymentProps = new Properties();
            WebModuleConfig module = (WebModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(appName);
            if (module != null) {
                deploymentProps.setProperty("contextRoot", module.getContextRoot());
            }
            deploymentProps.setProperty("archiveName", origPath);
            deploymentProps.setProperty("force", "true");
            deploymentProps.setProperty("name", appName);
            DeploymentHandler.invokeDeploymentFacility(null, deploymentProps, filePath, handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void undeploy(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("selectedRows");
        String appType = (String)handlerCtx.getInputValue("appType");
        Properties dProps = null;
        if (appType.equals("connector")) {
            dProps = new Properties();
            dProps.put("cascade", "true");
        }
        List selectedRows = (List)obj;
        JESProgressObject progressObject = null;
        DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
        String[] targetNames = new String[]{"server"};
        for (int i = 0; i < selectedRows.size(); ++i) {
            DeploymentStatus status;
            Map oneRow = (Map)selectedRows.get(i);
            String appName = (String)oneRow.get("name");
            if (AMXUtil.isEE()) {
                List<String> refList = TargetUtil.getDeployedTargets(appName, true);
                targetNames = refList.size() > 0 ? refList.toArray(new String[refList.size()]) : new String[]{"domain"};
            }
            if (!DeploymentHandler.checkDeployStatus(status = df.waitFor(progressObject = df.undeploy(df.createTargets(targetNames), appName, (Map)dProps)), handlerCtx, false)) continue;
            String mesg = GuiUtil.getMessage("msg.deploySuccess", new Object[]{appName, "undeployed"});
        }
    }

    public static void createResourceAdapterConfig(HandlerContext handlerCtx) {
        Map addProps;
        String registry;
        Properties dProps = (Properties)handlerCtx.getInputValue("dProps");
        String name = dProps.getProperty("name");
        ResourceAdapterConfig ra = AMXUtil.getDomainConfig().createResourceAdapterConfig(name, null);
        String threadPool = dProps.getProperty("threadPool");
        if (!GuiUtil.isEmpty(threadPool)) {
            ra.setThreadPoolIDs(threadPool);
        }
        if (!GuiUtil.isEmpty(registry = dProps.getProperty("registry"))) {
            ra.createProperty(registry, "true");
        }
        if ((addProps = (Map)handlerCtx.getInputValue("AddProps")) != null) {
            for (String key : addProps.keySet()) {
                String value = (String)addProps.get(key);
                if (GuiUtil.isEmpty(value)) continue;
                ra.createProperty(key, value);
            }
        }
        handlerCtx.setOutputValue("nextPage", (Object)"applications/connectorModules.jsf");
    }

    public static void getAdapterProperties(HandlerContext handlerCtx) {
        Properties dProps = (Properties)handlerCtx.getInputValue("dProps");
        String filePath = dProps.getProperty("filePath");
        Map props = new HashMap();
        try {
            props = ConnectorRuntime.getRuntime().getResourceAdapterBeanProperties(filePath);
            DeploymentHandler.clearValues(props);
        }
        catch (Exception ex) {
            // empty catch block
        }
        handlerCtx.setOutputValue("properties", props);
        handlerCtx.setOutputValue("dProps", (Object)dProps);
    }

    public static void getDescriptors(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        Boolean includeSubComponent = (Boolean)handlerCtx.getInputValue("includeSubComponent");
        if (includeSubComponent == null) {
            includeSubComponent = false;
        }
        ArrayList list = new ArrayList();
        String[] descriptors = null;
        try {
            String[] modules;
            descriptors = DeploymentHandler.getDescriptors(appName, null);
            for (int i = 0; descriptors != null && i < descriptors.length; ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", appName);
                map.put("moduleName", "");
                int index = descriptors[i].lastIndexOf(File.separator) + 1;
                map.put("descriptor", descriptors[i].substring(index));
                map.put("descriptorPath", descriptors[i]);
                list.add(map);
            }
            if (includeSubComponent.booleanValue() && (modules = (String[])JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "getModuleComponents", new Object[]{appName}, new String[]{"java.lang.String"})) != null) {
                for (int i = 0; i < modules.length; ++i) {
                    String subComponentName = new ObjectName(modules[i]).getKeyProperty("name");
                    String[] subDesc = DeploymentHandler.getDescriptors(appName, subComponentName);
                    for (int j = 0; subDesc != null && j < subDesc.length; ++j) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("name", appName);
                        map.put("moduleName", subComponentName);
                        int index = subDesc[j].lastIndexOf(File.separator) + 1;
                        map.put("descriptor", subDesc[j].substring(index));
                        map.put("descriptorPath", subDesc[j]);
                        list.add(map);
                    }
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("descriptors", list);
    }

    public static void createApplicationReferences(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("name");
        String[] selTargets = (String[])handlerCtx.getInputValue("targets");
        List<String> targets = Arrays.asList(selTargets);
        List<String> associatedTargets = TargetUtil.getDeployedTargets(name, true);
        try {
            ArrayList<String> addTargets = new ArrayList<String>();
            for (String targetName : targets) {
                if (associatedTargets.contains(targetName)) continue;
                addTargets.add(targetName);
            }
            DeploymentHandler.handleAppRefs(name, addTargets.toArray(new String[addTargets.size()]), handlerCtx, true, null);
            ArrayList<String> removeTargets = new ArrayList<String>();
            for (String targetName : associatedTargets) {
                if (targets.contains(targetName)) continue;
                removeTargets.add(targetName);
            }
            DeploymentHandler.handleAppRefs(name, removeTargets.toArray(new String[removeTargets.size()]), handlerCtx, false, null);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void handleAppRefs(String appName, String[] targetNames, HandlerContext handlerCtx, boolean addFlag, Boolean enableFlag) {
        if (targetNames != null && targetNames.length > 0) {
            DeploymentFacility df = DeploymentFacilityFactory.getLocalDeploymentFacility();
            JESProgressObject progressObject = null;
            Properties dProps = new Properties();
            if (enableFlag != null) {
                dProps.setProperty("enable", enableFlag.toString());
            }
            progressObject = addFlag ? df.createAppRef(df.createTargets(targetNames), appName, (Map)dProps) : df.deleteAppRef(df.createTargets(targetNames), appName, (Map)dProps);
            DeploymentStatus status = df.waitFor(progressObject);
            DeploymentHandler.checkDeployStatus(status, handlerCtx, true);
        }
    }

    private static String[] getDescriptors(String appName, String subComponent) {
        String methodName = "getDeploymentDescriptorLocations";
        String objectName = "com.sun.appserv:type=applications,category=config";
        Object[] params = new Object[]{appName, subComponent};
        String[] types = new String[]{"java.lang.String", "java.lang.String"};
        String[] descriptors = (String[])JMXUtil.invoke(objectName, methodName, params, types);
        return descriptors;
    }

    public static void descriptorDisplay(HandlerContext handlerCtx) {
        String filePath = (String)handlerCtx.getInputValue("filePath");
        String appName = (String)handlerCtx.getInputValue("appName");
        String pageName = (String)handlerCtx.getInputValue("pageName");
        String objectName = "com.sun.appserv:type=applications,category=config";
        String methodName = "getDeploymentDescriptor";
        Object[] params = new Object[]{filePath};
        String[] types = new String[]{"java.lang.String"};
        String descriptor = (String)JMXUtil.invoke(objectName, methodName, params, types);
        handlerCtx.setOutputValue("descriptor", (Object)descriptor);
        handlerCtx.setOutputValue("appName", (Object)appName);
        handlerCtx.setOutputValue("pageName", (Object)pageName);
    }

    private static void clearValues(Map map) {
        Set keySet = map.keySet();
        for (String key : keySet) {
            map.put(key, "");
        }
    }

    static {
        nextPageMap.put("X-WebModuleConfig", "applications/webApplications.jsf");
        nextPageMap.put("X-J2EEApplicationConfig", "applications/enterpriseApplications.jsf");
        nextPageMap.put("X-EJBModuleConfig", "applications/ejbModules.jsf");
        nextPageMap.put("X-AppClientModuleConfig", "applications/appclientModules.jsf");
        nextPageMap.put("X-RARModuleConfig", "applications/connectorModulePropsTable.jsf");
    }
}

