/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;

public class InstanceHandler {
    public static void getInstanceGeneralAttributes(HandlerContext handlerCtx) {
        String port;
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        if (GuiUtil.isEmpty(instanceName)) {
            System.out.println("instanceName is not provided, set to \"server\"");
            instanceName = "server";
        }
        String configName = AMXUtil.getConfigName(instanceName);
        ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        String hostName = request.getServerName();
        handlerCtx.setOutputValue("hostName", (Object)hostName);
        HTTPServiceConfig service = AMXUtil.getConfig(configName).getHTTPServiceConfig();
        Map listeners = service.getHTTPListenerConfigMap();
        StringBuffer ports = new StringBuffer();
        for (String key : listeners.keySet()) {
            String port2 = ((HTTPListenerConfig)listeners.get(key)).getPort();
            if (port2.startsWith("$")) {
                port2 = InstanceHandler.resolveToken(port2.substring(2, port2.length() - 1), instanceName);
            }
            ports.append("," + port2);
        }
        ports.deleteCharAt(0);
        handlerCtx.setOutputValue("httpPorts", (Object)ports.toString());
        IIOPServiceConfig iiopService = AMXUtil.getConfig(configName).getIIOPServiceConfig();
        Map iiopListeners = iiopService.getIIOPListenerConfigMap();
        StringBuffer iports = new StringBuffer();
        for (String key : iiopListeners.keySet()) {
            String iport = ((IIOPListenerConfig)iiopListeners.get(key)).getPort();
            if (iport.startsWith("$")) {
                iport = InstanceHandler.resolveToken(iport.substring(2, iport.length() - 1), instanceName);
            }
            iports.append("," + iport);
        }
        iports.deleteCharAt(0);
        handlerCtx.setOutputValue("iiopPorts", (Object)iports.toString());
        String configDir = (String)JMXUtil.invoke("com.sun.appserv:type=domain,category=config", "getConfigDir", null, null);
        handlerCtx.setOutputValue("configDir", (Object)configDir);
        String version = (String)JMXUtil.getAttribute("com.sun.appserv:j2eeType=J2EEDomain,name=com.sun.appserv,category=runtime", "applicationServerFullVersion");
        handlerCtx.setOutputValue("version", (Object)version);
        Object debugPort = JMXUtil.getAttribute("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime", "debugPort");
        String msg = GuiUtil.getMessage("inst.notEnabled");
        if (debugPort != null && !(port = debugPort.toString()).equals("0")) {
            msg = GuiUtil.getMessage("inst.debugEnabled") + debugPort.toString();
        }
        handlerCtx.setOutputValue("debugPort", (Object)msg);
    }

    private static String resolveToken(String pn, String serverName) {
        ServerConfig serverConfig = (ServerConfig)AMXUtil.getDomainConfig().getServerConfigMap().get(serverName);
        String value = serverConfig.getSystemPropertyValue(pn);
        return value;
    }

    public static void rotateLogFile(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        if (GuiUtil.isEmpty(instanceName)) {
            return;
        }
        ServerRootMonitor monitor = (ServerRootMonitor)AMXUtil.getMonitoringRoot().getServerRootMonitorMap().get(instanceName);
        if (monitor != null) {
            monitor.getLogging().rotateLogFile("server");
        }
    }

    public static void getConfigNameOfTarget(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        String configName = AMXUtil.getConfigByInstanceOrClusterName(target).getName();
        handlerCtx.setOutputValue("configName", (Object)configName);
    }

    public static void upgradeProfile(HandlerContext handlerCtx) {
        try {
            Object[] params = new String[]{"cluster"};
            String[] signature = new String[]{"java.lang.String"};
            JMXUtil.invoke("com.sun.appserv:type=domain,category=config", "addClusteringSupportUsingProfile", params, signature);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void stopDAS(HandlerContext handlerCtx) {
        try {
            JMXUtil.stopServerInstance("server");
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }
}

