/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.JDBCResourceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.tools.admingui.handlers.ConnectorsHandlers;
import com.sun.enterprise.tools.admingui.handlers.JavaMailHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JdbcHandlers {
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String XADATA_SOURCE = "javax.sql.XADataSource";
    private static final String CCDATA_SOURCE = "javax.sql.ConnectionPoolDataSource";
    private static final String JAVADB = "JavaDB";
    private static final String ORACLE = "Oracle";
    private static final String DERBY = "Derby";
    private static final String SYBASE = "Sybase";
    private static final String DB2 = "DB2";
    private static final String POINTBASE = "PointBase";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String INFORMIX = "Informix";
    private static final String CLOUDSCAPE = "Cloudscape";
    private static final String MSSQL = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static Map<String, String> dataSourceMap = new HashMap<String, String>();
    private static Map<String, String> XADataSourceMap = new HashMap<String, String>();
    private static Map<String, String> CCDataSourceMap = new HashMap<String, String>();
    private static List resTypeList = new ArrayList();
    private static List dbVendorList = new ArrayList();

    public static void getJdbcInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        if (GuiUtil.isEmpty(jndiName)) {
            handlerCtx.setOutputValue("enabled", (Object)Boolean.TRUE);
            return;
        }
        JDBCResourceConfig jdbc = (JDBCResourceConfig)AMXUtil.getDomainConfig().getJDBCResourceConfigMap().get(jndiName);
        if (jdbc == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchJDBCResource"));
        } else {
            handlerCtx.setOutputValue("poolName", (Object)jdbc.getPoolName());
            handlerCtx.setOutputValue("description", (Object)jdbc.getDescription());
            if (AMXUtil.isEE()) {
                handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)jdbc, false));
            } else {
                handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isResourceEnabled((Enabled)jdbc, "server"));
            }
        }
    }

    public static void saveJdbc(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String poolName = (String)handlerCtx.getInputValue("poolName");
        Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
        JDBCResourceConfig jdbc = null;
        try {
            if (edit.booleanValue()) {
                jdbc = (JDBCResourceConfig)AMXUtil.getDomainConfig().getJDBCResourceConfigMap().get(jndiName);
                if (jdbc == null) {
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.NoSuchJDBCResource"));
                    return;
                }
                jdbc.setPoolName(poolName);
                if (!AMXUtil.isEE()) {
                    Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                    TargetUtil.setResourceEnabled((Enabled)jdbc, "server", enabled);
                }
                GuiUtil.prepareSuccessful(handlerCtx);
            } else {
                jdbc = AMXUtil.getDomainConfig().createJDBCResourceConfig(jndiName, poolName, null);
                JavaMailHandlers.createNewTargets(handlerCtx, jndiName);
            }
            jdbc.setDescription((String)handlerCtx.getInputValue("description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJdbcConnectionPools(HandlerContext handlerCtx) {
        Set keys = AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().keySet();
        handlerCtx.setOutputValue("jdbcConnectionPools", new ArrayList(keys));
    }

    public static void getJdbcConnectionPoolInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
        }
        handlerCtx.setOutputValue("datasourceClassname", (Object)pool.getDatasourceClassname());
        handlerCtx.setOutputValue("resType", (Object)pool.getResType());
        handlerCtx.setOutputValue("description", (Object)pool.getDescription());
        handlerCtx.setOutputValue("steadyPoolSize", (Object)pool.getSteadyPoolSize());
        handlerCtx.setOutputValue("maxPoolSize", (Object)pool.getMaxPoolSize());
        handlerCtx.setOutputValue("poolResizeQuantity", (Object)pool.getPoolResizeQuantity());
        handlerCtx.setOutputValue("idleTimeoutInSeconds", (Object)pool.getIdleTimeoutInSeconds());
        handlerCtx.setOutputValue("maxWaitTimeInMillis", (Object)pool.getMaxWaitTimeInMillis());
        handlerCtx.setOutputValue("isConnectionValidationRequired", (Object)pool.getIsConnectionValidationRequired());
        handlerCtx.setOutputValue("connectionValidationMethod", (Object)pool.getConnectionValidationMethod());
        handlerCtx.setOutputValue("validationTableName", (Object)pool.getValidationTableName());
        handlerCtx.setOutputValue("failAllConnections", (Object)pool.getFailAllConnections());
        handlerCtx.setOutputValue("allowNonComponentCallers", (Object)pool.getAllowNonComponentCallers());
        handlerCtx.setOutputValue("nonTransactionalConnections", (Object)pool.getNonTransactionalConnections());
        handlerCtx.setOutputValue("transactionIsolationLevel", (Object)pool.getTransactionIsolationLevel());
        handlerCtx.setOutputValue("isIsolationLevelGuaranteed", (Object)pool.getIsIsolationLevelGuaranteed());
    }

    public static void getJdbcConnectionPoolProperty(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
        }
        Map props = pool.getProperties();
        handlerCtx.setOutputValue("properties", (Object)props);
    }

    public static void saveJdbcConnectionPool(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
                return;
            }
            pool.setDatasourceClassname((String)handlerCtx.getInputValue("datasourceClassname"));
            pool.setResType((String)handlerCtx.getInputValue("resType"));
            pool.setDescription((String)handlerCtx.getInputValue("description"));
            pool.setMaxPoolSize((String)handlerCtx.getInputValue("maxPoolSize"));
            pool.setSteadyPoolSize((String)handlerCtx.getInputValue("steadyPoolSize"));
            pool.setPoolResizeQuantity((String)handlerCtx.getInputValue("poolResizeQuantity"));
            pool.setIdleTimeoutInSeconds((String)handlerCtx.getInputValue("idleTimeoutInSeconds"));
            pool.setMaxWaitTimeInMillis((String)handlerCtx.getInputValue("maxWaitTimeInMillis"));
            pool.setIsConnectionValidationRequired(((Boolean)handlerCtx.getInputValue("isConnectionValidationRequired")).booleanValue());
            String method = (String)handlerCtx.getInputValue("connectionValidationMethod");
            pool.setConnectionValidationMethod(method);
            if ("table".equals(method)) {
                String table = (String)handlerCtx.getInputValue("validationTableName");
                if (!GuiUtil.isEmpty(table)) {
                    pool.setValidationTableName(table);
                }
            } else {
                pool.setValidationTableName("");
            }
            pool.setFailAllConnections(((Boolean)handlerCtx.getInputValue("failAllConnections")).booleanValue());
            pool.setAllowNonComponentCallers(((Boolean)handlerCtx.getInputValue("allowNonComponentCallers")).booleanValue());
            pool.setNonTransactionalConnections(((Boolean)handlerCtx.getInputValue("nonTransactionalConnections")).booleanValue());
            pool.setTransactionIsolationLevel((String)handlerCtx.getInputValue("transactionIsolationLevel"));
            pool.setIsIsolationLevelGuaranteed(((Boolean)handlerCtx.getInputValue("isIsolationLevelGuaranteed")).booleanValue());
            GuiUtil.prepareSuccessful(handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveJdbcConnectionPoolProperty(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
                return;
            }
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)pool);
            GuiUtil.prepareSuccessful(handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJdbcConnectionPoolDefaultInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
            return;
        }
        handlerCtx.setOutputValue("resType", (Object)pool.getDefaultValue("ResType"));
        handlerCtx.setOutputValue("description", (Object)pool.getDefaultValue("Description"));
        handlerCtx.setOutputValue("steadyPoolSize", (Object)pool.getDefaultValue("SteadyPoolSize"));
        handlerCtx.setOutputValue("maxPoolSize", (Object)pool.getDefaultValue("MaxPoolSize"));
        handlerCtx.setOutputValue("poolResizeQuantity", (Object)pool.getDefaultValue("PoolResizeQuantity"));
        handlerCtx.setOutputValue("idleTimeoutInSeconds", (Object)pool.getDefaultValue("IdleTimeoutInSeconds"));
        handlerCtx.setOutputValue("maxWaitTimeInMillis", (Object)pool.getDefaultValue("MaxWaitTimeInMillis"));
        handlerCtx.setOutputValue("isConnectionValidationRequired", (Object)pool.getDefaultValue("IsConnectionValidationRequired"));
        handlerCtx.setOutputValue("connectionValidationMethod", (Object)pool.getDefaultValue("ConnectionValidationMethod"));
        handlerCtx.setOutputValue("validationTableName", (Object)pool.getDefaultValue("ValidationTableName"));
        handlerCtx.setOutputValue("failAllConnections", (Object)pool.getDefaultValue("FailAllConnections"));
        handlerCtx.setOutputValue("allowNonComponentCallers", (Object)pool.getDefaultValue("AllowNonComponentCallers"));
        handlerCtx.setOutputValue("nonTransactionalConnections", (Object)pool.getDefaultValue("NonTransactionalConnections"));
        handlerCtx.setOutputValue("transactionIsolationLevel", (Object)pool.getDefaultValue("TransactionIsolationLevel"));
        handlerCtx.setOutputValue("isIsolationLevelGuaranteed", (Object)pool.getDefaultValue("IsIsolationLevelGuaranteed"));
    }

    public static void getPoolAdvanceInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
            return;
        }
        HashMap<String, Object> advance = new HashMap<String, Object>();
        advance.put("wrapJDBCObjects", JdbcHandlers.StringToBoolean(pool.getWrapJDBCObjects()));
        advance.put("statementTimeoutInSeconds", pool.getStatementTimeoutInSeconds());
        advance.put("validateAtMostOncePeriodInSeconds", pool.getValidateAtMostOncePeriodInSeconds());
        advance.put("connectionLeakTimeoutInSeconds", pool.getConnectionLeakTimeoutInSeconds());
        advance.put("connectionLeakReclaim", JdbcHandlers.StringToBoolean(pool.getConnectionLeakReclaim()));
        advance.put("connectionCreationRetryAttempts", pool.getConnectionCreationRetryAttempts());
        advance.put("connectionCreationRetryIntervalInSeconds", pool.getConnectionCreationRetryIntervalInSeconds());
        advance.put("lazyConnectionEnlistment", JdbcHandlers.StringToBoolean(pool.getLazyConnectionEnlistment()));
        advance.put("lazyConnectionAssociation", JdbcHandlers.StringToBoolean(pool.getLazyConnectionAssociation()));
        advance.put("associateWithThread", JdbcHandlers.StringToBoolean(pool.getAssociateWithThread()));
        advance.put("matchConnections", JdbcHandlers.StringToBoolean(pool.getMatchConnections()));
        advance.put("maxConnectionUsageCount", pool.getMaxConnectionUsageCount());
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void getPoolAdvanceDefaultInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
            return;
        }
        HashMap<String, Boolean> advance = new HashMap<String, Boolean>();
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-JDBCConnectionPoolConfig");
        advance.put("wrapJDBCObjects", JdbcHandlers.StringToBoolean(defaultMap.get("wrap-jdbc-objects")));
        advance.put("statementTimeoutInSeconds", (Boolean)defaultMap.get("statement-timeout-in-seconds"));
        advance.put("validateAtMostOncePeriodInSeconds", (Boolean)defaultMap.get("validate-atmost-once-period-in-seconds"));
        advance.put("connectionLeakTimeoutInSeconds", (Boolean)defaultMap.get("connection-leak-timeout-in-seconds"));
        advance.put("connectionLeakReclaim", JdbcHandlers.StringToBoolean(defaultMap.get("connection-leak-timeout-in-seconds")));
        advance.put("connectionCreationRetryAttempts", (Boolean)defaultMap.get("connection-creation-retry-attempts"));
        advance.put("connectionCreationRetryIntervalInSeconds", (Boolean)defaultMap.get("connection-creation-retry-interval-in-seconds"));
        advance.put("lazyConnectionEnlistment", JdbcHandlers.StringToBoolean(defaultMap.get("lazy-connection-enlistment")));
        advance.put("lazyConnectionAssociation", JdbcHandlers.StringToBoolean(defaultMap.get("lazy-connection-association")));
        advance.put("associateWithThread", JdbcHandlers.StringToBoolean(defaultMap.get("associate-with-thread")));
        advance.put("matchConnections", JdbcHandlers.StringToBoolean(defaultMap.get("match-connections")));
        advance.put("maxConnectionUsageCount", (Boolean)defaultMap.get("max-connection-usage-count"));
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void savePoolAdvanceInfo(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            Map advance = (Map)handlerCtx.getInputValue("advance");
            JDBCConnectionPoolConfig pool = (JDBCConnectionPoolConfig)AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.noSuchJDBCConnectionPool"));
                return;
            }
            pool.setWrapJDBCObjects(JdbcHandlers.BooleanToString(advance.get("wrapJDBCObjects")));
            pool.setStatementTimeoutInSeconds((String)advance.get("statementTimeoutInSeconds"));
            pool.setValidateAtMostOncePeriodInSeconds((String)advance.get("validateAtMostOncePeriodInSeconds"));
            pool.setConnectionLeakTimeoutInSeconds((String)advance.get("connectionLeakTimeoutInSeconds"));
            pool.setConnectionLeakReclaim(JdbcHandlers.BooleanToString(advance.get("connectionLeakReclaim")));
            pool.setConnectionCreationRetryAttempts((String)advance.get("connectionCreationRetryAttempts"));
            pool.setConnectionCreationRetryIntervalInSeconds((String)advance.get("connectionCreationRetryIntervalInSeconds"));
            pool.setLazyConnectionEnlistment(JdbcHandlers.BooleanToString(advance.get("lazyConnectionEnlistment")));
            pool.setLazyConnectionAssociation(JdbcHandlers.BooleanToString(advance.get("lazyConnectionAssociation")));
            pool.setAssociateWithThread(JdbcHandlers.BooleanToString(advance.get("associateWithThread")));
            pool.setMatchConnections(JdbcHandlers.BooleanToString(advance.get("matchConnections")));
            pool.setMaxConnectionUsageCount((String)advance.get("maxConnectionUsageCount"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String BooleanToString(Object test) {
        if (test == null) {
            return Boolean.FALSE.toString();
        }
        return test.toString();
    }

    private static Boolean StringToBoolean(Object test) {
        if (test == null) {
            return false;
        }
        if (test instanceof String) {
            return Boolean.valueOf((String)test);
        }
        if (test instanceof Boolean) {
            return (Boolean)test;
        }
        return false;
    }

    public static void pingJdbcConnectionPool(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        Object[] params = new String[]{jndiName, null};
        String[] signatures = new String[]{"java.lang.String", "java.lang.String"};
        try {
            Object result = JMXUtil.invoke("com.sun.appserv:type=resources,category=config", "pingConnectionPool", params, signatures);
            if (result != null && ((Boolean)result).booleanValue()) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.PingSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), "msg.PingError");
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJDBCPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        if (fromStep2 == null || !fromStep2.booleanValue()) {
            Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-JDBCConnectionPoolConfig");
            HashMap attrMap = new HashMap();
            attrMap.put("SteadyPoolSize", defaultMap.get("steady-pool-size"));
            attrMap.put("MaxPoolSize", defaultMap.get("max-pool-size"));
            attrMap.put("MaxWaitTimeInMillis", defaultMap.get("max-wait-time-in-millis"));
            attrMap.put("PoolResizeQuantity", defaultMap.get("pool-resize-quantity"));
            attrMap.put("IdleTimeoutInSeconds", defaultMap.get("idle-timeout-in-seconds"));
            attrMap.put("IsIsolationLevelGuaranteed", defaultMap.get("is-isolation-level-guaranteed"));
            attrMap.put("IsConnectionValidationRequired", defaultMap.get("is-connection-validation-required"));
            attrMap.put("ConnectionValidationMethod", defaultMap.get("connection-validation-method"));
            attrMap.put("FailAllConnections", defaultMap.get("fail-all-connections"));
            attrMap.put("NonTransactionalConnections", defaultMap.get("non-transactional-connections"));
            attrMap.put("AllowNonComponentCallers", defaultMap.get("allow-non-component-callers"));
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("wizardPool", attrMap);
            sessionMap.put("wizardPoolExtra", new HashMap());
            sessionMap.put("wizardPoolProperties", new HashMap());
        }
        handlerCtx.setOutputValue("ResTypeList", (Object)resTypeList);
        handlerCtx.setOutputValue("DBVendorList", (Object)dbVendorList);
    }

    public static void updateJDBCPoolWizard(HandlerContext handlerCtx) {
        Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)pool.get("ResType");
        String dbVendor = (String)extra.get("DBVendor");
        String previousResType = (String)extra.get("PreviousResType");
        String previousDB = (String)extra.get("PreviousDB");
        if (!resType.equals(previousResType) || !dbVendor.equals(previousDB) || GuiUtil.isEmpty((String)extra.get("DatasourceClassname"))) {
            if (!GuiUtil.isEmpty(resType) && !GuiUtil.isEmpty(dbVendor)) {
                String datasourceClassName = "";
                if (resType.equals(DATA_SOURCE)) {
                    datasourceClassName = dataSourceMap.get(dbVendor);
                } else if (resType.equals(XADATA_SOURCE)) {
                    datasourceClassName = XADataSourceMap.get(dbVendor);
                } else if (resType.equals(CCDATA_SOURCE)) {
                    datasourceClassName = CCDataSourceMap.get(dbVendor);
                }
                if (datasourceClassName == null) {
                    datasourceClassName = "";
                }
                extra.put("DatasourceClassname", datasourceClassName);
                Map propsMap = ConnectorRuntime.getConnectionDefinitionPropertiesAndDefaults((String)datasourceClassName);
                handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", propsMap);
            }
            extra.put("PreviousResType", resType);
            extra.put("PreviousDB", dbVendor);
        }
    }

    public static void createJdbcConnectionPool(HandlerContext handlerCtx) {
        try {
            Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            Map properties = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolProperties");
            String name = (String)extra.get("name");
            String datasourceClassname = (String)extra.get("DatasourceClassname");
            String method = (String)pool.get("ConnectionValidationMethod");
            if ("table".equals(method)) {
                String table = (String)pool.get("ValidationTableName");
                if (!GuiUtil.isEmpty(table)) {
                    pool.put("ValidationTableName", table);
                }
            } else {
                pool.remove("ValidationTableName");
            }
            Map<String, String> allOptions = new HashMap<String, String>(pool);
            allOptions = AMXUtil.convertToPropertiesOptionMap(properties, allOptions);
            JDBCConnectionPoolConfig newPool = AMXUtil.getDomainConfig().createJDBCConnectionPoolConfig(name, datasourceClassname, allOptions);
            newPool.setDescription((String)extra.get("Description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJDBCConnectionPoolMaps(HandlerContext handlerCtx) {
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        try {
            Iterator iter = AMXUtil.getDomainConfig().getJDBCConnectionPoolConfigMap().values().iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    JDBCConnectionPoolConfig res = (JDBCConnectionPoolConfig)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    oneRow.put("name", res.getName());
                    oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(res.getName(), selectedList) : false);
                    oneRow.put("resInfo", ConnectorsHandlers.checkEmpty(res.getResType()));
                    oneRow.put("extraInfo", res.getDatasourceClassname());
                    oneRow.put("description", ConnectorsHandlers.checkEmpty(res.getDescription()));
                    result.add(oneRow);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void setDisableConnectionPoolTableField(HandlerContext handlerCtx) {
        String methodValue = (String)handlerCtx.getInputValue("methodValue");
        Field tableField = (Field)handlerCtx.getInputValue("tableField");
        if ("table".equals(methodValue)) {
            tableField.setDisabled(false);
        } else {
            tableField.setDisabled(true);
        }
    }

    static {
        dataSourceMap.put(ORACLE, "oracle.jdbc.pool.OracleDataSource");
        dataSourceMap.put(DERBY, "org.apache.derby.jdbc.ClientDataSource");
        dataSourceMap.put(JAVADB, "org.apache.derby.jdbc.ClientDataSource");
        dataSourceMap.put(DB2, "com.ibm.db2.jdbc.DB2DataSource");
        dataSourceMap.put(MSSQL, "com.ddtek.jdbcx.sqlserver.SQLServerDataSource");
        dataSourceMap.put(SYBASE, "com.sybase.jdbc2.jdbc.SybDataSource");
        dataSourceMap.put(POINTBASE, "com.pointbase.jdbc.jdbcDataSource");
        dataSourceMap.put(CLOUDSCAPE, "com.cloudscape.core.BasicDataSource");
        dataSourceMap.put(INFORMIX, "com.informix.jdbcx.IfxDataSource");
        dataSourceMap.put(MYSQL, "com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        dataSourceMap.put(POSTGRESQL, "org.postgresql.ds.PGSimpleDataSource");
        XADataSourceMap.put(ORACLE, "oracle.jdbc.xa.client.OracleXADataSource");
        XADataSourceMap.put(DERBY, "org.apache.derby.jdbc.ClientXADataSource");
        XADataSourceMap.put(JAVADB, "org.apache.derby.jdbc.ClientXADataSource");
        XADataSourceMap.put(DB2, "com.ibm.db2.jdbc.DB2XADataSource");
        XADataSourceMap.put(MSSQL, "com.ddtek.jdbcx.sqlserver.SQLServerDataSource");
        XADataSourceMap.put(SYBASE, "com.sybase.jdbc2.jdbc.SybXADataSource");
        XADataSourceMap.put(POINTBASE, "com.pointbase.xa.xaDataSource");
        XADataSourceMap.put(CLOUDSCAPE, "com.cloudscape.core.XADataSource");
        XADataSourceMap.put(INFORMIX, "com.informix.jdbcx.IfxXADataSource");
        XADataSourceMap.put(MYSQL, "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource");
        XADataSourceMap.put(POSTGRESQL, "org.postgresql.xa.PGXADataSource");
        CCDataSourceMap.put(ORACLE, "oracle.jdbc.pool.OracleConnectionPoolDataSource");
        CCDataSourceMap.put(DB2, "com.ibm.db2.jdbc.DB2ConnectionPoolDataSource");
        CCDataSourceMap.put(SYBASE, "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource");
        CCDataSourceMap.put(DERBY, "org.apache.derby.jdbc.ClientConnectionPoolDataSource");
        CCDataSourceMap.put(JAVADB, "org.apache.derby.jdbc.ClientConnectionPoolDataSource");
        CCDataSourceMap.put(POSTGRESQL, "org.postgresql.ds.PGConnectionPoolDataSource");
        CCDataSourceMap.put(MYSQL, "com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource");
        resTypeList.add("");
        resTypeList.add(DATA_SOURCE);
        resTypeList.add(XADATA_SOURCE);
        resTypeList.add(CCDATA_SOURCE);
        dbVendorList.add("");
        dbVendorList.add(JAVADB);
        dbVendorList.add(ORACLE);
        dbVendorList.add(DERBY);
        dbVendorList.add(SYBASE);
        dbVendorList.add(DB2);
        dbVendorList.add(POINTBASE);
        dbVendorList.add(POSTGRESQL);
        dbVendorList.add(INFORMIX);
        dbVendorList.add(CLOUDSCAPE);
        dbVendorList.add(MSSQL);
        dbVendorList.add(MYSQL);
    }
}

