/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.faces.model.SelectItem;
import javax.management.Attribute;
import javax.management.AttributeList;

public class LogViewerHandler {
    public static final String GET_DATE_SHORT = "short";
    public static final String GET_DATE_MEDIUM = "medium";
    public static final String GET_DATE_LONG = "long";
    public static final String GET_DATE_FULL = "full";
    public static final String TIME_FORMAT = " HH:mm:ss.SSS";
    public static final String TIME_FORMAT_2 = " HH:mm:ss";
    public static final String TIME_FORMAT_3 = " HH:mm";
    public static final String[] QUERY_SIGNATURE = new String[]{"java.lang.String", "java.lang.Long", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Integer", "java.util.Date", "java.util.Date", "java.lang.String", "java.lang.Boolean", "java.util.List", "java.util.Properties"};
    public static final Integer ONE = new Integer(1);
    public static final Boolean FALSE = new Boolean(false);
    public static final Boolean TRUE = new Boolean(true);
    public static final Integer DEFAULT_NUMBER_TO_DISPLAY = new Integer(40);
    public static final String FIRST_LOG_ROW = "firstLogRow";
    public static final String LAST_LOG_ROW = "lastLogRow";
    public static final String CUSTOM_LOGGER_DELIMITERS = " \t\n\r\f,;:";
    public static final String NVP_DELIMITERS = " \t\n\r\f,;:";
    public static final char EQUALS = '=';
    public static final String SHOW_LEVEL_IMAGE = "showLevelImage";
    public static final String LEVEL_IMAGE_ROOT = "/com_sun_web_ui/images/alerts/";
    public static final long ONE_HOUR = 3600000L;

    public static void getInstancesForDropdown(HandlerContext handlerCtx) {
        try {
            Map serverMap = AMXUtil.getDomainConfig().getServerConfigMap();
            String[] servers = serverMap == null ? null : serverMap.keySet().toArray(new String[serverMap.size()]);
            SelectItem[] s = ConfigurationHandlers.getModOptions(servers);
            handlerCtx.setOutputValue("Instances", (Object)s);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLogFilesForDropdown(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("Instance");
        try {
            String[] fileNames = ((J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name)).getMonitoringPeer().getServerRootMonitor().getLogging().getLogFileNames("server");
            SelectItem[] f = ConfigurationHandlers.getOptions(fileNames);
            handlerCtx.setOutputValue("LogFileNames", (Object)f);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getCurrentLogFile(HandlerContext handlerCtx) {
        String name = (String)handlerCtx.getInputValue("Instance");
        try {
            String[] fileNames = ((J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name)).getMonitoringPeer().getServerRootMonitor().getLogging().getLogFileNames("server");
            String logFileName = fileNames[0];
            handlerCtx.setOutputValue("LogFileName", (Object)logFileName);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getFirstLastRecord(HandlerContext handlerCtx) {
        String firstLogRow = (String)handlerCtx.getInputValue("FirstRecord");
        String lastLogRow = (String)handlerCtx.getInputValue("LastRecord");
        if (firstLogRow == null) {
            firstLogRow = "0";
        }
        if (lastLogRow == null) {
            lastLogRow = "0";
        }
        int firstRow = 0;
        try {
            firstRow = Integer.parseInt(firstLogRow);
            int lastRow = Integer.parseInt(lastLogRow);
            if (firstRow > lastRow) {
                String temp = firstLogRow;
                firstLogRow = lastLogRow;
                lastLogRow = temp;
                firstRow = lastRow;
            }
            handlerCtx.setOutputValue("First", (Object)firstLogRow);
            handlerCtx.setOutputValue("Last", (Object)lastLogRow);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    public static void checkRunning(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        try {
            if (LogViewerHandler.isServerRunning(instanceName)) {
                handlerCtx.setOutputValue("isRunning", (Object)true);
            } else {
                handlerCtx.setOutputValue("isRunning", (Object)false);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void getDate(HandlerContext handlerCtx) {
        String formatString = (String)handlerCtx.getInputValue("DateFormat");
        int formatType = -1;
        if (formatString.equals(GET_DATE_SHORT)) {
            formatType = 3;
        } else if (formatString.equals(GET_DATE_MEDIUM)) {
            formatType = 2;
        } else if (formatString.equals(GET_DATE_LONG)) {
            formatType = 1;
        } else if (formatString.equals(GET_DATE_FULL)) {
            formatType = 0;
        }
        DateFormat df = null;
        if (formatType == -1) {
            df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(formatString);
        } else {
            df = DateFormat.getDateInstance(formatType, GuiUtil.getLocale());
        }
        handlerCtx.setOutputValue("Date", (Object)df.format(new Date()));
    }

    public void getTime(HandlerContext handlerCtx) {
        try {
            DateFormat df = DateFormat.getTimeInstance(3, GuiUtil.getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(TIME_FORMAT);
            handlerCtx.setOutputValue("Time", (Object)df.format(new Date()));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getLogResultsTable(HandlerContext handlerCtx) {
        String archivedLogFile = (String)handlerCtx.getInputValue("LogFileName");
        Long fromRecord = (Long)handlerCtx.getInputValue("FromRecord");
        Boolean after = (Boolean)handlerCtx.getInputValue("AfterRecord");
        String dateEnabledString = (String)handlerCtx.getInputValue("DateEnabled");
        Object fromDate = handlerCtx.getInputValue("FromDate");
        Object fromTime = handlerCtx.getInputValue("FromTime");
        Object toDate = handlerCtx.getInputValue("ToDate");
        Object toTime = handlerCtx.getInputValue("ToTime");
        Object loggers = handlerCtx.getInputValue("Loggers");
        Object logLevel = handlerCtx.getInputValue("LogLevel");
        Object customLoggers = handlerCtx.getInputValue("CustomLoggers");
        Object nvp = handlerCtx.getInputValue("Nvp");
        Integer numberToDisplay = (Integer)handlerCtx.getInputValue("NumToDisplay");
        Boolean onlyLevel = (Boolean)handlerCtx.getInputValue("OnlyLevel");
        Boolean direction = (Boolean)handlerCtx.getInputValue("LogDateSortDirection");
        Boolean truncMsg = (Boolean)handlerCtx.getInputValue("TruncateMessage");
        Integer truncLenInteger = (Integer)handlerCtx.getInputValue("TruncateLength");
        ArrayList result = new ArrayList();
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        String logFileDir = "";
        Boolean hasResults = new Boolean(false);
        if (instanceName != null && archivedLogFile != null) {
            boolean truncateMessage = true;
            if (truncMsg != null) {
                truncateMessage = truncMsg;
            }
            int truncLen = 100;
            if (truncLenInteger != null) {
                truncLen = truncLenInteger;
            }
            Boolean dateEnabled = null;
            if ("enabled".equals(dateEnabledString)) {
                dateEnabled = TRUE;
            }
            boolean dateEnabledFlag = false;
            if (dateEnabled != null) {
                dateEnabledFlag = dateEnabled;
            }
            if (dateEnabledFlag) {
                fromDate = LogViewerHandler.convertDateTime(handlerCtx, fromDate, fromTime);
                toDate = LogViewerHandler.convertDateTime(handlerCtx, toDate, toTime);
                if (fromDate == null) {
                    GuiUtil.handleError(handlerCtx, "Specific Date Range was chosen, however, date fields are incomplete.");
                }
                if (toDate != null && fromDate != null && ((Date)fromDate).after((Date)toDate)) {
                    GuiUtil.handleError(handlerCtx, "Timestamp value of 'From: ' field " + fromDate + " must not be greater than 'To: ' field value " + toDate);
                }
            } else {
                fromDate = null;
                toDate = null;
            }
            if (logLevel != null && logLevel.toString().trim().length() == 0) {
                logLevel = null;
            }
            if (onlyLevel == null) {
                onlyLevel = FALSE;
            }
            ArrayList<Object> moduleList = null;
            if (loggers != null) {
                int len = ((Object[])loggers).length;
                moduleList = new ArrayList<Object>(len);
                for (int count = 0; count < len; ++count) {
                    Object val = ((Object[])loggers)[count];
                    if (val == null || val.toString().trim().length() == 0) continue;
                    moduleList.add(val);
                }
            }
            if (customLoggers != null && customLoggers.toString().trim().length() != 0) {
                StringTokenizer tok = new StringTokenizer(customLoggers.toString(), " \t\n\r\f,;:");
                if (moduleList == null) {
                    moduleList = new ArrayList();
                }
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token == null || token.length() == 0) continue;
                    moduleList.add(token);
                }
            }
            Properties nvpProps = null;
            if (nvp != null && nvp.toString().trim().length() != 0) {
                nvpProps = new Properties();
                StringTokenizer tok = new StringTokenizer(nvp.toString(), " \t\n\r\f,;:");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token == null || token.length() == 0) continue;
                    try {
                        ArrayList<String> valueList;
                        int equalsIdx = token.indexOf(61);
                        if (equalsIdx < 0) {
                            GuiUtil.handleError(handlerCtx, "Name-Value Pairs must be in the format \"<name>=<value>\".");
                        }
                        String key = null;
                        if ((valueList = (ArrayList<String>)((Hashtable)nvpProps).get(key = token.substring(0, equalsIdx++))) == null) {
                            valueList = new ArrayList<String>();
                            valueList.add(token.substring(equalsIdx));
                            ((Hashtable)nvpProps).put(key, valueList);
                            continue;
                        }
                        valueList.add(token.substring(equalsIdx));
                    }
                    catch (Exception ex) {
                        GuiUtil.handleError(handlerCtx, "Name-Value Pairs must be in the format \"<name>=<value>\".");
                    }
                }
            }
            if (numberToDisplay == null) {
                numberToDisplay = DEFAULT_NUMBER_TO_DISPLAY;
            }
            if (direction == null) {
                direction = FALSE;
            }
            if (after == null) {
                after = direction;
            }
            Object[] params = new Object[QUERY_SIGNATURE.length];
            params[0] = archivedLogFile;
            params[1] = fromRecord;
            params[2] = fromRecord == null ? direction : after;
            params[3] = direction;
            params[4] = numberToDisplay;
            params[5] = fromDate;
            params[6] = toDate;
            params[7] = logLevel;
            params[8] = onlyLevel;
            params[9] = moduleList;
            params[10] = nvpProps;
            ArrayList results = null;
            try {
                results = LogViewerHandler.getLogRecordsUsingQuery(handlerCtx, "com.sun.appserv:name=logmanager,category=runtime,server=" + instanceName, instanceName, params, QUERY_SIGNATURE);
            }
            catch (Exception ex) {
                GuiUtil.handleError(handlerCtx, "Error while querying Log File.");
            }
            List headerRow = (List)((Attribute)results.get(0)).getValue();
            List rowList = (List)((Attribute)results.get(1)).getValue();
            for (List row : rowList) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                if (row.size() != headerRow.size()) {
                    GuiUtil.handleError(handlerCtx, "Row had '" + row.size() + "' columns, header has '" + headerRow.size() + "' columns!");
                }
                oneRow.put("recNumber", row.get(0));
                oneRow.put("dateTime", LogViewerHandler.formatDateForDisplay(GuiUtil.getLocale(), (Date)row.get(1)));
                String msgId = (String)row.get(6);
                String level = (String)row.get(2);
                if (level.equalsIgnoreCase("severe")) {
                    oneRow.put("levelImage", GuiUtil.getMessage("common.errorGif"));
                    oneRow.put(SHOW_LEVEL_IMAGE, new Boolean(true));
                    oneRow.put("diagnosticCauses", LogViewerHandler.getDiagnosticCauses(handlerCtx, msgId));
                    oneRow.put("diagnosticChecks", LogViewerHandler.getDiagnosticChecks(handlerCtx, msgId));
                    oneRow.put("diagnosticURI", LogViewerHandler.getDiagnosticURI(handlerCtx, msgId));
                } else {
                    oneRow.put(SHOW_LEVEL_IMAGE, new Boolean(false));
                    oneRow.put("diagnostic", "");
                }
                oneRow.put("level", level);
                oneRow.put("productName", row.get(3));
                oneRow.put("logger", row.get(4));
                oneRow.put("nvp", row.get(5));
                oneRow.put("messageID", msgId);
                String message = ((String)row.get(7)).trim();
                if (truncateMessage && message.length() > truncLen) {
                    message = message.substring(0, truncLen).concat("...\n");
                }
                message = Util.htmlEscape((String)message);
                oneRow.put("message", message);
                result.add(oneRow);
            }
            logFileDir = LogViewerHandler.getLogFilesDirectory(instanceName);
            if (rowList.size() > 0) {
                handlerCtx.setOutputValue("FirstLogRow", ((List)rowList.get(0)).get(0));
                handlerCtx.setOutputValue("LastLogRow", ((List)rowList.get(rowList.size() - 1)).get(0));
                hasResults = new Boolean(true);
            } else {
                handlerCtx.setOutputValue("FirstLogRow", (Object)"-1");
                handlerCtx.setOutputValue("LastLogRow", (Object)"-1");
            }
        }
        handlerCtx.setOutputValue("LogFileDir", (Object)logFileDir);
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("HasResults", (Object)hasResults);
    }

    private static AttributeList getLogRecordsUsingQuery(HandlerContext handlerCtx, String logManagerObjectName, String instanceName, Object[] params, String[] QUERY_SIGNATURE) {
        AttributeList results = null;
        if (JMXUtil.isValidMBean(logManagerObjectName)) {
            results = (AttributeList)JMXUtil.invoke(logManagerObjectName, "getLogRecordsUsingQuery", params, QUERY_SIGNATURE);
            return results;
        }
        try {
            Class<?> provider = Class.forName("com.sun.enterprise.ee.tools.admingui.handlers.NodeAgentLogProvider");
            Class[] type = new Class[]{String.class, Object[].class};
            Method method = provider.getMethod("getLogRecordsUsingQuery", type);
            Object[] args = new Object[]{instanceName, params};
            results = (AttributeList)method.invoke(null, args);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        return results;
    }

    private static Date parseDateString(SimpleDateFormat fmt, String format, String dateTime) throws ParseException {
        fmt.applyLocalizedPattern(format);
        return fmt.parse(dateTime);
    }

    protected static Date convertDateTime(HandlerContext handlerCtx, Object date, Object time) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date == null || date.toString().trim().length() == 0) {
            return null;
        }
        String dateTime = date.toString() + (time == null ? "" : " " + time.toString());
        DateFormat df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
        if (time != null && df instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)df;
            String formatPrefix = fmt.toLocalizedPattern();
            try {
                date = LogViewerHandler.parseDateString(fmt, formatPrefix + TIME_FORMAT, dateTime);
            }
            catch (ParseException ex) {
                try {
                    date = LogViewerHandler.parseDateString(fmt, formatPrefix + TIME_FORMAT_2, dateTime);
                }
                catch (ParseException ex2) {
                    try {
                        date = LogViewerHandler.parseDateString(fmt, formatPrefix + TIME_FORMAT_3, dateTime);
                    }
                    catch (ParseException ex3) {
                        GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
                    }
                }
            }
        } else if (time != null) {
            df = DateFormat.getDateTimeInstance(3, 1, GuiUtil.getLocale());
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
            }
        } else {
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
            }
        }
        Date convertDate = null;
        try {
            convertDate = (Date)date;
        }
        catch (Exception ex) {
            convertDate = null;
        }
        return convertDate;
    }

    public static String formatDateForDisplay(Locale locale, Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)dateFormat;
            fmt.applyLocalizedPattern(fmt.toLocalizedPattern() + TIME_FORMAT);
            return fmt.format(date);
        }
        dateFormat = DateFormat.getDateTimeInstance(2, 1, locale);
        return dateFormat.format(date);
    }

    public static boolean isServerRunning(String instanceName) {
        ServerRootMonitor serverRootMonitor = AMXUtil.getServerRootMonitor(instanceName);
        return serverRootMonitor != null;
    }

    private static String getDiagnosticCauses(HandlerContext handlerCtx, String msgId) {
        if (msgId == null || "".equals(msgId)) {
            return LogViewerHandler.formatArrayListForDisplay(null);
        }
        Object[] params = new String[]{msgId};
        String[] signatures = new String[]{"String"};
        ArrayList results = (ArrayList)JMXUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=server", "getDiagnosticCausesForMessageId", params, signatures);
        String res = LogViewerHandler.formatArrayListForDisplay(results);
        return res;
    }

    private static String getDiagnosticChecks(HandlerContext handlerCtx, String msgId) {
        if (msgId == null || "".equals(msgId)) {
            return LogViewerHandler.formatArrayListForDisplay(null);
        }
        Object[] params = new String[]{msgId};
        String[] signatures = new String[]{"String"};
        ArrayList results = (ArrayList)JMXUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=server", "getDiagnosticChecksForMessageId", params, signatures);
        String res = LogViewerHandler.formatArrayListForDisplay(results);
        return res;
    }

    private static String getDiagnosticURI(HandlerContext handlerCtx, String msgId) {
        if (msgId == null || "".equals(msgId)) {
            return "";
        }
        Object[] params = new String[]{msgId};
        String[] signatures = new String[]{"String"};
        String res = (String)JMXUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=server", "getDiagnosticURIForMessageId", params, signatures);
        return res;
    }

    protected static String formatArrayListForDisplay(ArrayList diag) {
        if (diag == null || diag.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("<br>");
        for (int i = 0; i < diag.size(); ++i) {
            buf.append((String)diag.get(i));
            buf.append("<br>");
        }
        return buf.toString();
    }

    public static String getLogFilesDirectory(String instanceName) {
        if (LogViewerHandler.isEmpty(instanceName)) {
            return "";
        }
        String dir = "";
        try {
            if (JMXUtil.isValidMBean("com.sun.appserv:name=logmanager,category=runtime,server=" + instanceName)) {
                dir = (String)JMXUtil.invoke("com.sun.appserv:name=logmanager,category=runtime,server=" + instanceName, "getLogFilesDirectory", null, null);
            } else {
                Class<?> provider = Class.forName("com.sun.enterprise.ee.tools.admingui.handlers.NodeAgentLogProvider");
                Class[] type = new Class[]{String.class};
                Method method = provider.getMethod("getLogFilesDirectory", type);
                Object[] args = new Object[]{instanceName};
                dir = (String)method.invoke(null, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dir;
    }

    public void getFormatedDateTime(HandlerContext handlerCtx) {
        String ts = (String)handlerCtx.getInputValue("Timestamp");
        Boolean addHour = (Boolean)handlerCtx.getInputValue("AddHour");
        Date date = null;
        date = ts == null || "".equals(ts) ? new Date(System.currentTimeMillis()) : (addHour != null ? new Date(Long.parseLong(ts) + 3600000L) : new Date(Long.parseLong(ts)));
        DateFormat df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
        DateFormat tf = DateFormat.getTimeInstance(2, GuiUtil.getLocale());
        ((SimpleDateFormat)tf).applyLocalizedPattern(TIME_FORMAT);
        String ftime = tf.format(date);
        String fdate = df.format(date);
        handlerCtx.setOutputValue("Time", (Object)ftime);
        handlerCtx.setOutputValue("Date", (Object)fdate);
    }

    public static void getLoggers(HandlerContext handlerCtx) {
        String[] selectedLoggers = (String[])handlerCtx.getInputValue("selectedLoggers");
        String[] loggers = LogViewerHandler.getLoggers(selectedLoggers);
        SelectItem[] options = ConfigurationHandlers.getOptions(loggers);
        handlerCtx.setOutputValue("LoggerList", (Object)options);
    }

    private static String[] getLoggers(String[] selectedLoggers) {
        String[] loggers = new String[]{"javax.enterprise", "javax.enterprise.resource", "javax.enterprise.resource.corba", "javax.enterprise.resource.javamail", "javax.enterprise.resource.jdo", "javax.enterprise.resource.jms", "javax.enterprise.resource.jta", "javax.enterprise.resource.resourceadapter", "javax.enterprise.resource.webservices", "javax.enterprise.resource.webservices.registry", "javax.enterprise.resource.webservices.rpc", "javax.enterprise.resource.webservices.saaj", "javax.enterprise.system", "javax.enterprise.system.container", "javax.enterprise.system.container.cmp", "javax.enterprise.system.container.ejb", "javax.enterprise.system.container.mdb", "javax.enterprise.system.container.web", "javax.enterprise.system.core", "javax.enterprise.system.core.classloading", "javax.enterprise.system.core.config", "javax.enterprise.system.core.naming", "javax.enterprise.system.core.security", "javax.enterprise.system.core.transaction", "javax.enterprise.system.stream.out", "javax.enterprise.system.stream.err", "javax.enterprise.system.tools.admin", "javax.enterprise.system.tools.deployment", "javax.enterprise.system.tools.verifier"};
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (selectedLoggers != null) {
            set.addAll(Arrays.asList(selectedLoggers));
        }
        set.addAll(Arrays.asList(loggers));
        return set.toArray(new String[0]);
    }

    private static boolean isEmpty(String test) {
        return test == null || "".equals(test);
    }
}

