/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.Status;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JMXUtil {
    public static final String DomainDiagnosticsMBeanName = "com.sun.appserv:type=DomainDiagnostics,name=server,category=monitor";
    public static final String DomainDiagnosticsGenerateReportMethod = "generateReport";

    public static MBeanServerConnection getMBeanServer() {
        return MBeanServerFactory.getMBeanServer();
    }

    public static Object invoke(String objectName, String operationName, Object[] params, String[] signature) {
        try {
            Object result = JMXUtil.invoke(new ObjectName(objectName), operationName, params, signature);
            return result;
        }
        catch (MalformedObjectNameException ex) {
            System.out.println("MalformedObjectNameException: " + objectName);
            throw new RuntimeException(ex);
        }
    }

    public static Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) {
        try {
            Object result = JMXUtil.getMBeanServer().invoke(objectName, operationName, params, signature);
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public static Object getAttribute(String objectName, String attributeName) {
        try {
            Object result = JMXUtil.getAttribute(new ObjectName(objectName), attributeName);
            return result;
        }
        catch (MalformedObjectNameException ex) {
            return null;
        }
    }

    public static Object getAttribute(ObjectName objectName, String attributeName) {
        try {
            return JMXUtil.getMBeanServer().getAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void setAttribute(String objectName, Attribute attributeName) {
        try {
            JMXUtil.setAttribute(new ObjectName(objectName), attributeName);
        }
        catch (MalformedObjectNameException ex) {
            System.out.println("MalformedObjectNameException: " + objectName);
            throw new RuntimeException(ex);
        }
    }

    public static void setAttribute(ObjectName objectName, Attribute attributeName) {
        try {
            JMXUtil.getMBeanServer().setAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object getDefaultAttributeValue(String objName, String[] params) {
        String operName = "getDefaultAttributeValue";
        String[] signature = new String[]{"java.lang.String"};
        Object defaultValue = JMXUtil.invoke(objName, operName, (Object[])params, signature);
        return defaultValue;
    }

    public static boolean isValidMBean(String objectName) {
        boolean valid = false;
        try {
            Set<ObjectInstance> beans = JMXUtil.getMBeanServer().queryMBeans(new ObjectName(objectName), null);
            if (beans.size() > 0) {
                valid = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    public static void stopServerInstance(String serverName) {
        if (serverName.equals("server")) {
            JMXUtil.invoke("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime", "stop", null, null);
        } else {
            JMXUtil.invoke("com.sun.appserv:type=server,category=config,name=" + serverName, "stop", null, null);
        }
    }

    public static void startServerInstance(String serverName) {
        JMXUtil.invoke("com.sun.appserv:type=servers,category=config", "startServerInstance", new Object[]{serverName}, new String[]{"java.lang.String"});
        int state = ((J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(serverName)).getstate();
        while (state == 0) {
            try {
                Thread.sleep(1000L);
                state = ((J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(serverName)).getstate();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    public static void clusterAction(String clusterName, Boolean start) {
        Object[] params = new Object[]{null, clusterName};
        String[] types = new String[]{"java.lang.String", "java.lang.String"};
        String action = start != false ? "startCluster" : "stopCluster";
        JMXUtil.invoke("com.sun.appserv:type=clusters,category=config", action, params, types);
    }

    public static String getStatusForDisplay(String objName) {
        String status = null;
        try {
            RuntimeStatus sts = (RuntimeStatus)JMXUtil.invoke(objName, "getRuntimeStatus", null, null);
            boolean restartNeeded = sts.isRestartNeeded();
            Status s = sts.getStatus();
            int statusCode = s.getStatusCode();
            String statusString = "";
            String imageString = "";
            switch (statusCode) {
                case 1: {
                    imageString = AMXUtil.getStatusImage(0);
                    statusString = GuiUtil.getMessage("common.startingState");
                    break;
                }
                case 0: {
                    if (restartNeeded) {
                        imageString = GuiUtil.getMessage("common.restartRequiredImage");
                        statusString = GuiUtil.getMessage("common.restartRequired");
                        break;
                    }
                    imageString = AMXUtil.getStatusImage(1);
                    statusString = GuiUtil.getMessage("common.runningState");
                    break;
                }
                case 2: {
                    imageString = AMXUtil.getStatusImage(2);
                    statusString = GuiUtil.getMessage("common.stoppingState");
                    break;
                }
                case 3: {
                    imageString = AMXUtil.getStatusImage(3);
                    statusString = GuiUtil.getMessage("common.stoppedState");
                }
            }
            status = imageString + "&nbsp;" + statusString;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    public static RuntimeStatus getRuntimeStatus(String name) {
        String objName = "com.sun.appserv:type=server,name=" + name + ",category=config";
        RuntimeStatus sts = null;
        try {
            sts = (RuntimeStatus)JMXUtil.invoke(objName, "getRuntimeStatus", null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sts;
    }

    public static int getRuntimeStatusCode(RuntimeStatus rsts) {
        Status status;
        int statusCode = -1;
        if (rsts != null && (status = rsts.getStatus()) != null) {
            statusCode = status.getStatusCode();
        }
        return statusCode;
    }
}

