/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework.jboss;

import com.sun.jbi.framework.JBIFramework;
import com.sun.jbi.framework.StringTranslator;
import com.sun.jbi.framework.jboss.JBossASJBIFrameworkMBean;
import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

public class JBossASJBIFramework
extends JBIFramework
implements JBossASJBIFrameworkMBean {
    private Logger mLog;
    private String mInstallRoot;
    private String mInstanceRoot;
    private static final String JBOSS_NAMING_PREFIX = "";
    private StringTranslator mTranslator;
    private JMXConnectorServer mConnectorServer;

    public void create() throws Exception {
        this.mLog = Logger.getLogger(this.getClass().getPackage().getName());
        this.mLog.info("JBI Framework - Creating");
        String jbossurl = System.getProperty("jboss.server.home.url");
        URI jbossuri = new URI(jbossurl);
        this.mInstallRoot = jbossuri.getPath();
        this.mInstanceRoot = jbossuri.getPath();
        try {
            InitialContext ctx = new InitialContext();
            Context subctx = null;
            try {
                Object obj = ctx.lookup("jbi");
                subctx = (Context)obj;
            }
            catch (NamingException ne) {
                subctx = ctx.createSubcontext("jbi");
            }
            this.mConnectorServer.start();
            super.startup(ctx, JBOSS_NAMING_PREFIX);
        }
        catch (JBIException sje) {
            sje.printStackTrace();
            throw sje;
        }
        this.mLog.info("JBI Framework - Created");
    }

    public void destroy() {
        try {
            super.terminate();
            this.mLog.info("JBI Framework - Destroyed");
        }
        catch (JBIException rje) {
            rje.printStackTrace();
        }
    }

    public void start() throws Exception {
        try {
            super.ready(false);
        }
        catch (Exception rje) {
            rje.printStackTrace();
            throw rje;
        }
        this.mLog.info("JBI Framework - Started");
    }

    public void stop() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            ctx.unbind("jbi");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            super.shutdown();
            this.mLog.info("JBI Framework - Stopped");
            this.mConnectorServer.stop();
            this.mLog.info("JBI RMI Connector server stopped ");
        }
        catch (JBIException rje) {
            rje.printStackTrace();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
    }

    private void startJMXConnectorServer(MBeanServer mbs) {
        try {
            ObjectName mbeanName = new ObjectName("jboss:service=Naming");
            Integer port = (Integer)mbs.getAttribute(mbeanName, "Port");
            String jmxurl = "service:jmx:rmi:///jndi/jnp://localhost:" + port.toString() + "/jbiconnector";
            JMXServiceURL url = new JMXServiceURL(jmxurl);
            this.mConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbs);
            this.mLog.info("RMI Connector server started - JMXServiceURL to access    the mbean server would be " + jmxurl);
        }
        catch (Exception e) {
            this.mLog.severe("Cannot create Connector " + e.getMessage());
        }
    }

    public TransactionManager getTransactionManager() throws Exception {
        InitialContext ctx = this.getEnvironment().getNamingContext();
        TransactionManager transactionManager = (TransactionManager)ctx.lookup("java:/TransactionManager");
        return transactionManager;
    }
}

