/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.registry;

import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.RegistrySpec;
import com.sun.jbi.management.registry.RegistryType;
import com.sun.jbi.management.registry.UnsupportedRegistryTypeException;
import com.sun.jbi.management.registry.xml.RegistryImpl;
import java.util.HashMap;
import java.util.Set;

public class RegistryBuilder {
    private static HashMap<String, Registry> sRegistryCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry buildRegistry(RegistrySpec spec) throws UnsupportedRegistryTypeException, RegistryException {
        String regFolder = spec.getProperties().getProperty("com.sun.jbi.registry.folder");
        Registry registry = null;
        if (spec.getType().equals((Object)RegistryType.XML)) {
            HashMap<String, Registry> hashMap = sRegistryCache;
            synchronized (hashMap) {
                if (!sRegistryCache.containsKey(regFolder)) {
                    registry = new RegistryImpl(spec);
                    sRegistryCache.put(regFolder, registry);
                } else {
                    registry = sRegistryCache.get(regFolder);
                }
                return registry;
            }
        }
        throw new UnsupportedRegistryTypeException(spec.getType().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyRegistry() {
        HashMap<String, Registry> hashMap = sRegistryCache;
        synchronized (hashMap) {
            Set<String> folderList = sRegistryCache.keySet();
            for (String folder : folderList) {
                Registry registry = sRegistryCache.get(folder);
                registry.destroy();
                registry = null;
                sRegistryCache.remove(folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyRegistry(String folder) {
        HashMap<String, Registry> hashMap = sRegistryCache;
        synchronized (hashMap) {
            if (sRegistryCache.containsKey(folder)) {
                Registry registry = sRegistryCache.get(folder);
                registry.destroy();
                registry = null;
                sRegistryCache.remove(folder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry getRegistryInstance(String folder) {
        HashMap<String, Registry> hashMap = sRegistryCache;
        synchronized (hashMap) {
            if (sRegistryCache.containsKey(folder)) {
                return sRegistryCache.get(folder);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initCache() {
        Class<RegistryBuilder> clazz = RegistryBuilder.class;
        synchronized (RegistryBuilder.class) {
            sRegistryCache = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        RegistryBuilder.initCache();
    }
}

