/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.util;

import com.sun.jbi.management.MBeanNames;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class FileTransfer {
    private String mInstanceName;
    private MBeanNames mMBeanNames;
    private MBeanServerConnection mMBnSvr;
    private ObjectName mUploadMBeanName;

    public FileTransfer(String instanceName, MBeanNames mbeanNames, MBeanServerConnection mbns) {
        this.mInstanceName = instanceName;
        this.mMBeanNames = mbeanNames;
        this.mMBnSvr = mbns;
    }

    public String uploadFile(String srcPath) throws Exception {
        int count;
        byte[] buf = new byte[8042];
        File srcFile = new File(srcPath);
        FileInputStream fis = new FileInputStream(srcFile);
        Object upId = this.initiateUpload(srcFile.getName());
        while ((count = fis.read(buf)) != -1) {
            if (buf.length != count) {
                byte[] tmp = new byte[count];
                System.arraycopy(buf, 0, tmp, 0, count);
                buf = tmp;
            }
            this.uploadBytes(upId, buf);
        }
        this.terminateUpload(upId);
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        return this.getArchiveURL(upId);
    }

    private ObjectName getUploadMBeanName() throws Exception {
        if (this.mUploadMBeanName == null) {
            this.mUploadMBeanName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Upload, this.mInstanceName);
        }
        return this.mUploadMBeanName;
    }

    private Object initiateUpload(String fileName) throws Exception {
        Object[] params = new Object[]{fileName};
        String[] sign = new String[]{"java.lang.String"};
        return this.mMBnSvr.invoke(this.getUploadMBeanName(), "initiateUpload", params, sign);
    }

    private void uploadBytes(Object upId, byte[] buf) throws Exception {
        Object[] params = new Object[]{upId, buf};
        String[] sign = new String[]{"java.lang.Object", "[B"};
        this.mMBnSvr.invoke(this.getUploadMBeanName(), "uploadBytes", params, sign);
    }

    private void terminateUpload(Object upId) throws Exception {
        Object[] params = new Object[]{upId};
        String[] sign = new String[]{"java.lang.Object"};
        this.mMBnSvr.invoke(this.getUploadMBeanName(), "terminateUpload", params, sign);
    }

    private String getArchiveURL(Object upId) throws Exception {
        Object[] params = new Object[]{upId};
        String[] sign = new String[]{"java.lang.Object"};
        return (String)this.mMBnSvr.invoke(this.getUploadMBeanName(), "getArchiveURL", params, sign);
    }
}

